/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_MANAGER;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_VALIDATION_RULES;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.RULE_ENGINE;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.UiValidationGroup;
import com.ericsson.cms.epgmgmt.client.rules.ValidationRulesDataProvider.IBusyNotifier;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl.SortFeatureImpl;

/**
 * @author amit.r.seth
 * 
 */
public class ValidationRulesTabPanel extends AbstractRulesTabPanel {
	
	private static final String EPG_VALIDATION_RULES_CREATE = EPG_MANAGER + "." + RULE_ENGINE + "." + EPG_VALIDATION_RULES + ".Create";
	private static final String EPG_VALIDATION_RULES_EDIT = EPG_MANAGER + "." + RULE_ENGINE + "." + EPG_VALIDATION_RULES + ".Edit?id=";
	// table related
	private ValidationRulesDataProvider dataProvider;
	private SortFeatureImpl<Long, UiValidationGroup> sortFeature;
	private ValidationRulesDetailFeature detailFeature;
	
	private Table<Long, UiValidationGroup> table;

	public ValidationRulesTabPanel(HeaderPanel header, RulesListViewPanel parentPanel) {
		super(header, parentPanel);
	}

	/**
	 * @return 
	 * 
	 */
	@Override
    protected Table<Long, UiValidationGroup> createTable() {
		this.dataProvider = new ValidationRulesDataProvider(this);
		dataProvider.setBusyNotifier(new IBusyNotifier() {
			@Override
			public void startingToBeBusy() {
				busyIndicator.center();
			}

			@Override
			public void doneBeingBusy() {
				busyIndicator.hide();
			}
		});
		this.table = new Table<Long, UiValidationGroup>(dataProvider);
		table.addTableViewChangeHandler(new TableViewChangeHandler<Long, UiValidationGroup>() {
			@Override
			public void onShowDetailView(
					TableDetailViewEvent<Long, UiValidationGroup> event) {
				if (event.isCreateView()) {
					header.setLabel(constants.ruleCreateHeading());
				} else {
					header.setLabel(constants.ruleViewEditHeading() + " "
							+ event.getRecord().getName());
					// TODO: Try replacing the widget using anchor here...
					History.newItem(EPG_VALIDATION_RULES_EDIT + event.getRecord().getKey());
				}
			}

			@Override
			public void onShowListView(TableViewEvent event) {
				header.setLabel(constants.ruleListHeading());
			}
		});

		// sort feature
		sortFeature = new SortFeatureImpl<Long, UiValidationGroup>(
				dataProvider.getDefaultSortColumn(), SortOrder.ASCENDING);
		for (Column<?, UiValidationGroup> col : dataProvider.getSortColumns()) {
			sortFeature.addSortableColumn(col);
		}
		dataProvider.setParentSortFeature(sortFeature);

		// detail feature
		detailFeature = new ValidationRulesDetailFeature(this);

		// bookmark feature
		bookmarkFeature = new BookmarkFeatureImpl();

		table.addSortFeature(sortFeature);
		table.addDetailFeature(detailFeature);
		table.addBookmarkFeature(bookmarkFeature);

		return table;
	}

	public void showBusyIndicator() {
		busyIndicator.center();
	}

	public void hideBusyIndicator() {
		busyIndicator.hide();
	}

	@Override
	protected void handleCreate() {
		History.newItem(EPG_VALIDATION_RULES_CREATE);
	}

	@Override
	protected void handleDisable() {
		List<UiValidationGroup> selectedRecords = table.getSelectedRecords();
		if (selectedRecords.size() > 0) {
			showBusyIndicator();
			rpcService.disableValidationGroups(selectedRecords, new AsyncCallback<Void>() {
				
				@Override
				public void onSuccess(Void result) {
					refreshTable();
					hideBusyIndicator();
				}
				
				@Override
				public void onFailure(Throwable caught) {
                	refreshTable();
                    parentPanel.setErrorMessage(messages.disableRuleSetError());
                    hideBusyIndicator();
				}
			});
		} else {
			Window.alert(constants.noRuleSelected());
		}
	}

	@Override
	protected void handleEnable() {
		List<UiValidationGroup> selectedRecords = table.getSelectedRecords();
		if (selectedRecords.size() > 0) {
			showBusyIndicator();
			rpcService.enableValidationGroups(selectedRecords, new AsyncCallback<Void>() {
				
				@Override
				public void onSuccess(Void result) {
					refreshTable();
					hideBusyIndicator();
				}
				
				@Override
				public void onFailure(Throwable caught) {
                	refreshTable();
                    parentPanel.setErrorMessage(messages.enableRuleSetError());
                    hideBusyIndicator();
				}
			});
		} else {
			Window.alert(constants.noRuleSelected());
		}
	}

	@Override
	protected void handleDelete() {
		List<UiValidationGroup> selectedRecords = table.getSelectedRecords();
		if (selectedRecords.size() > 0) {
			if (Window.confirm(messages.deleteRuleSetConfirmation())) {
				showBusyIndicator();
				rpcService.deleteValidationGroups(selectedRecords, new AsyncCallback<Void>() {
					
					@Override
					public void onSuccess(Void result) {
						refreshTable();
						parentPanel.setInfoMessage(messages.deleteRuleSetSuccess());
						hideBusyIndicator();
					}
					
					@Override
					public void onFailure(Throwable caught) {
	                	refreshTable();
	                    parentPanel.setErrorMessage(messages.deleteRuleSetError());
	                    hideBusyIndicator();
					}
				});
			}
		} else {
			Window.alert(constants.noRuleSelected());
		}
	}

}
