package com.ericsson.cms.epgmgmt.client.rules.extend;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.TypedTreeCreator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.BooleanDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.DateDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.TreeItem;


public class EPGActionDataTypeSpecificFieldSelector extends EPGActionFieldSelector {

	// String complaint values
	private static List<TreeItem> stringNonMatchedTreeItem;
	// Integer + String complaint values
	private static List<TreeItem> intNonMatchedTreeItem;
	// float + String complaint values
	private static List<TreeItem> floatNonMatchedTreeItem;
	// Boolean complaint values
	private static List<TreeItem> boolNonMatchedTreeItem;
	// Date complaint values
	private static List<TreeItem> dateNonMatchedTreeItem;
	// Time complaint values
	private static List<TreeItem> timeNonMatchedTreeItem;

	private UIFieldDataType dataType;

	public static void clearCache() {
		stringNonMatchedTreeItem = null;
		intNonMatchedTreeItem = null;
		floatNonMatchedTreeItem = null;
		boolNonMatchedTreeItem = null;
		dateNonMatchedTreeItem = null;
		timeNonMatchedTreeItem = null;
	}

	public EPGActionDataTypeSpecificFieldSelector(
			SelectionHandler<IFieldTreeObject> selectHandler,
			UIFieldDataType dataType) {
		this.dataType = dataType;
		addSelectionHandler(selectHandler);
		initializeNonMatchedTree(dataType);
	}

	private void initializeNonMatchedTree(UIFieldDataType dataType) {
		if (dataType instanceof StringDataType
				&& stringNonMatchedTreeItem == null) {
			stringNonMatchedTreeItem = TypedTreeCreator.getTreeItems(
					getCriteriaType(), getCriteriaMode(), new StringDataType(), true);
		} else if (dataType instanceof IntegerDataType
				&& intNonMatchedTreeItem == null) {
			intNonMatchedTreeItem = TypedTreeCreator.getTreeItems(
					getCriteriaType(), getCriteriaMode(), new IntegerDataType(), true);
		} else if (dataType instanceof FloatDataType
				&& floatNonMatchedTreeItem == null) {
			floatNonMatchedTreeItem = TypedTreeCreator.getTreeItems(
					getCriteriaType(), getCriteriaMode(), new FloatDataType(), true);
		} else if (dataType instanceof BooleanDataType
				&& boolNonMatchedTreeItem == null) {
			boolNonMatchedTreeItem = TypedTreeCreator.getTreeItems(
					getCriteriaType(), getCriteriaMode(), new BooleanDataType(), true);
		} else if (dataType instanceof DateDataType
				&& dateNonMatchedTreeItem == null) {
			dateNonMatchedTreeItem = TypedTreeCreator.getTreeItems(
					getCriteriaType(), getCriteriaMode(), new DateDataType(), true);
		} else if (dataType instanceof TimeDataType
				&& timeNonMatchedTreeItem == null) {
			timeNonMatchedTreeItem = TypedTreeCreator.getTreeItems(
					getCriteriaType(), getCriteriaMode(), new TimeDataType(), true);
		}
	}

	@Override
	public boolean setFieldItem(String assetType, String xpath,
			String rootxpath, UIFieldType fieldType, boolean forMatched) {
		return setFieldItemHelper(assetType, xpath, rootxpath, fieldType, forMatched, getNonMatchedTree());
	}


	private List<TreeItem> getNonMatchedTree() {
		if (dataType instanceof StringDataType) {
			return stringNonMatchedTreeItem;
		}
		if (dataType instanceof TimeDataType) {
			return timeNonMatchedTreeItem;
		}
		if (dataType instanceof IntegerDataType) {
			return intNonMatchedTreeItem;
		}
		if (dataType instanceof FloatDataType) {
			return floatNonMatchedTreeItem;
		}
		if (dataType instanceof DateDataType) {
			return dateNonMatchedTreeItem;
		}
		if (dataType instanceof BooleanDataType) {
			return boolNonMatchedTreeItem;
		}
		return null;
	}

	/**
	 * Will add a variable for selection to the tree.
	 */
	@Override
	public void addMatchedItemToTree(TreeItem item) {
		if (matchedItemAlreadyExists(item)) {
			return;
		}
		TreeItem stub = TypedTreeCreator.cloneMatchedItemRootAssetType(item,
				dataType, true);
		if (stub != null) {
			matchedItem.addItem(stub);
		}
	}


	@Override
	public void onClick(ClickEvent event) {
		onClickHelper(event, getNonMatchedTree());
	}

	public void setDataType(UIFieldDataType dataType) {
		this.dataType = dataType;
	}

	public UIFieldDataType getDataType() {
		return dataType;
	}

	@Override
	protected boolean isInvalidFieldSelection(IFieldTreeObject fieldTree) {
		return super.isInvalidFieldSelection(fieldTree) || fieldTree.getDataType() == null;
	}

	@Override
	protected CriteriaType getCriteriaType() {
		return CriteriaType.ACTION_RHS;
	}

	@Override
	protected UiCriteriaMode getCriteriaMode() {
		return UiCriteriaMode.EPISODE;
	}

}
