package com.ericsson.cms.epgmgmt.client.rules.extend;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleConstants;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.TreeSearcher;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.MatchedItemTreeObj;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TreeWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;



public abstract class EPGActionFieldSelector extends PopupContainer implements
HasSelectionHandlers<IFieldTreeObject>, ClickHandler,
SelectionHandler<TreeItem> {
    private static TreeWidget lastActiveTree;
    private TreeWidget tree;
    private TreeItem selectedItem;
    private ScrollContainer sc;
    private Timer timer;
    private final TitleConstants titleConstants = (TitleConstants) GWT
            .create(TitleConstants.class);
    protected TreeItem matchedItem = new TreeItem(titleConstants.matched()); // NOSONAR

    private int currentPosition = 0;
    private TreeSearcher srchBox;

    public static void clearCache() {
        lastActiveTree = null;
    }

    /**
     * Used for matched items to get the root of the selected field.
     * 
     * @return the root of the selected field if the selected field is a matched
     *         item or null.
     */
    public IFieldTreeObject getSelectedFieldParent() {
        IFieldTreeObject currSelected = getSelectedField();
        if (currSelected instanceof MatchedItemTreeObj) {
            return ((MatchedItemTreeObj) currSelected).getParent();
        }
        return null;
    }

    /**
     * Returns the selected field.
     * 
     * @return the selected field.
     */
    public IFieldTreeObject getSelectedField() {
        if (selectedItem != null) {
            return (IFieldTreeObject) selectedItem.getUserObject();
        }
        return null;
    }

    /**
     * Returns true if the selected item is a matched item.
     * 
     * @return true if the selected item is a matched item.
     */
    public boolean isMatchedItem() {
        return getSelectedField() instanceof MatchedItemTreeObj;
    }

    /**
     * adds a matched item to the tree.
     * 
     * @param item
     */
    public abstract void addMatchedItemToTree(TreeItem item);

    /**
     * Returns true if a treeItem is already part of the matched items
     * @param item
     * @return
     */
    protected boolean matchedItemAlreadyExists(TreeItem item) {
        IFieldTreeObject fieldObject = (IFieldTreeObject) item.getUserObject();

        // Don't add it if it already is part of the list of matched items
        for (int i = 0; i < matchedItem.getChildCount(); i++) {
            if (matchedItem.getChild(i).getUserObject().equals(fieldObject)) {
                return true;
            }
        }
        return false;
    }

    /**
     * Removes a matched item from tree.
     * 
     * @param oldObject
     */
    public void removeMatchedItemFromTree(IFieldTreeObject fieldObject) {

        for (int i = 0; i < matchedItem.getChildCount(); i++) {
            if (matchedItem.getChild(i).getUserObject().equals(fieldObject)) {
                matchedItem.removeItem(matchedItem.getChild(i));
                break;
            }
        }
    }

    /**
     * sets the selected field based on the parameters.
     * 
     * @param assetType
     *            the asset type of the field
     * @param xpath
     *            the xpath of the field
     * @param rootxpath
     *            the rootxpath (used for matched items)
     * @param forMatched
     *            whether this is supposed to be a matched item
     * @throws InvalidFieldException
     *             thrown if the treeObject isn't in the field selector
     */
    public abstract boolean setFieldItem(String assetType, String xpath,
            String rootxpath, UIFieldType fieldType, boolean forMatched);

    protected boolean setFieldItemHelper(String assetType, String xpath,
            String rootxpath, UIFieldType fieldType, boolean forMatched, List<TreeItem> nonMatchedTree) {
        // the following two assignments are a hack to deal with how the field
        // selector matches assets.
        String path = xpath == null ? "" : xpath;

        String rootType = rootxpath;
        if (forMatched && (rootxpath == null || rootxpath.isEmpty())) {
            rootType = assetType;
        }

        if (forMatched) {
            selectedItem = findMatchedFieldItem(assetType, rootType, path, fieldType);
        } else {
            selectedItem = findNonMatchedItem(assetType, path, fieldType, nonMatchedTree);
        }

        if (selectedItem == null) {
            return false;
        }
        SelectionEvent.fire(this,
                (IFieldTreeObject) selectedItem
                .getUserObject());
        return true;
    }

    /**
     * sets the field tree to the item passed.
     * 
     * @param treeObject
     *            The tree object you want to be selected
     * @throws InvalidFieldException
     *             thrown if the treeObject isn't in the field selector
     */
    public boolean setFieldItem(IFieldTreeObject treeObject) {
        if (treeObject instanceof MatchedItemTreeObj) {
            MatchedItemTreeObj mto = (MatchedItemTreeObj) treeObject;
            return setFieldItem(mto.getAssetType(), mto.getField(), mto
                    .getParent().getField(), mto.getFieldType(), true);
        } else {
            return setFieldItem(treeObject.getAssetType(), treeObject
                    .getField(), null, treeObject.getFieldType(), false);
        }

    }

    protected void collapseTree() {
        for (int i = 0; i < tree.getItemCount(); i++) {
            collapseTreeItem(tree.getItem(i));
        }
    }

    protected void collapseTreeItem(TreeItem item) {
        if (item.getState()) {
            item.setState(false);
            for (int i = 0; i < item.getChildCount(); i++) {
                collapseTreeItem(item.getChild(i));
            }
        }
    }

    protected void initializeTree() {
        setAutoHideEnabled(true);
        tree = new TreeWidget();
        srchBox = new TreeSearcher(tree, new SelectionHandler<TreeItem>() {

            @Override
            public void onSelection(SelectionEvent<TreeItem> event) {
                TreeItem item = event.getSelectedItem();
                IFieldTreeObject fieldTree = (IFieldTreeObject) item.getUserObject();
                // Matched is NULL plus Package, and maybe other stuff, don't support
                // actions
                // Matched is NULL plus Package, and maybe other stuff, don't support
                // actions
                if (isInvalidFieldSelection(fieldTree)) {
                    item.setSelected(false);
                    if(selectedItem != null) {
                        selectedItem.setSelected(true);
                    }
                    return;
                }

                tree.setSelectedItem(item, false);
                tree.ensureSelectedItemVisible();
                sc.ensureVisible(item);
                selectedItem = item;
                SelectionEvent.fire(EPGActionFieldSelector.this,
                        (IFieldTreeObject) item
                        .getUserObject());
                srchBox.setFocus();
            }
        });
        tree.addSelectionHandler(this);
        tree.addItem(matchedItem);

        sc = new ScrollContainer();
        sc.setSize("300px", "250px");
        sc.add(tree);

        timer = new Timer() {
            @Override
            public void run() {
                sc.setScrollPosition(currentPosition);
            }
        };
        addScrollHack();
        VerticalPanel container = new VerticalPanel();
        container.add(sc);
        container.add(srchBox);
        setWidget(container);
    }

    protected boolean isInvalidFieldSelection(IFieldTreeObject fieldTree) {
        return fieldTree == null
                || !fieldTree.supportsActions()
                || !fieldTree.supportsCriteriaType(getCriteriaType(),
                        getCriteriaMode());
    }

    /*
     * this is to fix that bloody hack that moves the wheel back and forth
     */
    private void addScrollHack() {
        tree.addMouseDownHandler(new MouseDownHandler() {
            @Override
            public void onMouseDown(MouseDownEvent event) {
                currentPosition = sc.getScrollPosition();
            }
        });

        tree.addMouseUpHandler(new MouseUpHandler() {
            @Override
            public void onMouseUp(MouseUpEvent event) {
                timer.schedule(5);
            }
        });
    }

    protected TreeItem findNonMatchedItem(String assetType, String xpath, UIFieldType fieldType, List<TreeItem> treeItems) {
        for (TreeItem item : treeItems) {
            TreeItem foundItem = findFieldItem(item, assetType, xpath, fieldType);
            if (foundItem != null) {
                return foundItem;
            }
        }
        return null;
    }

    private TreeItem findFieldItem(TreeItem root, String assetType, String xpath, UIFieldType fieldType) {
        // the first item is the root package for non-matched items
        IFieldTreeObject rootObj = (IFieldTreeObject) root.getUserObject();

        if (rootObj != null && rootObj.getFieldType().equals(fieldType)
                && rootObj.getAssetType().equals(assetType)
                && rootObj.getField().equals(xpath)) {
            return root;
        } else {
            for (int i = 0; i < root.getChildCount(); i++) {
                // TODO optimize this ugly crap
                TreeItem item = findFieldItem(root.getChild(i), assetType,
                        xpath, fieldType);
                if (item != null) {
                    return item;
                }
            }
        }
        return null;
    }

    protected TreeItem findMatchedFieldItem(String assetType, String rootxpath,
            String xpath, UIFieldType fieldType) {
        for (int i = 0; i < matchedItem.getChildCount(); i++) {
            MatchedItemTreeObj treeObj = (MatchedItemTreeObj) matchedItem
                    .getChild(i).getUserObject();
            String miField = treeObj.getField();
            String miAssetType = treeObj.getAssetType();
            if (miField.equals(rootxpath) || miField.isEmpty() && miAssetType.equals(rootxpath)) {
                TreeItem item = findFieldItem(matchedItem.getChild(i),
                        assetType, xpath, fieldType);
                if (item != null) {
                    return item;
                }
            }
        }
        return null;
    }

    protected void onClickHelper(ClickEvent event, List<TreeItem> nonMatchedTreeItem) {
        if (tree == null) {
            initializeTree();
        }
        srchBox.reset();
        // don't initialize tree unless user actually clicks on it
        if (lastActiveTree == null || lastActiveTree != tree) {
            for (TreeItem item : nonMatchedTreeItem) {
                tree.addItem(item);
            }
            collapseTree();
            lastActiveTree = tree;
        }

        final Widget widget = (Widget) event.getSource();
        setPopupPositionAndShow(new PopupPanel.PositionCallback() {
            @Override
            public void setPosition(int offsetWidth, int offsetHeight) {
                setPopupPosition(widget.getAbsoluteLeft(), widget
                        .getAbsoluteTop());
            }
        });
        if(selectedItem != null) {
            tree.setSelectedItem(selectedItem, false);
            tree.ensureSelectedItemVisible();
            sc.ensureVisible(selectedItem);
        }
    }

    @Override
    public void onSelection(SelectionEvent<TreeItem> event) {
        TreeItem item = event.getSelectedItem();
        IFieldTreeObject fieldTree = (IFieldTreeObject) item.getUserObject();

        // Matched is NULL plus Package, and maybe other stuff, don't support
        // actions
        if (isInvalidFieldSelection(fieldTree)) {
            item.setSelected(false);
            if(selectedItem != null) {
                selectedItem.setSelected(true);
            }
            return;
        }

        selectedItem = item;
        SelectionEvent.fire(this, (IFieldTreeObject) item.getUserObject());
        hide();
    }

    @Override
    public HandlerRegistration addSelectionHandler(
            SelectionHandler<IFieldTreeObject> handler) {
        return addHandler(handler, SelectionEvent.getType());
    }

    protected abstract CriteriaType getCriteriaType();

    protected abstract UiCriteriaMode getCriteriaMode();
}
