package com.ericsson.cms.epgmgmt.client.rules.extend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleMessages;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRow;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.RHSWidgetFactory;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.SingleValueWidget;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueTextBox;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.StringValidator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.enumeration.EPGNormalizationActionEnum;
import com.ericsson.cms.epgmgmt.client.model.predicate.UiUpdatePredicate;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;



public class EPGNormalizationActionBox extends HorizontalContainer {
    public static final String COMPLEX = "complex";

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT
            .create(EPGComponentConstants.class);

    /*
     * this is a blank copy of the actions so that we don't have to go back to
     * the server to retrieve the list for every action
     */
    private static final String MESSAGE_STYLE = "big-txt-box";
    private static final String SMALL_TEXT = "small-txt";


    private static List<EPGUIAction> actionsList;
    private ListBoxWidget<EPGUIAction> actionsListBox;
    private final SimplePanel fieldRhsContainer = new SimpleContainer();
    private final SimplePanel value1Container = new SimpleContainer();
    private final SimplePanel value2Container = new SimpleContainer();
    private SingleValueWidget value1;
    private SingleValueWidget value2;
    private Label value1Label;
    private Label value2Label;
    private EPGNormalizationActionField fieldLhs;
    private SingleValueWidget fieldRhs;
    private EPGNormalizationRule rule;


    /**For the moment it will be only one action available(UPDATE).
     * And also there is no plan in having actions stored in a data base
     * The actions will be retrieved from enumeration
     * So it can be initialized straight away.
     */
    static {
        List<EPGUIAction> cachedActions = new ArrayList<EPGUIAction>();
        EPGNormalizationActionEnum normActions = EPGNormalizationActionEnum	.UPDATE;
        EPGUIAction action = new EPGUIAction(normActions.toString());
        action.setLabelKey(normActions.toString());
        cachedActions.add(action);
        EPGNormalizationActionBox.setActionsListCache(cachedActions);

    }

    /**
     * creates a blank ActionBox
     * 
     */
    public EPGNormalizationActionBox(EPGNormalizationRule rule,
            Collection<TreeItem> existingMacthedItems) {
        this.rule = rule;
        putItTogether(existingMacthedItems);

    }

    /**
     * Creates an actionBox based on the uiaction provided.
     * 
     * @param uiaction
     *            the uiaction you wish to have this actionbox modeled after.
     */
    public EPGNormalizationActionBox(UiUpdatePredicate updatePredicate, EPGNormalizationRule rule,
            Collection<TreeItem> existingMacthedItems) {
        this.rule = rule;
        putItTogether(existingMacthedItems);
        String sectionType = "";
        String xpath = "";
        String rootxpath = "";
        // Set the field
        xpath = Long.toString(updatePredicate.getEntityMapping().getId());

        sectionType = "EPG";
        boolean fieldFound = fieldLhs.setFieldItem(sectionType, xpath,
                rootxpath, false, UIFieldType.EPG);
        if (!fieldFound) {
            showFieldNotFound(sectionType, xpath);
            return;
        }

        resetValue();
        resetLabels();

        //set fieldRhs if necessary
        String value =updatePredicate.getLiteralValue();
        if(fieldRhs != null){
            remove(fieldRhs);
            fieldRhs.clear();
            fieldRhs = null;

        }
        fieldRhs = RHSWidgetFactory.getEPGRHSWidget(fieldLhs.getSelectedField(),value);
        add(fieldRhs);

    }

    private void showFieldNotFound(String assetType, String xpath) {
        TitleMessages myMessages = (TitleMessages) GWT
                .create(TitleMessages.class);
        rule.addWarningMessage(myMessages.invalidField(assetType + " "
                + xpath));
    }

    public boolean validate() {
        boolean passes = true;
        // User must select a fieldisMatched
        if (fieldLhs.getSelectedField() == null) {
            this.fieldLhs.setErrorState();
            this.rule.addWarningMessage(constants
                    .ruleNormalizationBlankFieldAction());
            passes = false;
        }
        if(fieldRhs.getValue() == null || fieldRhs.getValue().trim().isEmpty()){
            this.rule.addWarningMessage(constants.ruleNormalizationBlankFieldAction());
            if(fieldRhs.getValue() == null){
                fieldRhs = new ValueTextBox(new StringValidator());
            }
        }
        passes = fieldRhs.validate();
        return passes;
    }


    /**
     * adds a matched item (basically a variable) to the field selected
     * 
     * @param item
     */
    public void addMatchedItem(TreeItem item) {
        IFieldTreeObject treeObj = (IFieldTreeObject)item.getUserObject();
        if(treeObj.supportsCriteriaType(CriteriaType.ACTION_LHS, rule.getCriteriaMode())) {
            fieldLhs.addMatchedItemToTree(item);
        }
    }

    private void putItTogether(Collection<TreeItem> existingMacthedItems) {
        fieldLhs = new EPGNormalizationActionField();
        fieldLhs.addSelectionHandler(new SelectionHandler<IFieldTreeObject>() {

            @Override
            public void onSelection(SelectionEvent<IFieldTreeObject> event) {
                filterActions();
            }

        });

        actionsListBox = new ListBoxWidget<EPGUIAction>();
        actionsListBox.addStyleName("small-txt");
        actionsListBox.addStyleName("norm-actions");
        actionsListBox.addChangeHandler(new ChangeHandler() {

            @Override
            public void onChange(ChangeEvent event) {
                resetLabels();
                resetValue();
            }

        });

        for (EPGUIAction action : actionsList) {
            String label = action.getAction();
            actionsListBox.addItem(label, action);
        }

        IFieldTreeObject fieldLhsObj = fieldLhs.getSelectedField();

        if(fieldRhs != null){
            remove(fieldRhs);
            fieldRhs.clear();
            fieldRhs = null;

        }
        fieldRhs = RHSWidgetFactory.getEPGRHSWidget(fieldLhsObj, "");
        add(fieldRhs);


        this.fieldLhs.addStyleName(MESSAGE_STYLE);
        this.fieldLhs.addStyleName(SMALL_TEXT);

        value1Label = new LabelWidget();
        value1Label.setHorizontalAlignment(ALIGN_RIGHT);
        value2Label = new LabelWidget();
        value2Label.setHorizontalAlignment(ALIGN_RIGHT);


        add(fieldLhs);
        add(actionsListBox);
        add(fieldRhs);

        add(value1Label);
        add(value1Container);
        add(value2Label);
        add(value2Container);


        for (TreeItem item : existingMacthedItems) {
            addMatchedItem(item);
        }
    }



    private void resetLabels() {
        EPGUIAction action = actionsListBox.getSelectedItem();
        EPGUIActionParam value1Param = action.getParam(EPGActionParams.VALUE);
        EPGUIActionParam value2Param = action.getParam(EPGActionParams.VALUE2);

        if (value1Param != null && !value1Param.getLabelName().equals("")) {
            value1Label.setText("Value1Param");
        } else {
            value1Label.setText("");
        }
        if (value2Param != null && !value2Param.getLabelName().equals("")) {
            value2Label.setText("value2Param");
        } else {
            value2Label.setText("");
        }
    }

    private void resetValue() {
        IFieldTreeObject treeObject = fieldLhs.getSelectedField();
        EPGUIAction action = actionsListBox.getSelectedItem();
        // take care of value 1
        if (action.containsParam(EPGActionParams.VALUE)) {
            String strValue1 = value1 == null ? "" : value1.getValue();
            value1 = EPGRulesActionValueFactory.getRHSWidget(treeObject, action, strValue1);
            value1Container.setWidget(value1);
        } else {
            value1Container.clear();
        }

        // take care of value 2
        if (action.containsParam(EPGActionParams.VALUE2)) {
            String strValue2 = value2 == null ? "" : value2.getValue();
            value2 = EPGRulesActionValueFactory.getRHSWidget(treeObject, action, strValue2);
            value2Container.setWidget(value2);
        } else {
            value2Container.clear();
        }

        // take care of rhs field
        if (!action.containsParam(EPGActionParams.XPATHRHS)) {
            fieldRhsContainer.clear();
        }
    }

    /*
     * filters actions based on data type
     */
    private void filterActions() {

        EPGUIAction currItem = actionsListBox.getSelectedItem();

        IFieldTreeObject fieldLhsObj = fieldLhs.getSelectedField();
        if(fieldRhs != null){
            remove(fieldRhs);
            fieldRhs.clear();
            fieldRhs = null;

        }

        fieldRhs = RHSWidgetFactory.getEPGRHSWidget(fieldLhsObj, "");
        add(fieldRhs);

        boolean hasSelectedItem = false;
        if (hasSelectedItem) {
            actionsListBox.setSelectedItem(currItem);
        }
    }

    /**
     * return the value of field Right of right hand side
     * @return
     */
    public SingleValueWidget getFieldRhs() {

        return fieldRhs;
    }

    public void setFieldRhs(String value) {

        fieldRhs.setValue(value);
    }

    /**
     * return the value of field Left of right hand side
     * 
     * @return
     */
    public Long getIdOfSelectedEntityMapping() {

        return Long.parseLong(fieldLhs.getSelectedField().getField());
    }




    /**
     * Builds the EPGUIAction object used when saving a RuleSet.
     * 
     * @return A EPGUIAction that represents the contents of this
     *         EPGNormalizationActionBox.
     */
    public EPGUIAction getAction() {
        // get the Action from the action selection drop down
        EPGUIAction result = actionsListBox.getSelectedItem().clone();

        IFieldTreeObject fieldObject = fieldLhs.getSelectedField();
        IFieldTreeObject currParent = fieldLhs.getSelectedFieldParent();

        // Go through all the parameters and set them.
        if (result.containsParam(EPGActionParams.VALUE)) {
            result.getParam(EPGActionParams.VALUE).setValue(value1.getValue());
        }

        if (result.containsParam(EPGActionParams.VALUE2)) {
            result.getParam(EPGActionParams.VALUE2).setValue(value2.getValue());
        }

        if (result.containsParam(EPGActionParams.SECTIONTYPE)) {
            result.getParam(EPGActionParams.SECTIONTYPE).setValue(fieldObject.getAssetType());
        }

        if (result.containsParam(EPGActionParams.XPATH)) {
            result.getParam(EPGActionParams.XPATH).setValue(fieldObject.getField());
        }

        if (result.containsParam(EPGActionParams.ROOTXPATH)) {
            result.getParam(EPGActionParams.ROOTXPATH).setValue(
                    currParent == null ? null : currParent.getField());
        }

        if (result.containsParam(EPGActionParams.FORMATCHED)) {
            result.getParam(EPGActionParams.FORMATCHED).setValue(Boolean.toString(currParent != null));
        }

        if (result.containsParam(EPGActionParams.FIELDTYPE)) {
            result.getParam(EPGActionParams.FIELDTYPE).setValue(
                    fieldObject.getFieldType().toString());
        }
        return result;
    }

    /**
     * It looks like we can remove the predicat row if we do not have a parent.
     * Not exactly sure why tho
     * 
     * @param row
     * @return
     */
    public boolean canRemovePredicateRow(PredicateRow row) {
        IFieldTreeObject fieldObject = this.fieldLhs
                .getSelectedFieldParent();
        IFieldTreeObject rowObject = row.getLhsTreeObject();
        return fieldObject == null || !fieldObject.equals(rowObject);
    }

    /**
     * Sets the static action list.
     * 
     * @param actionsList
     */
    public static void setActionsListCache(List<EPGUIAction> cacheActionsList) {
        actionsList = new ArrayList<EPGUIAction>();
        for (EPGUIAction action : cacheActionsList) {
            actionsList.add(action);
        }
        Collections.sort(actionsList);
    }


    /**
     * Returns true if the cached actions were loaded through
     * setActionsListCache.
     * 
     * @return
     */
    public static boolean cacheLoaded() {
        return actionsList != null;
    }

    public EPGNormalizationRule getRule() {
        return this.rule;
    }



    /**
     * Removes a matched item from the field selector
     * 
     * @param oldObject
     */
    public void removeMatchedItem(IFieldTreeObject oldObject) {
    }
}
