package com.ericsson.cms.epgmgmt.client.rules.extend;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleStyleNames;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.TreeItem;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;



public class EPGNormalizationActionField extends SimpleContainer implements
		SelectionHandler<IFieldTreeObject>, HasSelectionHandlers<IFieldTreeObject> {

	private TextBox txtBox;
	private EPGActionFieldSelector selector;

	public EPGNormalizationActionField() {
		selector = new EPGNormalizationActionFieldSelector(this);
		initializeTextBox();
	}
	
	public EPGNormalizationActionField(UIFieldDataType dataType) {
		selector = new EPGActionDataTypeSpecificFieldSelector(this, dataType);
		initializeTextBox();
	}
	
	private void initializeTextBox() {
		txtBox = new TextBoxWidget();
		txtBox.setReadOnly(true);
		txtBox.addStyleName("black-txt");
		txtBox.addStyleName("small-txt");
		txtBox.setVisibleLength(35);
		txtBox.addClickHandler((ClickHandler) selector);
		setWidget(txtBox);
	}

	@Override
	public void onSelection(SelectionEvent<IFieldTreeObject> event) {
		IFieldTreeObject fieldObject = event.getSelectedItem();
		txtBox.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
		txtBox.setValue(fieldObject.getFullDisplayName());
		txtBox.setTitle(fieldObject.getFullDisplayName());
	}

	@Override
	public HandlerRegistration addSelectionHandler(
			SelectionHandler<IFieldTreeObject> handler) {
		return selector.addSelectionHandler(handler);
	}

	public void setErrorState() {
		txtBox.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
	}

	public void removeMatchedItemFromTree(IFieldTreeObject oldObject) {
		selector.removeMatchedItemFromTree(oldObject);
	}

	public IFieldTreeObject getSelectedFieldParent() {
		return selector.getSelectedFieldParent();
	}

	public IFieldTreeObject getSelectedField() {
		return selector.getSelectedField();
	}

	public boolean isMatchedItem() {
		return selector.isMatchedItem();
	}

	public void addMatchedItemToTree(TreeItem item) {
		selector.addMatchedItemToTree(item);
	}

	public boolean setFieldItem(String assetType, String xpath,
			String rootxpath, boolean forMatched, UIFieldType fieldType) {
		return selector.setFieldItem(assetType, xpath, rootxpath, fieldType, forMatched);
	}
	
	public EPGActionFieldSelector getSelector() {
		return selector;
	}

	public boolean setFieldItem(IFieldTreeObject field) {
		return selector.setFieldItem(field);
	}

}
