package com.ericsson.cms.epgmgmt.client.rules.extend;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.TreeCreator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.ui.TreeItem;


public class EPGNormalizationActionFieldSelector extends EPGActionFieldSelector {

	private static List<TreeItem> nonMatchedTreeItem;
	
	public static void clearCache() {
		EPGActionFieldSelector.clearCache();
		nonMatchedTreeItem = null;
	}

	public EPGNormalizationActionFieldSelector(SelectionHandler<IFieldTreeObject> selectHandler) {
		addSelectionHandler(selectHandler);
		if (nonMatchedTreeItem == null || nonMatchedTreeItem.isEmpty()) {
			nonMatchedTreeItem = TreeCreator.getTreeItems(getCriteriaType(), getCriteriaMode(), true);
		}
	}
	
	@Override
	public void addMatchedItemToTree(TreeItem item) {
		if (!matchedItemAlreadyExists(item)) {
			TreeItem stub = TreeCreator.cloneMatchedItemRootAssetType(item);
			matchedItem.addItem(stub);
		}
	}

	@Override
	public boolean setFieldItem(String assetType, String xpath, String rootxpath, UIFieldType fieldType,
			boolean forMatched) {
		return setFieldItemHelper(assetType, xpath, rootxpath, fieldType, forMatched, nonMatchedTreeItem);
	}

	@Override
	public void onClick(ClickEvent event) {
		onClickHelper(event, nonMatchedTreeItem);
	}

	@Override
	protected CriteriaType getCriteriaType() {
		return CriteriaType.ACTION_LHS_EPG;
	}

	@Override
	protected UiCriteriaMode getCriteriaMode() {
		return UiCriteriaMode.EPISODE;
	}

}
