package com.ericsson.cms.epgmgmt.client.rules.extend;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaPanelType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRow;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorLimited;
import com.ericsson.cms.epgmgmt.client.events.RuleDeleteEvent;
import com.ericsson.cms.epgmgmt.client.events.RuleDeleteHandler;
import com.ericsson.cms.epgmgmt.client.events.RuleReorderEvent;
import com.ericsson.cms.epgmgmt.client.events.RuleReorderHandler;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UiClause;
import com.ericsson.cms.epgmgmt.client.model.UiEntityMapping;
import com.ericsson.cms.epgmgmt.client.model.UiNormalizationRule;
import com.ericsson.cms.epgmgmt.client.model.UiRule;
import com.ericsson.cms.epgmgmt.client.model.enumeration.UiPredicateValueTypeEnum;
import com.ericsson.cms.epgmgmt.client.model.predicate.UiUpdatePredicate;
import com.ericsson.cms.epgmgmt.client.utils.StringUtils;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;


/**
 * This represents a single Normalization Rule within the UI and should be
 * contained within the NormalizationRulePanel
 * 
 */
public class EPGNormalizationRule extends CriteriaListingPanel implements IEPGNormalizationRuleForm {

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT
            .create(EPGComponentConstants.class);
    private IUITitleFilterNode rule;
    private final VerticalContainer actionBoxes = new VerticalContainer();

    private final Map<IFieldTreeObject, TreeItem> variables = new HashMap<IFieldTreeObject, TreeItem>();
    private TextBoxWidget indexWidget;
    private int index;
    private long ruleId = -1;
    private long predicateId = -1;
    private UiNormalizationRule normalizationRule = null;

    public EPGNormalizationRule(int index, boolean enableReordering) {
        this(null, index, enableReordering);
    }

    public EPGNormalizationRule(UiNormalizationRule rule,
            int index, boolean enableReordering) {

        super(UiCriteriaMode.EPISODE);
        if (rule != null) {
            this.normalizationRule = rule;
            this.rule = rule.getUiTitleFilterNode();
            this.predicateId = rule.getPredicate().getId();
            this.ruleId = rule.getId();
        }

        maxLevels = 2;
        this.operatorProvider = new RulesOperatorLimited();


        this.index = index;
        putTheUiTogether();
        enableReorder(enableReordering);
    }

    private Widget buildReorder() {
        SimpleContainer reorderContainer = new SimpleContainer();
        reorderContainer.setStyleName("rule-order-pos");

        // 4chars == MAX 999 rules
        indexWidget = new TextBoxWidget(index + 1 + "");
        indexWidget.setVisibleLength(4);
        indexWidget.setMaxLength(4);
        indexWidget.addChangeHandler(new ChangeHandler() {
            @Override
            public void onChange(ChangeEvent event) {
                String text = indexWidget.getText();
                int newIndex;
                try {
                    newIndex = Integer.parseInt(text) - 1;
                } catch (NumberFormatException ex) {
                    indexWidget.setText(index + 1 + "");
                    return;
                }

                fireEvent(new RuleReorderEvent(EPGNormalizationRule.this, newIndex));
            }
        });

        reorderContainer.add(indexWidget);
        return reorderContainer;
    }

    @Override
    public void enableReorder(boolean reorderEnabled) {
        // if the ruleEnabled is not true set read only
        indexWidget.setReadOnly(!reorderEnabled);
        String style = reorderEnabled ? "rule-order-editable"
                : "rule-order-noneditable";
        indexWidget.setStyleName(style);
    }

    private void putTheUiTogether() {

        getContainer().clear();

        // This sets the border for each rule

        getContainer().add(buildReorder());
        getContainer().add(super.getWarningMessageBox());
        getContainer().add(
                new LabelWidget(constants.normalizationPanelLabel1()));

        ButtonWidget delButton = deleteButton();
        initializeTree(this.rule);
        getContainer().add(
                new LabelWidget(constants.normalizationPanelLabel2()));
        getContainer().add(actionBoxes);
        if (delButton != null) {
            getContainer().add(delButton);
        }

        initializeActions();

        // SET STYLES
        getContainer().setStyleName(CRITERIA_PANEL_CONTAINER_STYLE);
        setStyleName(CRITERIA_PANEL_STYLE);
    }
    /*
     * create a button to delete this rule
     */
    private ButtonWidget deleteButton() {
        if (ClientAuthorizationManager.isAuthorized(Permissions.EPG_CREATE) && ruleId == -1
                || ClientAuthorizationManager.isAuthorized(Permissions.EPG_MODIFY)) {
            ButtonWidget button = new ButtonWidget(
                    constants.buttonLabelDelete(), new ClickHandler() {
                        @Override
                        public void onClick(ClickEvent event) {
                            fireEvent(new RuleDeleteEvent(
                                    EPGNormalizationRule.this));
                        }
                    });
            button.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
            return button;
        }
        return null;
    }

    /*
     * 
     */
    private void initializeActions() {
        if (normalizationRule == null) {
            // brand new action for new rule
            addAction();
        } else {
            // For the moment there is only one action UPDATE so there is no need for action in cosntructor for EPGNormalizationActionBox
            UiUpdatePredicate predicate =(UiUpdatePredicate)normalizationRule.getPredicate();


            EPGNormalizationActionBox abox = new EPGNormalizationActionBox(
                    predicate, this, variables.values());
            actionBoxes.add(abox);

        }
    }

    public void addAction() {
        EPGNormalizationActionBox abox = new EPGNormalizationActionBox(this,
                variables.values());

        actionBoxes.add(abox);
    }

    /**
     * check if a TreeItem has any children which
     * support actions
     * @param item
     * @return
     */
    private boolean hasChildWithActions(TreeItem item) {
        for(int i = 0; i < item.getChildCount(); i++) {
            IFieldTreeObject child = (IFieldTreeObject)item.getChild(i).getUserObject();
            if(child.supportsActions() || hasChildWithActions(item.getChild(i))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setCurrentIndex(int index) {
        this.index = index;
        indexWidget.setText(index + 1 + "");
    }

    @Override
    public int getIndex() {
        return index;
    }

    @Override
    public CriteriaPanelType getCriteriaPanelType() {
        return CriteriaPanelType.RULES;
    }

    public Map<IFieldTreeObject, TreeItem> getVariables() {
        return variables;
    }

    @Override
    public CriteriaType getLhsCriteriaType() {
        return CriteriaType.RULE_CONDITION_LHS_EPG;
    }

    @Override
    public CriteriaType getRhsCriteriaType() {
        return CriteriaType.CONDITION_RHS_EPG;
    }

    /**
     * determines whether a predicate row can be deleted from the criteria
     * listing panel.
     * 
     * @param row
     *            (&& )
     * @return
     */
    @Override
    public boolean canChangePredicateRow(PredicateRow row) {

        /*
         * The goal here is to determine if this predicate row is referenced by
         * an action. For example if there is one predicate row with field
         * assetNameand an action references assetName as a Matched Item than it
         * can't bedeleted until no actions reference it. However if there are
         * two predicaterows with assetName than we are all go for a delete
         * since the action stillmakes sense.
         */

        // determine if there are multiple actions with a reference to that
        // field
        String msg = constants.ruleValidationRemoveActionBeforeChange();
        removeWarningMessage(msg);
        if (getRoot().predicateRowsWithTreeObject(row.getLhsTreeObject()) > 1) {
            return true;
        }
        // if only one action references it than make sure no actions reference
        // it
        for (Widget w : actionBoxes) {
            EPGNormalizationActionBox abox = (EPGNormalizationActionBox) w;
            if (!abox.canRemovePredicateRow(row)) {
                addWarningMessage(msg);
                return false;
            }
        }
        return true;
    }

    @Override
    public void notifyChange(TreeItem item, IFieldTreeObject oldObject) {
        // add the new variable
        if(item != null){
            IFieldTreeObject newItem = (IFieldTreeObject) item.getUserObject();
            if (newItem.supportsMatched()
                    && (newItem.supportsActions() || hasChildWithActions(item))) {
                variables.put(newItem, item);
                for (Widget w : actionBoxes) {
                    EPGNormalizationActionBox abox = (EPGNormalizationActionBox) w;
                    abox.addMatchedItem(item);
                }
            }
        }


        // remove the old object
        notifyRemoval(oldObject);
    }

    @Override
    public void notifyRemoval(IFieldTreeObject treeObject) {
        // remove the old object
        if (treeObject != null && !this.getRoot().contains(treeObject)) {
            variables.remove(treeObject);
            for (Widget w : actionBoxes) {
                EPGNormalizationActionBox abox = (EPGNormalizationActionBox) w;
                abox.removeMatchedItem(treeObject);
            }
        }
    }

    @Override
    public UiRule<?> getRule() {
        List<UiClause> tree = EPGPredicateListToClauseConvertor.getClauseList(getRoot());
        EPGNormalizationActionBox actionBox =(EPGNormalizationActionBox)actionBoxes.getWidget(0);

        UiEntityMapping entity = new UiEntityMapping(actionBox.getIdOfSelectedEntityMapping());
        UiUpdatePredicate predicate = new UiUpdatePredicate();

        predicate.setId(predicateId);
        predicate.setEntityMapping(entity);

        predicate.setLiteralValue(StringUtils.trim(actionBox.getFieldRhs().getValue()));
        predicate.setMappedValue(entity);
        predicate.setPredicateValueType(UiPredicateValueTypeEnum.LITERALVALUE);

        UiNormalizationRule uiRule = new UiNormalizationRule();
        uiRule.setId(ruleId);
        uiRule.setClauses(tree);
        uiRule.setPredicate(predicate);
        uiRule.setOrdering(getIndex());

        return uiRule;
    }

    @Override
    public HandlerRegistration addDeleteHandler(RuleDeleteHandler handler) {
        return addHandler(handler, RuleDeleteEvent.TYPE);
    }

    @Override
    public HandlerRegistration addReorderHandler(RuleReorderHandler handler) {
        return addHandler(handler, RuleReorderEvent.TYPE);
    }

    @Override
    public boolean validate() {

        boolean result = super.validate();

        EPGNormalizationActionBox abox = null;

        if(actionBoxes.getWidget(0) != null){
            abox =(EPGNormalizationActionBox) actionBoxes.getWidget(0);
            if (!abox.validate()) {
                result = false;
            }
        }

        return result;
    }



}
