/**
 * 
 */
package com.ericsson.cms.epgmgmt.client.rules.extend;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateList;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRow;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.PredicateRowBase;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.BaseOperator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.RhsType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.TitleFilterOperator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UITitleFilterConditionNode;
import com.ericsson.cms.epgmgmt.client.model.UiClause;
import com.ericsson.cms.epgmgmt.client.model.UiEntityMapping;
import com.ericsson.cms.epgmgmt.client.model.enumeration.UiConditionValueTypeEnum;
import com.ericsson.cms.epgmgmt.client.model.enumeration.UiRuleClauseJoinPrefixEnum;
import com.ericsson.cms.epgmgmt.client.model.enumeration.UiRuleCompareOperatorEnum;

/**
 * @author amit.r.seth
 *
 */
class EPGPredicateListToClauseConvertor {

    static List<UiClause> getClauseList(PredicateList root) {
        List<UiClause> tree = new ArrayList<UiClause>();
        int order = 0;
        int layer = 0;
        int group = 1;
        populateTree(tree, root, order, layer, group);
        return tree;
    }

    /**
     * grab each tree and populate both levels of the UI. We are only going to
     * deal with two levels right now.
     */
    private static void populateTree(List<UiClause> list,
            PredicateList row, int order, int layer, int group) {

        TitleFilterOperator op = row.getOperator();
        UiRuleClauseJoinPrefixEnum joinPrefix = op == TitleFilterOperator.AND ? UiRuleClauseJoinPrefixEnum.And : UiRuleClauseJoinPrefixEnum.Or;
        int localOrder = order;

        for (PredicateRowBase predNode : row.getChildRowNodes()) {
            if (predNode instanceof PredicateRow) {
                PredicateRow validationRow = (PredicateRow) predNode;
                if (validationRow.hasContents()) {
                    UiClause valueNode = createUiClause(validationRow, joinPrefix, localOrder++, layer, layer == 0 ? 0
                            : group);
                    list.add(valueNode);
                }
            } else if (predNode instanceof PredicateList) {
                PredicateList cl = (PredicateList) predNode;
                List<UiClause> childList = new ArrayList<UiClause>();
                populateTree(childList, cl, localOrder, layer + 1, group++);
                if (!childList.isEmpty()) {
                    list.addAll(childList);
                }
                localOrder += childList.size();
            }
        }
    }

    /*
     * Creates a UI object from a predicate row to be displayed
     */
    private static UiClause createUiClause(PredicateRow row, UiRuleClauseJoinPrefixEnum joinPrefix, int order, int layer, int group) {
        String fieldLhs = row.getLhsTreeObject().getField();
        BaseOperator op = row.getOperatorList()
                .getSelectedItem();
        boolean ignoreCase = row.isIgnoreCase();
        boolean not = row.isNot();

        UiClause condition = null;
        if (row.getRhsType().equals(RhsType.COMPLEX)) {
            // This condition should not arise for the EPG Rules
            List<UITitleFilterConditionNode> children = new ArrayList<UITitleFilterConditionNode>();// NOSONAR
            for (PredicateRowBase r : row.getChildRowNodes()) {
                if (r instanceof PredicateRow) {
                    PredicateRow evalRow = (PredicateRow) r;// NOSONAR
                }
            }
        } else if(row.getRhsType().equals(RhsType.FIELD)) {
            IFieldTreeObject rhs = row.getRhsTreeObject();
            String fieldRhs = rhs.getField();
            condition = new UiClause(new UiEntityMapping(Long.parseLong(fieldLhs)),
                    convertBaseOperatorToRuleCompareEnum(op), joinPrefix,
                    UiConditionValueTypeEnum.mappedField, null,
                    new UiEntityMapping(Long.parseLong(fieldRhs)), layer, order, not, group, ignoreCase);
        } else {
            String value = "";
            List<String> rowList = row.getValue();
            int ctr = 0;
            for (String rowVal : rowList) {
                ctr++;
                value += rowVal;
                if (ctr < rowList.size()) {
                    value += ",";
                }
            }
            condition = new UiClause(new UiEntityMapping(Long.parseLong(fieldLhs)),
                    convertBaseOperatorToRuleCompareEnum(op), joinPrefix,
                    UiConditionValueTypeEnum.value, value,
                    null, layer, order, not, group, ignoreCase);
        }
        return condition;

    }

    private static UiRuleCompareOperatorEnum convertBaseOperatorToRuleCompareEnum(BaseOperator op) {
        if (op.equals(BaseOperator.EQUAL)) {
            return UiRuleCompareOperatorEnum.Equals;
        } else if (op.equals(BaseOperator.LESSTHAN)) {
            return UiRuleCompareOperatorEnum.LessThan;
        } else if (op.equals(BaseOperator.LESSTHANEQUAL)) {
            return UiRuleCompareOperatorEnum.LessThanEqualsTo;
        } else if (op.equals(BaseOperator.GREATERTHAN)) {
            return UiRuleCompareOperatorEnum.GreaterThan;
        } else if (op.equals(BaseOperator.GREATERTHANEQUAL)) {
            return UiRuleCompareOperatorEnum.GreaterThanEqualsTo;
        } else if (op.equals(BaseOperator.IN)) {
            return UiRuleCompareOperatorEnum.In;
        } else if (op.equals(BaseOperator.ISEMPTY)) {
            return UiRuleCompareOperatorEnum.IsEmpty;
        } else if (op.equals(BaseOperator.CONTAINS)) {
            return UiRuleCompareOperatorEnum.Contains;
        } else if (op.equals(BaseOperator.STARTSWITH)) {
            return UiRuleCompareOperatorEnum.StartsWith;
        } else if (op.equals(BaseOperator.ENDSWITH)) {
            return UiRuleCompareOperatorEnum.EndsWith;
        }
        return UiRuleCompareOperatorEnum.Equals;
    }

}
