package com.ericsson.cms.epgmgmt.client.rules.extend;

import java.util.Collection;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.FieldTree.IFieldTreeObject;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.EmptyRHS;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.SingleValueWidget;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueBooleanBox;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueDateBox;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.ValueTextBox;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.FloatValidator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.IRulesValidator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.LongValidator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.StringValidator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.data.validate.TimeValidator;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.BooleanDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.DateDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.FloatDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.IntegerDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.StringDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.TimeDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.specification.option.UIValueOption;


public class EPGRulesActionValueFactory {


    public static SingleValueWidget getRHSWidget(IFieldTreeObject treeObject,
            EPGUIAction action, String value) {

        // If we can't build anything yet go ahead and return an empty text box
        if (treeObject == null || action == null) {
            return new ValueTextBox(new StringValidator());
        }
        UIFieldDataType fieldDataType = treeObject.getDataType();
        String dataTypeStr;
        if(fieldDataType != null) {
            dataTypeStr = fieldDataType.getName();
        } else {
            dataTypeStr = EPGNormalizationActionBox.COMPLEX;
        }

        UIFieldDataType dataType = action.getValueTypeMap().get(dataTypeStr);

        Collection<UIValueOption> suggestedValues = null;
        if (action.useSuggestedValues() && treeObject.supportsSuggestValues()) {
            suggestedValues = treeObject.getSuggestedValues();
        }

        if (dataType == null) {
            return new EmptyRHS();
        } else if (dataType instanceof IntegerDataType) {
            return buildValTextBox(new LongValidator(), value, suggestedValues);
        } else if (dataType instanceof StringDataType) {
            return buildValTextBox(new StringValidator(), value, suggestedValues);
        } else if (dataType instanceof BooleanDataType) {
            return buildBooleanBox(value);
        } else if (dataType instanceof FloatDataType) {
            return buildValTextBox(new FloatValidator(), value, suggestedValues);
        } else if (dataType instanceof DateDataType) {
            return buildDateBox(value);
        } else if (dataType instanceof TimeDataType) {
            return buildValTextBox(new TimeValidator(), value, suggestedValues);
        }
        return new ValueTextBox(new StringValidator());
    }

    private static SingleValueWidget buildValTextBox(IRulesValidator validator,
            String value, Collection<UIValueOption> suggestedValues) {
        if ((value == null || value.isEmpty()) && suggestedValues == null) {
            return new ValueTextBox(validator);
        } else if (value == null || value.isEmpty()) {
            return new ValueTextBox(validator, suggestedValues, false);
        } else if (suggestedValues == null) {
            return new ValueTextBox(validator, value);
        } else {
            return new ValueTextBox(validator, suggestedValues, false, value);
        }
    }

    private static SingleValueWidget buildDateBox(String value) {
        if (value == null || value.isEmpty()) {
            return new ValueDateBox();
        } else {
            return new ValueDateBox(value);
        }
    }

    private static SingleValueWidget buildBooleanBox(String value) {
        if (value == null || value.isEmpty()) {
            return new ValueBooleanBox();
        } else {
            return new ValueBooleanBox(value);
        }
    }
}
