package com.ericsson.cms.epgmgmt.client.rules.extend;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.datatype.UIFieldDataType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.UIFieldType;
import com.google.gwt.user.client.rpc.IsSerializable;


public class EPGUIAction implements IsSerializable, Comparable<EPGUIAction> {

	private String action;
	private String labelKey;
	private String[] xpathFilter;
	private long actionId = -1;
	private Map<String, EPGUIActionParam> paramMap = new HashMap<String, EPGUIActionParam>();
	// I store in a list also so I can remember the order of the params.
	private List<EPGUIActionParam> params = new ArrayList<EPGUIActionParam>();
	private Map<String, UIFieldDataType> valueTypeMap;
	private boolean useSuggestedValues;
	private boolean matchedOnly;
	private boolean allowMatchedLeafNodes;
	private String[] assetTypesAllowed;
	private String[] assetTypesDisallowed;
	private UIFieldType[] fieldTypesAllowed;

	public EPGUIAction() {
		super();
	}

	public EPGUIAction(String action) {
		this.action = action;
	}

	public EPGUIAction(String action, long actionId) {
		this.action = action;
		this.actionId = actionId;
	}

	public String getAction() {
		return action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	/**
	 * @param actionId
	 *            the actionId to set
	 */
	public void setActionId(int actionId) {
		this.actionId = actionId;
	}

	/**
	 * @return the actionId
	 */
	public long getActionId() {
		return actionId;
	}

	public void addParam(String name, String labelName, String value,
			String type) {
		EPGUIActionParam param = new EPGUIActionParam(name, labelName, value, type);
		paramMap.put(name, param);
		params.add(param);
	}

	public void addParam(String name, String value) {
		EPGUIActionParam param = new EPGUIActionParam(name, value);
		paramMap.put(name, param);
		params.add(param);
	}

	public EPGUIActionParam getParam(EPGActionParams paramName) {
		return paramMap.get(paramName.getName());
	}

	public List<EPGUIActionParam> getAllParams() {
		return params;
	}

	public boolean containsParam(EPGActionParams paramName) {
		return paramMap.containsKey(paramName.getName());
	}

	public void SetParamValue(EPGActionParams paramName, String value) {
		if (containsParam(paramName)) {
			paramMap.get(paramName).setValue(value);
		}
	}

	public void setLabelKey(String labelKey) {
		this.labelKey = labelKey;
	}

	public String getLabelKey() {
		return labelKey;
	}

	public boolean allowsField(UIFieldType fieldType, String assetType, String xpath) {
		boolean passesAllowedAsset = this.assetTypesAllowed == null || assetTypesAllowed.length == 0;
		boolean passesDisAllowedAsset = true;
		boolean passesXpathFilter = this.xpathFilter == null || xpathFilter.length == 0;
		boolean passesAllowedFieldType = false;
		
		if (this.xpathFilter != null) {
			for (int i = 0; i < xpathFilter.length; i++) {
				if (xpathFilter[i].equals(xpath)) {
					passesXpathFilter = true;
					break;
				}
			}
		}

		for(UIFieldType fieldTypeAllowed : fieldTypesAllowed) {
			if (fieldType.equals(fieldTypeAllowed)) {
				if(passesXpathFilter && !fieldType.equals(UIFieldType.ASSET)) {
					return true;
				}
				passesAllowedFieldType = true;
				break;
			}
		}
		
		if (this.assetTypesAllowed != null) {
			for(String assetAllowed : assetTypesAllowed) {
				if (assetType.matches(assetAllowed)) {
					passesAllowedAsset = true;
					break;
				}
			}
		}
		
		if (this.assetTypesDisallowed != null) {
			for(String assetDisallowed : assetTypesDisallowed) {
				if (assetType.matches(assetDisallowed)) {
					passesDisAllowedAsset = false;
					break;
				}
			}
		}

		return passesAllowedFieldType && passesAllowedAsset && passesDisAllowedAsset && passesXpathFilter;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((action == null) ? 0 : action.hashCode());
		return result;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof EPGUIAction) {
			String otherAction = ((EPGUIAction) obj).action;
			return this.action.equals(otherAction);
		}
		return false;
	}

	public EPGUIAction clone() {
		EPGUIAction result = new EPGUIAction();
		result.action = this.action;
		result.actionId = this.actionId;
		result.labelKey = this.labelKey;
		/** Don't need to do a deep copy of the value type parameter because it
		 *  should never change
		 */
		result.valueTypeMap = valueTypeMap;
		result.paramMap = new HashMap<String, EPGUIActionParam>();
		result.params = new ArrayList<EPGUIActionParam>();
		result.assetTypesAllowed = assetTypesAllowed;
		result.assetTypesDisallowed = assetTypesAllowed;
		for (EPGUIActionParam param : this.params) {
			EPGUIActionParam newParam = param.clone();
			result.paramMap.put(param.getName(), newParam);
			result.params.add(newParam);
		}
		if (this.xpathFilter != null) {
			result.xpathFilter = new String[this.xpathFilter.length];
			for (int i = 0; i < xpathFilter.length; i++) {
				result.xpathFilter[i] = this.xpathFilter[i];
			}
		}
		return result;
	}

	public void setValueTypeMap(Map<String, UIFieldDataType> valueTypeMap) {
		this.valueTypeMap = valueTypeMap;
	}

	public Map<String, UIFieldDataType> getValueTypeMap() {
		return valueTypeMap;
	}

	public void setXpathFilter(String[] xpathFilter) { //NOSONAR
		this.xpathFilter = xpathFilter; //NOSONAR
	}

	public String[] getXpathFilter() {
		return xpathFilter;
	}

	@Override
	public int compareTo(EPGUIAction uiAction) {
		/* used to put actions in lexicographical order */
		return labelKey.compareToIgnoreCase(uiAction.labelKey);
	}

	public boolean useSuggestedValues() {
		return useSuggestedValues;
	}

	public void setUseSuggestedValues(boolean useSuggestedValues) {
		this.useSuggestedValues = useSuggestedValues;
	}

	public void setMatchOnly(boolean matchedOnly) {
		this.matchedOnly = matchedOnly;

	}

	public boolean isMatchOnly() {
		return matchedOnly;
	}

	public void setAllowMatchedLeafNodes(boolean allowMatchedLeafNodes) {
		this.allowMatchedLeafNodes = allowMatchedLeafNodes;
	}

	public boolean getAllowMatchedLeafNodes() {
		return this.allowMatchedLeafNodes;
	}

	public void setAssetTypesDisallowed(String[] assetTypesDisallowed) { //NOSONAR
		this.assetTypesDisallowed = assetTypesDisallowed; //NOSONAR
	}

	public void setAssetTypesAllowed(String[] assetTypesAllowed) { //NOSONAR
		this.assetTypesAllowed = assetTypesAllowed; //NOSONAR
	}

	/**
	 * @return the assetTypesAllowed
	 */
	public String[] getAssetTypesAllowed() {
		return assetTypesAllowed;
	}

	/**
	 * @return the assetTypesDisallowed
	 */
	public String[] getAssetTypesDisallowed() {
		return assetTypesDisallowed;
	}

	public void setFieldTypesAllowed(UIFieldType[] fieldTypesAllowed) { //NOSONAR
		this.fieldTypesAllowed = fieldTypesAllowed; //NOSONAR
	}
	
	public UIFieldType[] getAllowedFieldTypes() {
		return fieldTypesAllowed;
	}

}
