package com.ericsson.cms.epgmgmt.client.rules.extend;

import com.google.gwt.user.client.rpc.IsSerializable;

public class EPGUIActionParam implements IsSerializable {

	private String name = "";
	private String labelName = "";
	private String value = "";
	private String dataType;

	public EPGUIActionParam() {
		super();
	}

	public EPGUIActionParam(String name, String labelName, String value,
			String dataType) {
		this.setName(name);
		this.setLabelName(labelName);
		this.setValue(value);
		this.setDataType(dataType);
	}
	
	public EPGUIActionParam(String name, String value) {
		this.setName(name);
		this.setValue(value);
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param value
	 *            the value to set
	 */
	public void setValue(String value) {
		this.value = value;
	}

	/**
	 * @return the value
	 */
	public String getValue() {
		return value;
	}

	public void setDataType(String dataType) {
		this.dataType = dataType;
	}

	public String getDataType() {
		return dataType;
	}
	
	public EPGUIActionParam clone() {
		EPGUIActionParam result = new EPGUIActionParam();
		result.name = this.name;
		result.dataType = this.dataType;
		result.value = this.value;
		result.labelName = this.labelName;
		return result;
	}

	public void setLabelName(String labelName) {
		this.labelName = labelName;
	}

	public String getLabelName() {
		return labelName;
	}

}
