package com.ericsson.cms.epgmgmt.client.rules.extend;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.TitleStyleNames;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaListingPanel;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaPanelType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.CriteriaType;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.criteria.UiCriteriaMode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.IUITitleFilterNode;
import com.ericsson.cms.epgmgmt.client.com.tandbergtv.cms.portal.ui.title.client.model.search.RulesOperatorLimited;
import com.ericsson.cms.epgmgmt.client.events.RuleDeleteEvent;
import com.ericsson.cms.epgmgmt.client.events.RuleDeleteHandler;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UiClause;
import com.ericsson.cms.epgmgmt.client.model.UiRule;
import com.ericsson.cms.epgmgmt.client.model.UiValidationRule;
import com.ericsson.cms.epgmgmt.client.model.enumeration.UiRuleErrorLevelEnum;
import com.ericsson.cms.epgmgmt.client.model.predicate.UiLogPredicate;
import com.ericsson.cms.epgmgmt.client.utils.StringUtils;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;



public class EPGValidationRule extends CriteriaListingPanel implements IRuleForm {

    private static final String MESSAGE_STYLE = "big-txt-box";
    private static final String SMALL_TEXT = "small-txt";
    private final EPGComponentConstants constants = (EPGComponentConstants) GWT
            .create(EPGComponentConstants.class);

    private final TextBox actionText;
    private ListBoxWidget<EPGUIAction> actionsList;
    private long ruleId = -1;
    private long predicateId = -1;

    private static List<EPGUIAction> actions;

    /**
     * Constuctor used when loading a brand new rule.
     * 
     * @param parentPanel
     */
    public EPGValidationRule(UiCriteriaMode critMode) {
        super(critMode);
        this.operatorProvider = new RulesOperatorLimited();
        this.actionText = new TextBox();
        this.actionText.addStyleName(MESSAGE_STYLE);
        this.actionText.addStyleName(SMALL_TEXT);

        //no condition exists because this is a brand new rule so pass null
        putTheUiTogether(null);
    }

    /**
     * Constructor used when loading a pre-existing rule.
     * @param contentClasses
     * 
     * @param condition
     *            The condition associated with the rule.
     * @param action
     *            The action associated with the rule.
     * @param parentPanel
     *            the ValidationCriteriaPanel that contains this object
     */
    public EPGValidationRule(UiCriteriaMode critMode, UiRule<UiLogPredicate> rule) {
        super(critMode);
        this.ruleId = rule.getId();
        this.predicateId = rule.getPredicate().getId();
        this.operatorProvider = new RulesOperatorLimited();
        this.actionText = new TextBox();
        this.actionText.addStyleName(MESSAGE_STYLE);
        this.actionText.addStyleName(SMALL_TEXT);

        EPGUIAction action = new EPGUIAction(rule.getPredicate().getErrorLevel().toString(), rule.getPredicate().getId());
        action.addParam(EPGActionParams.MESSAGE.getName(), rule.getPredicate().getLogMessage());
        putTheUiTogether(rule.getUiTitleFilterNode());
        setActionSelected(action);
    }

    /**
     * UI externally depends on a rule and list of available actions before it
     * can proceed. This does not occur until action async callback happens
     * 
     * @param condition
     *            the condition to be displayed. When null it is assumed this is
     *            a new condition.
     */
    private void putTheUiTogether(IUITitleFilterNode condition) {

        // populate action list box
        initializeActionDropDown();

        getContainer().add(super.getWarningMessageBox());
        getContainer().add(new Label(constants.validationActionLabel()));

        // Put the Tree in
        initializeTree(condition);

        // action selection row
        HorizontalPanel messageRow = new HorizontalPanel();
        messageRow.add(new Label(constants.returnThis() + " "));
        messageRow.add(actionsList);
        messageRow.add(new Label(constants.message() + " "));
        messageRow.add(actionText);

        Button delButton = deleteButton();

        getContainer().add(messageRow);
        if (delButton != null) {
            getContainer().add(delButton);
        }

        //SET STYLES
        getContainer().setStyleName(CRITERIA_PANEL_CONTAINER_STYLE);
        setStyleName(CRITERIA_PANEL_STYLE);
    }

    /**
     * Initializes the action drop down using the action cache
     */
    private void initializeActionDropDown() {
        actionsList = new ListBoxWidget<EPGUIAction>();
        actionsList.addStyleName(SMALL_TEXT);
        for (EPGUIAction action : actions) {
            String label = action.getAction();
            actionsList.addItem(label, action);
        }
    }

    /**
     * on loading a ruleset this is a helper to load the action. Must be called
     * after populateUi because it depends on the actionsList being initialized.
     * 
     * @param action
     * 
     */
    private void setActionSelected(EPGUIAction action) {
        if (action.containsParam(EPGActionParams.MESSAGE)) {
            EPGUIActionParam param = action.getParam(EPGActionParams.MESSAGE);
            actionText.setText(param.getValue());
        }
        actionsList.setSelectedItem(action);
    }

    @Override
    public UiRule<?> getRule() {
        List<UiClause> tree = EPGPredicateListToClauseConvertor.getClauseList(getRoot());
        EPGUIAction action = actionsList.getSelectedItem().clone();

        UiLogPredicate predicate = new UiLogPredicate(StringUtils.trim(actionText.getText()));
        predicate.setErrorLevel(UiRuleErrorLevelEnum.valueOf(action.getAction()));
        predicate.setId(predicateId);
        UiValidationRule rule = new UiValidationRule(ruleId);
        rule.setClauses(tree);
        rule.setPredicate(predicate);

        return rule;
    }

    /**
     * create a button to delete this rule
     */
    private Button deleteButton() {
        if (ClientAuthorizationManager.isAuthorized(Permissions.EPG_CREATE) && ruleId == -1
                || ClientAuthorizationManager.isAuthorized(Permissions.EPG_MODIFY)) {
            Button button = new Button(constants.buttonLabelDelete(),
                    new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    fireEvent(new RuleDeleteEvent(
                            EPGValidationRule.this));
                }
            });
            button.addStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE);
            return button;
        }
        return null;
    }

    @Override
    public HandlerRegistration addDeleteHandler(RuleDeleteHandler handler) {
        return addHandler(handler, RuleDeleteEvent.TYPE);
    }

    @Override
    public boolean validate() {
        boolean result = super.validate();
        if (actionText.getText().equals("")) {
            this.addWarningMessage(constants.ruleValidationBlankMessage());
            actionText.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
            actionText.addChangeHandler(new ActionTextChangeHandler());
            result = false;
        }
        else if (actionText.getText().length() > 1024) {
            this.addWarningMessage(constants.ruleValidationTooLongMessage());
            actionText.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
            actionText.addChangeHandler(new ActionTextChangeHandler());
            result = false;
        }
        return result;
    }

    /**
     * sets the cached actions. Setter should be called from ValidationRulePanel
     * 
     * @param cachedActions
     *            the action list to be stored in the cache.
     */
    public static void setCachedActions(List<EPGUIAction> cachedActions) {
        actions = cachedActions;
    }

    public static List<EPGUIAction> getCachedActions() {
        return actions;
    }

    /**
     * returns the cached actions. Setter should be called from
     * ValidationRulePanel
     * 
     * @return the cached actionList or null if it hasn't been loaded yet.
     */
    public static boolean cacheLoaded() {
        return actions != null;
    }

    @Override
    public CriteriaPanelType getCriteriaPanelType() {
        return CriteriaPanelType.RULES;
    }

    private class ActionTextChangeHandler implements ChangeHandler {

        @Override
        public void onChange(ChangeEvent event) {
            clearWarningMessages();
            if (actionText.getText().equals("")) {
                addWarningMessage(constants
                        .ruleValidationBlankMessage());
                actionText.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
            } else if (actionText.getText().length() > 1024) {
                addWarningMessage(constants
                        .ruleValidationTooLongMessage());
                actionText.addStyleName(TitleStyleNames.PINK_BOX_STYLE);
            } else {
                actionText.removeStyleName(TitleStyleNames.PINK_BOX_STYLE);
            }
        }

    }

    @Override
    public CriteriaType getLhsCriteriaType() {
        return CriteriaType.RULE_CONDITION_LHS_EPG;
    }

    @Override
    public CriteriaType getRhsCriteriaType() {
        return CriteriaType.CONDITION_RHS_EPG;
    }

}
