package com.ericsson.cms.epgmgmt.client.task;

import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.model.UIOrderedTask;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.partner.TaskStatusInfoPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Table;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.ScrollContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public abstract class AbstractTaskListViewPanel extends Composite {

    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-EPGPanel";
    private static final String BUTTON_PANEL_STYLE = "epg-tabContainer-buttonPanel";

    private UIPartner partner;
    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);
    private final EPGComponentMessages epgMessages = GWT.create(EPGComponentMessages.class);
    private final ScrollContainer tableContainer = new ScrollContainer();
    private MessageArea messageArea;
    private final HorizontalContainer buttonPanel = new HorizontalContainer();
    private Table<Long, UIOrderedTask> taskTable;
    private AbstractTaskDataProvider dataProvider;
    private final BusyIndicator busyIndicator = new BusyIndicator();
    private AbstractTaskDialog taskDialog;
    private final AbstractTaskTab parent;

    public AbstractTaskListViewPanel(UIPartner partner, AbstractTaskTab parent) {
        this.parent = parent;
        if (!ClientAuthorizationManager.isAuthorized(Permissions.EPG_VIEW)) {
            Window.alert(epgMessages.permissionDenied());
            return;
        }
        this.partner = partner;
        init();
    }

    private void init() {
        VerticalContainer mainContainer = new VerticalContainer();
        mainContainer.setSpacing(SPACING);
        mainContainer.setStylePrimaryName(STYLE_NAME);
        initWidget(mainContainer);

        // Add widgets to the main container
        createPanel();
        mainContainer.add(tableContainer);
        
        mainContainer.add(TaskStatusInfoPanel.createStatusBar(constants.jobExecuteLogStatusInofLable()));
        
        createButtonPanel();
        mainContainer.add(buttonPanel);
        refreshTable();
    }


    private void refreshTable() {
        if (!taskTable.isInitialized()) {
            taskTable.initialize(new NeptuneAsyncCallback<Void>() {
                @Override
                public void onNeptuneFailure(Throwable caught) {
                    messageArea.setErrorMessage(caught.getLocalizedMessage());
                }

                @Override
                public void onNeptuneSuccess(Void result) {
                    taskTable.refresh();
                }
            });
        } else {
            taskTable.refresh();
        }
    }

    private void createPanel() {
        taskTable = createTable();
        tableContainer.setWidget(taskTable);
    }

    private Table<Long, UIOrderedTask> createTable() {
        dataProvider = getDataProvider(partner, this);
        dataProvider.setBusyNotifier(busyIndicator);
        return new Table<Long, UIOrderedTask>(dataProvider);
    }

    private void createButtonPanel() {
        buttonPanel.setStyleName(BUTTON_PANEL_STYLE);
        // refresh
        if (ClientAuthorizationManager.isAuthorized(Permissions.EPG_VIEW)) {
            ButtonWidget addButton = new ButtonWidget(constants.buttonLabelCreate());
            addButton.addStyleDependentName("act-towards-save-button");
            final AbstractTaskListViewPanel viewPanel = this;
            addButton.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    taskDialog = getDialog(partner,viewPanel);
                    taskDialog.center();
                }
            });
            buttonPanel.add(addButton);

            ButtonWidget refreshButton = new ButtonWidget(constants.buttonLabelRefresh());
            refreshButton.addStyleDependentName("action-button");
            refreshButton.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    messageArea.reset();
                    taskTable.refresh();
                }
            });
            buttonPanel.add(refreshButton);

            buttonPanel.setVisible(partner.isActive());
        }
    }

    public void refresh() {
        buttonPanel.setVisible(partner.isActive());
        taskTable.refresh();
        parent.updateScrollPanelSize();
    }

    public void setPartner(UIPartner partner) {
        this.partner = partner;
        dataProvider.setPartner(partner);
    }

    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
        dataProvider.setMessageArea(messageArea);
    }

    public MessageArea getMessageArea() {
        return messageArea;
    }

    public AbstractTaskDialog getTaskDialog() {
        return taskDialog;
    }

    public void setTaskDialog(AbstractTaskDialog dialog) {
        this.taskDialog = dialog;
    }

    abstract AbstractTaskDialog getDialog(UIPartner partner, AbstractTaskListViewPanel parent);

    abstract AbstractTaskDataProvider getDataProvider(UIPartner partner, AbstractTaskListViewPanel parent);
}
