package com.ericsson.cms.epgmgmt.client.task;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.partner.AbstractPartnerTab;
import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;

public abstract class AbstractTaskTab extends AbstractPartnerTab {

    private static final String TAB_NAME_TASK = "Task";
    private final EPGComponentConstants constants = GWT.create(EPGComponentConstants.class);
    private final AbstractTaskListViewPanel taskPanel;

    public AbstractTaskTab(UIPartner partner) {
        taskPanel = getTaskPanel(partner);
        taskPanel.setWidth("100%");
        initWidget(taskPanel);
    }


    @Override
    public String getName() {
        return TAB_NAME_TASK;
    }

    @Override
    public String getDisplayName() {
        return constants.providerTaskTab();
    }

    @Override
    public void setSelected(boolean selected) {
        if (!selected) {
            return;
        }

        messageArea.reset();
        updateScrollPanelSize();
    }

    /**
     * Set the partner of the tab, <b>Do Not</b> reload.
     * 
     * @param partnerId
     */
    public void setPartner(UIPartner partner) {
        setPartner(partner, false);
    }

    /**
     * Set the provider ID for the tab and reload it.
     * 
     * @param partnerId
     * @param isReload
     */
    public void setPartner(UIPartner partner, boolean isReload) {
        taskPanel.setPartner(partner);
        if (isReload) {
            refresh();
        }
    }

    public void refresh() {
        taskPanel.refresh();
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        this.messageArea = messageArea;
        taskPanel.setMessageArea(messageArea);
    }
   
    abstract AbstractTaskListViewPanel getTaskPanel(UIPartner partner);

    @Override
    public void reload() {
        taskPanel.refresh();
        updateScrollPanelSize();
    }

    @Override
    public List<String> validate() {
        throw new UnsupportedOperationException();
    }
}
