package com.ericsson.cms.epgmgmt.client.task;

import static com.ericsson.cms.epgmgmt.client.model.UIConstants.EPG_MANAGER;
import static com.ericsson.cms.epgmgmt.client.model.UIConstants.JOB_MANAGEMENT;

import java.util.LinkedList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.Permissions;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.model.enumeration.JobStatus;
import com.ericsson.cms.epgmgmt.client.partner.TaskStatusInfoPanel;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGJobService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGJobServiceAsync;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGTaskService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGTaskServiceAsync;
import com.ericsson.cms.epgmgmt.client.utils.DefaultAsyncCallback;
import com.ericsson.cms.epgmgmt.client.widget.ToggleImage;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable.CellFormatter;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class EPGJobListViewPanel extends Composite implements AnchorChangeListener {

    // spacing between the table and message panel
    private static final int SPACING = 2;
    private static final String STYLE_NAME = "content-AlarmActivityLog";
    private static final String BUTTON_PANEL_STYLE = "epg-tabContainer-buttonPanel";
    private static final String TAB_CONTAINER_STYLE = "epg-tabContainer";

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);
    private final EPGComponentMessages epgMessages = GWT.create(EPGComponentMessages.class);
    private final MessageArea messageArea = new MessageArea();
    private final IEPGTaskServiceAsync taskService = GWT.create(IEPGTaskService.class);
    private final IEPGJobServiceAsync jobService = GWT.create(IEPGJobService.class);
    private FlexTable jobTable;
    private final CancelTaskHandler handler = new CancelTaskHandler();

    public EPGJobListViewPanel() {
        if (!ClientAuthorizationManager.isAuthorized(Permissions.EPG_VIEW)) {
            Window.alert(epgMessages.permissionDenied());
            return;
        }
        init();
    }

    private void init() {
        VerticalContainer mainContainer = new VerticalContainer();
        mainContainer.setSpacing(SPACING);
        mainContainer.setStylePrimaryName(STYLE_NAME);

        HeaderPanel header = new HeaderPanel(constants.jobMgmtLabel());
        // Add widgets to the main container
        mainContainer.add(header);

        FlexTable listPanel = createListPanel();
        HorizontalContainer buttonPanel = createButtonPanel();
        
        Image emptyImage = new Image("cms_epgmgmt_ui/images/layer-indicator-blank.png");

        mainContainer.setStylePrimaryName(STYLE_NAME);

        VerticalContainer contentContainer = new VerticalContainer();
        contentContainer.add(listPanel);
        contentContainer.add(emptyImage);
        contentContainer.add(TaskStatusInfoPanel.createStatusBar(constants.jobExecuteLogStatusInofLable()));

        TabContainer tabContainer = new TabContainer();
        tabContainer.addStyleName(TAB_CONTAINER_STYLE);
        tabContainer.add(contentContainer, constants.jobMgmtRecordLabel());
        tabContainer.selectTab(0);

        mainContainer.add(tabContainer);
        mainContainer.add(buttonPanel);
        messageArea.reset();
        mainContainer.add(messageArea);
        refreshTable();
        createRefreshTimer();

        // /////////////////////////////////

        this.initWidget(mainContainer);
    }

    private Timer createRefreshTimer() {
        final Timer t = new Timer() {
            @Override
            public void run() {
                if(!URL.decode(Window.Location.getHash()).endsWith(EPG_MANAGER +"."+ JOB_MANAGEMENT)){
                    return;
                }
                refreshTable();
            }
        };
        t.scheduleRepeating(5000);//NOSONAR
        return t;
    }

    private void refreshTable() {
        taskService.getAllTasks(new DefaultAsyncCallback<List<UITask>>(messageArea){
            @Override
            public void onNeptuneSuccess(List<UITask> result) {
                addTasks(result);
            }
        });
    }

    protected void addTasks(List<UITask> tasks) {
        int rowCount = jobTable.getRowCount();
        for(int i=rowCount-1;i>0;i--){
            jobTable.removeRow(i);
        }
        addTaskToTable(catogryTasks(tasks));
    }

    private void addTaskToTable(List< List<UITask>> maps) {
        int rowIndex = 1;
        for(List<UITask> partnerTaskEntry: maps){
            addPartnerName(rowIndex,partnerTaskEntry.size(), partnerTaskEntry.get(0).getPartnerName());
            addTask(rowIndex++, partnerTaskEntry.get(0), 1);
            for(int i=1;i< partnerTaskEntry.size();i++){
                UITask task = partnerTaskEntry.get(i);
                addTask(rowIndex++, task, 0);
            }
        }
    }

    private List<List<UITask>> catogryTasks(List<UITask> tasks) {
        List< List<UITask> > maps = new LinkedList< List<UITask>>();
        long partnerId = -1;
        List<UITask> partnerTasks  = new LinkedList<UITask>();
        for(UITask task : tasks){
            if(task.getPartnerId() != partnerId){
                partnerTasks = new LinkedList<UITask>();
                maps.add(partnerTasks);
                partnerId = task.getPartnerId();
            }
            partnerTasks.add(task);
        }
        return maps;
    }

    private void addTask(int row, UITask task, int startColNumber) {
        int colOffset = startColNumber;
        CellFormatter cellFormatter = jobTable.getCellFormatter();
        jobTable.setText(row, colOffset++, task.getName());
        jobTable.setText(row, colOffset++, task.getType());
        cellFormatter.addStyleName(row, colOffset-1, "cellAlignCenter");
        TaskStatusHelper taskStatusHelper = new TaskStatusHelper(task, false);
        ImageWidget widget = new ImageWidget(taskStatusHelper.getImageUrl());
        widget.setTitle(taskStatusHelper.getTitle());
        jobTable.setWidget(row, colOffset++, widget);
        cellFormatter.addStyleName(row, colOffset - 1, "cellAlignCenter");
        jobTable.setText(row, colOffset++, task.getJobStatus().getNodeAddress() == null ? "" : task.getJobStatus()
                .getNodeAddress());
        jobTable.setText(row, colOffset++, task.getJobStatus().getStep());
        boolean isRunning = task.getJobStatus().getJobStatus() ==  JobStatus.RUNNING;
        jobTable.setText(row, colOffset++, isRunning?task.getJobStatus().getProgress() + "%":"--");
        if (isRunning) {
            jobTable.setWidget(row, colOffset++, createCanelWidget(task));
            cellFormatter.addStyleName(row, colOffset-1, "cellAlignCenter");
        }
        else{
            jobTable.setText(row, colOffset++, "");
        }
        if(row%2==1){
            jobTable.getRowFormatter().addStyleName(row, "table-data-odd-row");
        }
        else{
            jobTable.getRowFormatter().addStyleName(row, "table-data-even-row");
        }
        for(int i=startColNumber;i<colOffset ;i++){
            cellFormatter.addStyleName(row, i, "nwt-TableColumnPanel-dataCell nwt-TableColumnPanel-dataCell-text");
        }
    }

    private Widget createCanelWidget(final UITask task){
        ToggleImage<UITask> image = new ToggleImage<UITask>("cms_epgmgmt_ui/images/stop.png", constants.buttonLabelCancel());
        image.setAttached(task);
        image.addClickHandler(handler);
        return image;
    }

    private void addPartnerName(int row, int rowCount, String partnerName) {
        jobTable.setText(row, 0, partnerName);
        jobTable.getFlexCellFormatter().setRowSpan(row, 0, rowCount);
        jobTable.getFlexCellFormatter().addStyleName(row, 0, "nwt-TableColumnPanel-dataCell nwt-TableColumnPanel-dataCell-text");
    }

    private FlexTable createListPanel() {
        jobTable = new FlexTable();
        jobTable.setText(0, 0, constants.jobPartnerNameLable());
        jobTable.setText(0, 1, constants.jobTaskLable());
        jobTable.setText(0, 2, constants.jobTypeLabel());
        jobTable.setText(0, 3, constants.jobStatusLabel());//NOSONAR
        jobTable.setText(0, 4, constants.providerTaskNodeLabel());
        jobTable.setText(0, 5, constants.jobStepLabel());// NOSONAR
        jobTable.setText(0, 6, constants.jobProgressLabel());// NOSONAR
        jobTable.setText(0, 7, constants.actionLabel());      // NOSONAR
        jobTable.getRowFormatter().addStyleName(0, "tableHeaderRow");
        String width = "100px";
        CellFormatter cellFormatter = jobTable.getCellFormatter();
        cellFormatter.setWidth(0, 2, width);//NOSONAR
        cellFormatter.setWidth(0, 3, width);//NOSONAR
        cellFormatter.setWidth(0, 4, width);
        cellFormatter.setWidth(0, 6, width);//NOSONAR
        cellFormatter.setWidth(0, 7, width);// NOSONAR
        jobTable.setWidth("100%");
        jobTable.addStyleName("nwt-TableListViewPanel");
        return jobTable;
    }

    private HorizontalContainer createButtonPanel() {
        HorizontalContainer buttonPanel = new HorizontalContainer();
        buttonPanel.setStyleName(BUTTON_PANEL_STYLE);
        // refresh
        if (ClientAuthorizationManager.isAuthorized(Permissions.EPG_VIEW)) {
            ButtonWidget refreshButton = new ButtonWidget(constants.buttonLabelRefresh());
            refreshButton.addStyleDependentName("action-button");
            refreshButton.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    refreshTable();
                }
            });
            buttonPanel.add(refreshButton);
        }
        return buttonPanel;
    }

    @Override
    public void anchorChanged(String anchor) {
        Window.alert(anchor);
    }

    private final class CancelTaskHandler implements ClickHandler {
        @Override
        public void onClick(ClickEvent event) {
            @SuppressWarnings("unchecked")
            ToggleImage<UITask> src = (ToggleImage<UITask>)event.getSource();
            UITask task = src.getAttached();
            String ingestAction = task.getType().equals("INGEST") ? constants.provider() : constants.publisher();
            final String message = epgMessages.cancelMessage(ingestAction);
            if(Window.confirm(message)) {
                src.setVisible(false);
                jobService.cancel(task.getId(), new AsyncCallback<Void>() {
                    @Override
                    public void onFailure(Throwable caught) {
                        Window.alert(caught.getLocalizedMessage());
                    }
                    @Override
                    public void onSuccess(Void result) {
                    }
                });
            }
        }
    }
}
