package com.ericsson.cms.epgmgmt.client.task;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.EPGFormContainer;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.model.UIConstants;
import com.ericsson.cms.epgmgmt.client.model.UIEndPoint;
import com.ericsson.cms.epgmgmt.client.model.UIEndPointEnum;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.PasswordTextBox;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class EndPointWidget extends Composite {

    private final VerticalContainer mainPanel;
    private final HorizontalContainer listBoxContainer;
    private EPGFormContainer form;
    // end point deails widgets
    private final TextBoxWidget serveripValueWidget = new TextBoxWidget();
    private final TextBoxWidget portValueWidget = new TextBoxWidget();
    private final TextBoxWidget useridValueWidget = new TextBoxWidget();
    private final PasswordTextBox pwdValueWidget = new PasswordTextBox();
    private final TextBoxWidget foldnameValueWidget = new TextBoxWidget();
    private final TextBoxWidget filenameValueWidget = new TextBoxWidget();
    private final TextBoxWidget doneFileWidget = new TextBoxWidget();
    private final EPGComponentConstants constants = GWT.create(EPGComponentConstants.class);
    private final EPGComponentMessages constantsMsg = (EPGComponentMessages) GWT.create(EPGComponentMessages.class);
    private String selectedEndPointName = "";

    public EndPointWidget() {
        mainPanel = new VerticalContainer();
        listBoxContainer = new HorizontalContainer();
        listBoxContainer.setSpacing(1);
        mainPanel.add(listBoxContainer);
        form = new EPGFormContainer(HorizontalContainer.ALIGN_LEFT);
        mainPanel.add(form);
        initForm();
        initWidget(mainPanel);
    }

    private void initForm() {

        serveripValueWidget.setMaxLength(UIConstants.SERVERIP_MAX_LENGTH);
        useridValueWidget.setMaxLength(UIConstants.USERID_MAX_LENGTH);
        pwdValueWidget.setMaxLength(UIConstants.PWD_MAX_LENGTH);
        foldnameValueWidget.setMaxLength(UIConstants.FOLDER_MAX_LENGTH);
        filenameValueWidget.setMaxLength(UIConstants.FILE_MAX_LENGTH);
        doneFileWidget.setMaxLength(UIConstants.DONE_FILE_MAX_LENGTH);

    }

    /**
     * @param endPointName
     * @param uiEndPoint
     */
    public void setData(String endPointName, UIEndPoint uiEndPoint, boolean isUpdate) {

        clear();
        if (endPointName == null) {
            endPointName = "";
        }
        selectedEndPointName = endPointName;
        setEndPointValues(uiEndPoint, selectedEndPointName);

        if (selectedEndPointName.equalsIgnoreCase(UIEndPointEnum.ftp.toString())
                || selectedEndPointName.equalsIgnoreCase(UIEndPointEnum.sftp.toString())) {
            form.addRow(constants.serverip(), serveripValueWidget, true);
            form.addRow(constants.port(), portValueWidget, true);
            form.addRow(constants.userid(), useridValueWidget, true);
            form.addRow(constants.password(), pwdValueWidget);
            form.addRow(constants.folder(), foldnameValueWidget, true);
            form.addRow(constants.filename(), filenameValueWidget, true);
            form.addRow(constants.doneFileCheck(), doneFileWidget);
            if (isUpdate && uiEndPoint.getPort() <= 0) {
                portValueWidget.setText(Integer.toString(UIConstants.DEFAULT_FTP_PORT));
                if (selectedEndPointName.equalsIgnoreCase(UIEndPointEnum.sftp.toString())) {
                    portValueWidget.setText(Integer.toString(UIConstants.DEFAULT_FTPS_PORT));
                }
            }
        } else if (selectedEndPointName.equalsIgnoreCase(UIEndPointEnum.file.toString())) {
            form.addRow(constants.folder(), foldnameValueWidget, true);
            form.addRow(constants.filename(), filenameValueWidget, true);
            form.addRow(constants.doneFileCheck(), doneFileWidget);
        }
        mainPanel.add(form);
    }

    /**
     * @param uiEndPoint
     * @param endPointType
     */

    private void setEndPointValues(UIEndPoint uiEndPoint, String endPointType) {

        if (uiEndPoint != null) {

            if (endPointType.equalsIgnoreCase(UIEndPointEnum.ftp.toString())
                    || endPointType.equalsIgnoreCase(UIEndPointEnum.sftp.toString())) {

                filenameValueWidget.setText(uiEndPoint.getFileName());
                foldnameValueWidget.setText(uiEndPoint.getFolder());
                pwdValueWidget.setText(uiEndPoint.getPassword());
                useridValueWidget.setText(uiEndPoint.getUserName());
                serveripValueWidget.setText(uiEndPoint.getServerIp());
                portValueWidget.setText(Long.toString(uiEndPoint.getPort()));
                doneFileWidget.setText(uiEndPoint.getFileCheck());

            } else if (selectedEndPointName.equalsIgnoreCase(UIEndPointEnum.file.toString())) {
                filenameValueWidget.setText(uiEndPoint.getFileName());
                foldnameValueWidget.setText(uiEndPoint.getFolder());
                doneFileWidget.setText(uiEndPoint.getFileCheck());
            }
        }
    }

    public void clear() {
        clearForm();
        mainPanel.clear();
        mainPanel.remove(form);
        form = new EPGFormContainer(HorizontalPanel.ALIGN_RIGHT);
        mainPanel.add(form);
    }

    public void clearForm() {
        if (form != null) {
            form.clearAllValidationErrors();
        }
    }

    public UIEndPoint setEndPointForm() {

        UIEndPoint retrievalDetails = new UIEndPoint();
        retrievalDetails.setPassword(pwdValueWidget.getValue());
        if (!portValueWidget.getValue().isEmpty() && portValueWidget.getValue() != null) {
            retrievalDetails.setPort(Integer.parseInt(portValueWidget.getValue()));
        }

        retrievalDetails.setServerIp(serveripValueWidget.getValue());
        retrievalDetails.setUserName(useridValueWidget.getValue());
        retrievalDetails.setFileName(filenameValueWidget.getValue().trim());
        String folder = foldnameValueWidget.getValue().trim();
        while (folder.endsWith("/")) {
            folder = folder.substring(0, folder.length()-1);
        }
        if ("".equals(folder)) {
            folder = "/";
        }
        retrievalDetails.setFolder(folder);
        retrievalDetails.setFileCheck(doneFileWidget.getValue().trim());

        if (selectedEndPointName.equalsIgnoreCase(UIEndPointEnum.file.toString())) {

            retrievalDetails.setPort(0);
            retrievalDetails.setServerIp("");
            retrievalDetails.setUserName("");
            retrievalDetails.setPassword("");
        }

        return retrievalDetails;

    }

    public void setSelectedEndPointName(String selectedEndPointName) {
        this.selectedEndPointName = selectedEndPointName;
    }

    public String getSelectedEndPointName() {
        return selectedEndPointName;
    }

    public List<String> validate() {

        List<String> validationMessages = new ArrayList<String>();
        if (validationMessages.size() > 0) {
            validationMessages.clear();
        }
        // It can't contain only numbers if it's null or empty...

        if (selectedEndPointName.equalsIgnoreCase(UIEndPointEnum.ftp.toString())
                || selectedEndPointName.equalsIgnoreCase(UIEndPointEnum.sftp.toString())) {

            if (serveripValueWidget.getText() == null || serveripValueWidget.getText().isEmpty()) {

                validationMessages.add(constantsMsg.requiredIPAddress());
            }
            if (portValueWidget.getText() == null || portValueWidget.getText().isEmpty()) {

                validationMessages.add(constantsMsg.requiredPortNumber());
            }

            if (portValueWidget.getText() != null && !portValueWidget.getText().isEmpty()) {
                boolean present = true;
                for (int i = 0; i < portValueWidget.getText().length(); i++) {

                    // If we find a non-digit character we return false.
                    if (!Character.isDigit(portValueWidget.getText().charAt(i))) {

                        present = false;
                        break;
                    }
                }// end of for

                if (portValueWidget.getText().length() > 5) {
                    present = false;
                }

                if (!present) {
                    validationMessages.add(constantsMsg.invalidPortNumber());
                }
            }
            if (useridValueWidget.getText() == null || useridValueWidget.getText().isEmpty()) {

                validationMessages.add(constantsMsg.requiredUserName());
            }

        }// ftp
        if (foldnameValueWidget.getText() == null || foldnameValueWidget.getText().isEmpty()) {

            validationMessages.add(constantsMsg.requiredFolderName());
        }

        if (filenameValueWidget.getText() == null || filenameValueWidget.getText().isEmpty()) {

            validationMessages.add(constantsMsg.requiredFileName());
        }

        if (foldnameValueWidget.getText() != null && !foldnameValueWidget.getText().isEmpty()) {

            boolean containsWhitespace = foldnameValueWidget.getText().trim().indexOf(" ") != -1;
            if (containsWhitespace) {

                validationMessages.add(constantsMsg.validateWhitespaceFolderName());
            }

        }

        if (filenameValueWidget.getText() != null && !filenameValueWidget.getText().isEmpty()) {

            boolean containsWhitespace = filenameValueWidget.getText().trim().indexOf(" ") != -1;
            if (containsWhitespace) {

                validationMessages.add(constantsMsg.validateWhitespaceFileName());
            }

        }

        if (doneFileWidget.getText() != null && !doneFileWidget.getText().isEmpty()) {

            boolean containsWhitespace = doneFileWidget.getText().trim().indexOf(" ") != -1;
            if (containsWhitespace) {

                validationMessages.add(constantsMsg.validateWhitespaceCheckFileName());
            }
        }
        return validationMessages;
    }

    public EPGFormContainer getFormContainer() {
        return form;
    }

}
