package com.ericsson.cms.epgmgmt.client.task;

import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.EXCLUDE_VALUE_KEY;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.HEADEND_KEY;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.INCLUDE_VALUE_KEY;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.KEY_SPLIT_SYMBOL;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.PROGRAM_KEY;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.PROVIDER_KEY;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.PUBLISHER_FILTERS_KEY;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.SCHEDULE_TIME_DAY_KEY;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.SCHEDULE_TIME_KEY;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.SCHEDULE_TIME_MONTH_KEY;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.SCHEDULE_TIME_WEEK_KEY;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.STATION_KEY;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.ericsson.cms.epgmgmt.client.EPGFormContainer;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.model.UITaskSetting;
import com.ericsson.cms.epgmgmt.client.widget.HeadendStationSelectorPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.i18n.client.TimeZone;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IntegerConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.servertime.internal.IServerTimeService;
import com.tandbergtv.neptune.widgettoolkit.client.widget.servertime.internal.IServerTimeServiceAsync;
import com.tandbergtv.neptune.widgettoolkit.client.widget.servertime.internal.ServerTime;

/**
 * Publisher export setting basic panel
 * 
 * @author Kevin.zhao
 */
public class ExportSettingPanel extends Composite {

    private static final long SCHEDULE_SELECT_BY_MONTH = 1L;
    private static final long SCHEDULE_SELECT_BY_DAY = 0L;
    private static final long SCHEDULE_SELECT_BY_WEEK = 2L;
    private static final long SCHEDULE_SELECT_NONE = -1L;
    private static final long SCHEDULE_SELECT_LAST_MONTH = -1L;
    private static final long SCHEDULE_SELECT_CURR_MONTH = 0L;
    private static final long SCHEDULE_SELECT_NEXT_MONTH = 1L;
    private static final long SCHEDULE_SELECT_LAST_WEEK = -1L;
    private static final long SCHEDULE_SELECT_CURR_WEEK = 0L;
    private static final long SCHEDULE_SELECT_NEXT_WEEK = 1L;
    private static final long SCHEDULE_SELECT_CURR_NEXT_WEEK = 101L;

    private static long categoryKey = SCHEDULE_SELECT_BY_DAY;
    private static long daysInPast = 0L;
    private static long daysInFuture = 14L; // NOSONAR
    private static long monthDelta = 0L;
    private static long weekDelta = 0L;

    private final IServerTimeServiceAsync serverTimeService = GWT.create(IServerTimeService.class);

    private static final String STYLE_EPG_EXPORTSETTING_CHECKBOX_LISTBOX_PADDING = "epg-exportsetting-checkboxListbox-padding";

    private static final EPGComponentMessages CONSTANTS_MSG = (EPGComponentMessages) GWT
            .create(EPGComponentMessages.class);
    private static final String SCHEDULE_TIME_DAYS_IN_FUTURE = CONSTANTS_MSG.scheduleTimeDaysInFuture();
    private static final String SCHEDULE_TIME_DAYS_IN_PAST = CONSTANTS_MSG.scheduleTimeDaysInPast();
    private static final String HEADEND_HELP_ICON_TIP = CONSTANTS_MSG.headendHelpIconTip();
    private static final String STATION_HELP_ICON_TIP = CONSTANTS_MSG.stationHelpIconTip();
    private static final String PROGRAM_HELP_ICON_TIP = CONSTANTS_MSG.programHelpIconTip();
    protected static final String EXCLUDE_MUST_SELECTED_RECORD_TIP = CONSTANTS_MSG.excludeMustSelectedRecordTip();

    private static final String FILTER_BY_STATION_NAME = CONSTANTS_MSG.publisherFilterByStationName();
    private static final String FILTER_BY_HEADEND_NAME = CONSTANTS_MSG.publisherFilterByHeadendName();
    private static final String FILTER_BY_DATE_NAME = CONSTANTS_MSG.publisherFilterByDateName();
    private static final String FILTER_BY_PROGRAM_SCHEDULE = CONSTANTS_MSG.publisherFilterByProgramSchedule();

    private UITaskSetting taskSetting;
    private String filterTitle = "";

    private final EPGFormContainer formContainer;

    private TypedListBoxWidget<Long> categoryListBox;
    private TypedListBoxWidget<Long> dayFromValueListBox;
    private TypedListBoxWidget<Long> dayToValueListBox;
    private TypedListBoxWidget<Long> monthValueListBox;
    private TypedListBoxWidget<Long> weekValueListBox;

    private CheckBox programExcludeCheckBox ;
    private Long providerId;
    private UITask model;
    private HeadendStationSelectorPanel headendStationSelector;

    public ExportSettingPanel() {
        NeptuneApplication.getApplication().getSecurity();


        formContainer = new EPGFormContainer(HorizontalContainer.ALIGN_LEFT);
        initWidget(formContainer);
    }

    public void buildData(UITask task) {
        this.model = task;
        if (task.getTaskSettings() != null) {
            this.taskSetting = task.getTaskSettings().get(PUBLISHER_FILTERS_KEY);
        }
        buildForm();
    }

    private void buildForm() {
        for (int i = formContainer.getFieldCount() - 1; i >= 0; i--) {
            formContainer.removeRow(i);
        }

        headendStationSelector = new HeadendStationSelectorPanel();
        headendStationSelector.setHeadendFilterHelpIconTip(HEADEND_HELP_ICON_TIP);
        headendStationSelector.setStationFilterHelpIconTip(STATION_HELP_ICON_TIP);

        Map<String, List<String>> selectedHeadends = getSelectedDataMap(HEADEND_KEY,
                getFilterTypeKeyFromDB(HEADEND_KEY));
        Map<String, List<String>> selectedStations = getSelectedDataMap(STATION_KEY,
                getFilterTypeKeyFromDB(STATION_KEY));
        Map<String, List<String>> selectedProvider = getSelectedDataMap(PROVIDER_KEY,
                getFilterTypeKeyFromDB(PROVIDER_KEY));
        String selectedProviderId  = "-1";
        String providerKey = PROVIDER_KEY + KEY_SPLIT_SYMBOL + INCLUDE_VALUE_KEY;
        if (selectedProvider != null && selectedProvider.get(providerKey) != null && selectedProvider.get(providerKey).size() > 0) {
            selectedProviderId = selectedProvider.get(providerKey).get(0);
        }
        headendStationSelector.buildData(Long.parseLong(selectedProviderId), selectedHeadends, selectedStations);

        HorizontalPanel schedulePanel = buildScheduleFilterSelectionPanel(14); // NOSONAR
        formContainer.addRow(FILTER_BY_HEADEND_NAME, headendStationSelector.createHeadendHorizontalPanel());
        formContainer.addRow(FILTER_BY_STATION_NAME, headendStationSelector.createStationHorizontalPanel());
        // Schedule Time is required
        formContainer.addRow(FILTER_BY_DATE_NAME, schedulePanel, true);

        formContainer.addRow(FILTER_BY_PROGRAM_SCHEDULE, buildProgramExcludePanel());
    }

    private HorizontalPanel buildProgramExcludePanel() {
        boolean programExcludeValue = getProgramExcludeSelectedValue();
        programExcludeCheckBox = new CheckBox();
        programExcludeCheckBox.setValue(programExcludeValue);

        ImageWidget helpIcon = new ImageWidget();
        helpIcon.setUrl("cms_epgmgmt_ui/images/help.png");
        helpIcon.setTitle(PROGRAM_HELP_ICON_TIP);

        HorizontalPanel programExcludePanel = new HorizontalPanel();
        programExcludePanel.add(programExcludeCheckBox);
        programExcludePanel.add(createLabel("", 15));// NOSONAR
        programExcludePanel.add(helpIcon);
        return programExcludePanel;
    }


    @SuppressWarnings("unchecked")
    private boolean getProgramExcludeSelectedValue() {
        boolean defaultValue = true;

        if (taskSetting == null) {
            return defaultValue;
        }

        Map<String, Object> exportValueMap = taskSetting.getSetting();
        if (exportValueMap == null || exportValueMap.size() == 0) {
            return defaultValue;
        }

        Set<String> keys = exportValueMap.keySet();
        if (keys == null || keys.size() == 0) {
            return defaultValue;
        }

        String programKey = PROGRAM_KEY + KEY_SPLIT_SYMBOL + EXCLUDE_VALUE_KEY;
        if (keys.contains(programKey)) {
            List<String> values = (List<String>) exportValueMap.get(programKey);
            if (values != null && values.size() > 0) {
                defaultValue = Boolean.parseBoolean(values.get(0));
            }
        }

        return defaultValue;
    }


    private ImageWidget buildWarningIcon(String tip) {
        ImageWidget warningButtonIcon = new ImageWidget();
        warningButtonIcon.setUrl("cms_epgmgmt_ui/images/warning.png");
        warningButtonIcon.setTitle(tip);
        return warningButtonIcon;
    }

    private HorizontalPanel buildScheduleFilterSelectionPanel(int days) {
        categoryKey = getCategorySelectedValue();

        final HorizontalPanel contentHPanel = new HorizontalPanel();
        contentHPanel.setHeight("20px");

        /***************** categoryListBox ***********************/
        categoryListBox = new TypedListBoxWidget<Long>(new IntegerConverter());
        dayFromValueListBox = new TypedListBoxWidget<Long>(new IntegerConverter());
        dayToValueListBox = new TypedListBoxWidget<Long>(new IntegerConverter());
        monthValueListBox = new TypedListBoxWidget<Long>(new IntegerConverter());
        weekValueListBox = new TypedListBoxWidget<Long>(new IntegerConverter());
        categoryListBox.setWidth("80px");
        categoryListBox.addItem("By day", SCHEDULE_SELECT_BY_DAY);
        categoryListBox.addItem("By week", SCHEDULE_SELECT_BY_WEEK);
        categoryListBox.addItem("By month", SCHEDULE_SELECT_BY_MONTH);
        categoryListBox.setSelectedItem(categoryKey);
        categoryListBox.setTitle("");

        dayFromValueListBox.setWidth("40px");
        for (long i = 0; i <= days; i++) {
            dayFromValueListBox.addItem(i + "", i*-1);
        }
        dayToValueListBox.setWidth("40px");
        for (long i = 0; i <= days; i++) {
            dayToValueListBox.addItem(i + "", i);
        }

        dayFromValueListBox.setSelectedItem(daysInPast);
        dayToValueListBox.setSelectedItem(daysInFuture);

        monthValueListBox.addItem("next month", SCHEDULE_SELECT_NEXT_MONTH);
        monthValueListBox.addItem("current month", SCHEDULE_SELECT_CURR_MONTH);
        monthValueListBox.addItem("last month", SCHEDULE_SELECT_LAST_MONTH);
        monthValueListBox.setSelectedItem(monthDelta);

        weekValueListBox.addItem("next week", SCHEDULE_SELECT_NEXT_WEEK);
        weekValueListBox.addItem("current week", SCHEDULE_SELECT_CURR_WEEK);
        weekValueListBox.addItem("last week", SCHEDULE_SELECT_LAST_WEEK);
        weekValueListBox.addItem("current week + next week", SCHEDULE_SELECT_CURR_NEXT_WEEK);
        weekValueListBox.setSelectedItem(weekDelta);

        contentHPanel.add(categoryListBox);

        categoryListBox.addValueChangeHandler(new ValueChangeHandler<Long>() {
            @Override
            public void onValueChange(ValueChangeEvent<Long> event) {
                long value = categoryListBox.getValue();
                contentHPanel.clear();
                contentHPanel.add(categoryListBox);
                if (value == SCHEDULE_SELECT_BY_DAY) {
                    addDayScheduleContent(contentHPanel);
                } else if (value == SCHEDULE_SELECT_BY_MONTH) {
                    contentHPanel.add(monthValueListBox);
                } else if (value == SCHEDULE_SELECT_BY_WEEK) {
                    contentHPanel.add(weekValueListBox);
                } else {
                    categoryListBox.setTitle("Use EPG Manager Configuration days setting");
                }
                buildServerDifferenceTimeZoneTip(contentHPanel);
            }

        });

        contentHPanel.clear();
        contentHPanel.add(categoryListBox);
        if (categoryKey == SCHEDULE_SELECT_BY_DAY) {
            addDayScheduleContent(contentHPanel);
        } else if (categoryKey == SCHEDULE_SELECT_BY_MONTH) {
            contentHPanel.add(monthValueListBox);
        } else if (categoryKey == SCHEDULE_SELECT_BY_WEEK) {
            contentHPanel.add(weekValueListBox);
        }

        // If exists the difference Time Zone between Client and Server, then set a tip on ScheduleTime Widget.
        buildServerDifferenceTimeZoneTip(contentHPanel);

        return contentHPanel;
    }

    private void addDayScheduleContent(final HorizontalPanel contentHPanel) {
        Label daysInPast = new Label(SCHEDULE_TIME_DAYS_IN_PAST);
        daysInPast.addStyleName(STYLE_EPG_EXPORTSETTING_CHECKBOX_LISTBOX_PADDING);
        Label daysToFuture = new Label(SCHEDULE_TIME_DAYS_IN_FUTURE);
        daysToFuture.addStyleName(STYLE_EPG_EXPORTSETTING_CHECKBOX_LISTBOX_PADDING);
        contentHPanel.add(daysInPast);
        contentHPanel.add(dayFromValueListBox);
        contentHPanel.add(daysToFuture);
        contentHPanel.add(dayToValueListBox);
    }

    @SuppressWarnings("unchecked")
    private long getCategorySelectedValue() {
        long categoryKey = SCHEDULE_SELECT_BY_DAY;
        List<String> scheduleTimeValueList = null;

        if (taskSetting == null) {
            return categoryKey;
        }

        Map<String, Object> exportValueMap = taskSetting.getSetting();
        if (exportValueMap == null || exportValueMap.size() == 0) {
            return categoryKey;
        }

        Set<String> keys = exportValueMap.keySet();
        if (keys == null || keys.size() == 0) {
            return categoryKey;
        }

        String dayKey = SCHEDULE_TIME_KEY + KEY_SPLIT_SYMBOL + SCHEDULE_TIME_DAY_KEY;
        String monthKey = SCHEDULE_TIME_KEY + KEY_SPLIT_SYMBOL + SCHEDULE_TIME_MONTH_KEY;
        String weekKey = SCHEDULE_TIME_KEY + KEY_SPLIT_SYMBOL + SCHEDULE_TIME_WEEK_KEY;
        if (keys.contains(dayKey)) {
            categoryKey = SCHEDULE_SELECT_BY_DAY;
            scheduleTimeValueList = (List<String>) exportValueMap.get(dayKey);
            if (scheduleTimeValueList != null && scheduleTimeValueList.size() > 0) {
                daysInPast = Long.parseLong(scheduleTimeValueList.get(0));
                daysInFuture = Long.parseLong(scheduleTimeValueList.get(1));
            }
        } else if (keys.contains(monthKey)) {
            categoryKey = SCHEDULE_SELECT_BY_MONTH;
            scheduleTimeValueList = (List<String>) exportValueMap.get(monthKey);
            if (scheduleTimeValueList != null && scheduleTimeValueList.size() > 0) {
                monthDelta = Long.parseLong(scheduleTimeValueList.get(0));
            }

        } else if (keys.contains(weekKey)) {
            categoryKey = SCHEDULE_SELECT_BY_WEEK;
            scheduleTimeValueList = (List<String>) exportValueMap.get(weekKey);
            if (scheduleTimeValueList != null && scheduleTimeValueList.size() > 0) {
                weekDelta = Long.parseLong(scheduleTimeValueList.get(0));
            }
        } else {
            categoryKey = SCHEDULE_SELECT_NONE;
        }
        return categoryKey;
    }

    public long getProviderFilterValues() {
        return getProviderId();
    }

    /**
     * return export setting values to parent panel
     * 
     * @return
     */
    public Map<String, Object> getFilterValues() {
        Map<String, Object> mapFilterValues = new HashMap<String, Object>();

        // Headend, Stations values
        mapFilterValues.putAll(headendStationSelector.getFilterValues());

        // Schedule values
        mapFilterValues.putAll(getScheduleSelectedFilterValueMap());

        // Program exclude values
        mapFilterValues.putAll(getProgramExcludeFilterValueMap());

        return mapFilterValues;
    }


    private Map<String, List<String>> getProgramExcludeFilterValueMap() {
        Map<String, List<String>> mapListValues = new HashMap<String, List<String>>();
        List<String> program = new ArrayList<String>();
        program.add(String.valueOf(programExcludeCheckBox.getValue()));
        String programKey = PROGRAM_KEY + KEY_SPLIT_SYMBOL + EXCLUDE_VALUE_KEY;
        mapListValues.put(programKey, program);
        return mapListValues;
    }

    private Map<String, List<String>> getScheduleSelectedFilterValueMap() {
        Map<String, List<String>> map = new HashMap<String, List<String>>();
        long filterType = categoryListBox.getValue();
        if (filterType == SCHEDULE_SELECT_NONE) {
            return map;
        }

        String valueKey = "";
        List<String> values = new ArrayList<String>();
        if (filterType == SCHEDULE_SELECT_BY_DAY) {
            long daysInPast = dayFromValueListBox.getValue();
            long daysInFuture = dayToValueListBox.getValue();
            values.add(String.valueOf(daysInPast));
            values.add(String.valueOf(daysInFuture));
            valueKey = SCHEDULE_TIME_DAY_KEY;
        } else if (filterType == SCHEDULE_SELECT_BY_MONTH) {
            long month = monthValueListBox.getValue();
            valueKey = SCHEDULE_TIME_MONTH_KEY;
            values.add(String.valueOf(month));
        } else if (filterType == SCHEDULE_SELECT_BY_WEEK) {
            long week = weekValueListBox.getValue();
            valueKey = SCHEDULE_TIME_WEEK_KEY;
            values.add(String.valueOf(week));
        }
        map.put(SCHEDULE_TIME_KEY + KEY_SPLIT_SYMBOL + valueKey, values);
        return map;
    }

    public String getFilterTitle() {
        return filterTitle;
    }

    public void setFilterTitle(String filterTitle) {
        this.filterTitle = filterTitle;
    }

    public List<String> validate() {
        List<String> errors = new ArrayList<String>();
        if (getProviderId() == -1) {
            errors.add(CONSTANTS_MSG.ingestTaskNeeded());
        }
        if (getScheduleSelectedFilterValueMap().size() == 0) {
            errors.add(CONSTANTS_MSG.ingestTaskNeeded());
        }

        return errors;
    }

    public void populateModel() {
        if(taskSetting==null){
            taskSetting = new UITaskSetting();
            model.getTaskSettings().put(PUBLISHER_FILTERS_KEY, taskSetting);
        }
        taskSetting.setKey(PUBLISHER_FILTERS_KEY);
        taskSetting.setSetting(getFilterValues());

        Map<String, UITaskSetting> uiTaskSettings = new HashMap<String, UITaskSetting>();
        uiTaskSettings.put(PUBLISHER_FILTERS_KEY, taskSetting);
    }

    @SuppressWarnings("unchecked")
    private Map<String, List<String>> getSelectedDataMap(String filterValueKey, String filterTypeKey) {
        String filterKey = filterValueKey + KEY_SPLIT_SYMBOL + filterTypeKey;
        List<String> selectedData = (List<String>) (taskSetting == null || taskSetting.getSetting() == null ? null
                : taskSetting.getSetting().get(filterKey));
        if (selectedData == null || selectedData.size() == 0) {
            return null;
        }

        Map<String, List<String>> selectedDataMap = new HashMap<String, List<String>>();
        selectedDataMap.put(filterValueKey + KEY_SPLIT_SYMBOL + filterTypeKey, selectedData);
        return selectedDataMap;
    }

    private String getFilterTypeKeyFromDB(String filterValueKey) {
        String filterTypeKey = INCLUDE_VALUE_KEY;
        if (taskSetting == null || taskSetting.getSetting() == null) {
            return filterTypeKey;
        }

        if (taskSetting.getSetting().containsKey(filterValueKey + KEY_SPLIT_SYMBOL + INCLUDE_VALUE_KEY)) {
            filterTypeKey = INCLUDE_VALUE_KEY;
        } else if (taskSetting.getSetting().containsKey(filterValueKey + KEY_SPLIT_SYMBOL + EXCLUDE_VALUE_KEY)) {
            filterTypeKey = EXCLUDE_VALUE_KEY;
        }
        return filterTypeKey;
    }

    public Long getProviderId() {
        return providerId == null ? -1 : providerId;
    }

    public void setProviderId(Long providerId) {
        this.providerId = providerId;
        // cascade by provider changed
        headendStationSelector.setProviderId(providerId);
    }

    private void buildServerDifferenceTimeZoneTip(final HorizontalPanel contentHPanel) {
        serverTimeService.getCurrentTime(new NeptuneAsyncCallback<ServerTime>() {
            @Override
            public void onNeptuneFailure(Throwable caught) {
                Window.alert("Get server time failed!! \n " + caught);
            }

            @Override
            public void onNeptuneSuccess(ServerTime serverTime) {
                setScheduleTimeTimeZoneTip(contentHPanel, serverTime);
            }
        });
    }

    private void setScheduleTimeTimeZoneTip(HorizontalPanel contentHPanel, ServerTime serverTime) {
        Date serverDate = serverTime.getDate();
        Date clientDate = new Date();
        TimeZone clientZone = TimeZone.createTimeZone(clientDate.getTimezoneOffset());
        if (serverDate.getTimezoneOffset() != clientDate.getTimezoneOffset()) {
            String tip = CONSTANTS_MSG.timeZoneDifferenceTip(serverTime.getTimeZone().getID(), clientZone.getID(),
                    timeDifferenceDesc(serverDate, clientDate));
            ImageWidget warningIcon = buildWarningIcon(tip);
            contentHPanel.add(warningIcon);
        }
    }

    private String timeDifferenceDesc(Date date1, Date date2) {
        int d1Offset = date1.getTimezoneOffset();
        int d2Offset = date2.getTimezoneOffset();
        NumberFormat nf = NumberFormat.getDecimalFormat();
        nf.overrideFractionDigits(1);
        int offset = date1.getTimezoneOffset() - date2.getTimezoneOffset();
        String timeZoneOffset = "early ";
        if (offset < 0) {
            timeZoneOffset = "later ";
        }

        timeZoneOffset += nf.format((d1Offset - d2Offset) / 60); // NOSONAR
        return timeZoneOffset;
    }

    private LabelWidget createLabel(String msg, int width) {
        LabelWidget label = new LabelWidget(msg);
        label.setWidth(width + "px");
        return label;
    }

}