package com.ericsson.cms.epgmgmt.client.task;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.model.enumeration.JobType;
import com.ericsson.cms.epgmgmt.client.partner.IPartnerTab;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;

public class ExportTaskBasicTab extends Composite implements IPartnerTab {

    private static final String STYLE_DISCLOSURE_CONTAINER = "epg-basicTab-disclosureContainer";
    private final UITask model;
    private RoundedDisclosureContainer basicInfoDisclosure;
    private RoundedDisclosureContainer exportSettingDisclosure;
    private TaskBasicSettingForm basicForm;
    private TaskTriggerSettingForm triggerForm;
    private final EPGComponentConstants constants = GWT.create(EPGComponentConstants.class);
    private ExportSettingPanel exportSettingPanel;

    public ExportTaskBasicTab(UITask model) {
        this.model = model;
        initForm();
    }

    private void initForm() {
        VerticalContainer vc = new VerticalContainer();
        vc.setWidth("95%");

        triggerForm = new TaskTriggerSettingForm(JobType.EXPORT, model);
        basicForm = new TaskBasicSettingForm(JobType.EXPORT, model);
        exportSettingPanel = new ExportSettingPanel();
        basicForm.setExportSettingPanel(exportSettingPanel);
        basicForm.setTriggerForm(triggerForm);

        initBasicDisclosure(vc);
        initTriggerDisclosure(vc);
        initExportSettingDisclosure(vc);

        ScrollPanel sp = new ScrollPanel();
        sp.addStyleName("epg-basicTab-scrollContainer");
        sp.setHeight("100%");
        sp.setWidth("100%");
        sp.add(vc);

        this.initWidget(sp);
    }

    private void initBasicDisclosure(VerticalContainer vc) {
        basicInfoDisclosure = new RoundedDisclosureContainer(new LabelWidget(constants.publisherBasicDisplayName()), true);
        basicInfoDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        basicInfoDisclosure.setContent(basicForm);
        vc.add(basicInfoDisclosure);
    }

    private void initTriggerDisclosure(VerticalContainer vc) {
        RoundedDisclosureContainer triggerInfoDisclosure = new RoundedDisclosureContainer(new LabelWidget(constants.triggerSetting()), true);
        triggerInfoDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        triggerInfoDisclosure.setContent(triggerForm);
        vc.add(triggerInfoDisclosure);
    }

    private void initExportSettingDisclosure(VerticalContainer vc) {
        exportSettingPanel.buildData(model);

        exportSettingDisclosure = new RoundedDisclosureContainer(new LabelWidget(constants.exportFilters()), true);
        exportSettingDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        exportSettingDisclosure.setContent(exportSettingPanel);

        vc.add(exportSettingDisclosure);
    }

    @Override
    public String getName() {
        return "exportTaskBasicTab";
    }

    @Override
    public String getDisplayName() {
        return "Basic Setting";
    }

    @Override
    public void setSelected(boolean selected) {
        //
    }

    public TypedListBoxWidget<Long> getFormatTypeList() {
        return basicForm.getFormatTypeList();
    }

    @Override
    public List<String> validate() {
        List<String> validationMessages = new ArrayList<String>();
        validationMessages.addAll(basicForm.validateField());
        validationMessages.addAll(triggerForm.validateField());
        validationMessages.addAll(exportSettingPanel.validate());
        return validationMessages;
    }

    /**
     * Fill the values into the current model and return it.
     * 
     * @return
     */
    public UITask populateModel() {
        exportSettingPanel.populateModel();
        triggerForm.populateModel();
        basicForm.populateModel();
        return model;
    }

    @Override
    public void reload() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateScrollPanelSize() {
        
    }
}