package com.ericsson.cms.epgmgmt.client.task;

import com.ericsson.cms.epgmgmt.client.model.UIOrderedTask;
import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.model.enumeration.TriggerType;
import com.ericsson.cms.epgmgmt.client.utils.MessageAreaUtils;
import com.ericsson.cms.epgmgmt.client.widget.CustomizableHorizontalView;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

public class ExportTaskDataProvider extends AbstractTaskDataProvider {

    public ExportTaskDataProvider(UIPartner partner, AbstractTaskListViewPanel parent) {
        super(partner, parent);
    }

    @Override
    AbstractTaskDialog getTaskDialog(UITask task, UIPartner partner, AbstractTaskListViewPanel parent) {
        return new ExportTaskDialog(task, partner, parent);
    }

    @Override
    protected ColumnBase<String, UIOrderedTask> createLabelColumn(String name, String label, final String propertyName) {
        ColumnBase<String, UIOrderedTask> c = new ColumnBase<String, UIOrderedTask>(name, label) {
            @Override
            public View<String> getView(final UIOrderedTask task) {
                final CustomizableHorizontalView view = new CustomizableHorizontalView();
                Object value = task.getProperty(propertyName);
                LabelWidget label = new LabelWidget(value == null ? "" : value.toString());
                if (!partner.isActive() || !task.isEnabled()) {
                  label.setStyleName(STYLE_EPG_DISABLED);
                 }
                view.getContainer().add(label);

                if(!propertyName.equals(TRIGGER_TYPE) || !task.isEnabled()) {
                    return view;
                }

                //it is trigger_type column, check whether it is on demand type.
                TriggerType triggerType = (TriggerType) value;
                if(triggerType != triggerType.ONDEMAND) {
                    return view;
                }

                //for trigger type column, need to check whether the tip is needed
                taskService.getProviderForExportTask(task.getId(), new NeptuneAsyncCallback<UIPartner>() {
                    @Override
                    public void onNeptuneFailure(Throwable caught) {
                      MessageAreaUtils.handleException(caught, messageArea);
                      notifyBusyStatus(false);
                    }

                    @Override
                    public void onNeptuneSuccess(UIPartner provider) {
                        final StringBuffer tipBuff = new StringBuffer();
                        if(provider != null && !provider.isActive()) {
                            tipBuff.append(messages.providerDisabledWarnMessage(provider.getName()) + "\n");
                        }

                        taskService.getSubscribedTask(task.getId(), new NeptuneAsyncCallback<UITask>() {
                            @Override
                            public void onNeptuneFailure(Throwable caught) {
                                MessageAreaUtils.handleException(caught, messageArea);
                                notifyBusyStatus(false);
                            }

                            @Override
                            public void onNeptuneSuccess(UITask ingestTask) {
                                if(ingestTask !=null && !ingestTask.isEnabled()) {
                                    tipBuff.append(messages.ingestionTaskDisabledWarnMessage(ingestTask.getName()));
                                }

                                String tipStr = tipBuff.toString();
                                boolean needTip =  !tipStr.equals("");
                                if(needTip) {
                                  ImageWidget img = new ImageWidget("cms_epgmgmt_ui/images/warning.png");
                                  img.setTitle(tipStr);
                                  view.getContainer().insert(img, 0);
                                }
                                notifyBusyStatus(false);
                            }
                        });
                    }//2nd onNeptuneSuccess
                });

                return view;
            }
        };
        c.setCellStyle(TableConstants.STYLE_DATACELL_TEXT);
        return c;
    }

}
