package com.ericsson.cms.epgmgmt.client.task;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.model.enumeration.JobType;
import com.ericsson.cms.epgmgmt.client.partner.ExecutionLogTab;
import com.ericsson.cms.epgmgmt.client.utils.MessageAreaUtils;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class ExportTaskDialog extends AbstractTaskDialog {

    private TabContainer tabContainer;
    private ExportTaskBasicTab basicTab;
    private TaskPluginPropertyTab pluginPropertiesTab;

    public ExportTaskDialog(UIPartner partner, AbstractTaskListViewPanel parent) {
        super(partner, parent);
    }

    public ExportTaskDialog(UITask task, UIPartner partner, AbstractTaskListViewPanel parent) {
        super(task, partner, parent);
    }

    /**
     * Load plugin properties tab according to the format ID for the moment.
     */
    public void loadPluginProperties() {
        clearMessageArea();
        pluginPropertiesTab.loadProperties();
    }

    @Override
    public UITask populateTask() {
        current = basicTab.populateModel();
        current.setPluginPropertyValues(pluginPropertiesTab.populatePluginProperties());
        return current;
    }

    public TabContainer getTabContainer() {
        return tabContainer;
    }

    @Override
    protected void initContent(VerticalContainer vc) {
        tabContainer = new TabContainer();
        tabContainer.setWidth("100%");
        tabContainer.addStyleName("tabContainer");
        basicTab = new ExportTaskBasicTab(current);
        basicTab.setHeight(TAB_HEIGHT);
        pluginPropertiesTab = new TaskPluginPropertyTab(current, history);
        pluginPropertiesTab.setHeight(TAB_HEIGHT);
        tabContainer.add(basicTab, basicTab.getDisplayName());
        tabContainer.add(pluginPropertiesTab, pluginPropertiesTab.getDisplayName());
        if (this.history.getId() > 0) {
            ExecutionLogTab logTab = super.createExeLogTab(JobType.EXPORT);
            tabContainer.add(logTab, logTab.getDisplayName());
        }
        tabContainer.selectTab(0);
        vc.add(tabContainer);

        bindHandler();
    }

    private void bindHandler() {
        basicTab.getFormatTypeList().addValueChangeHandler(new ValueChangeHandler<Long>() {
            @Override
            public void onValueChange(ValueChangeEvent<Long> event) {
                if (event.getValue() == pluginPropertiesTab.getCurrentFormatId()) {
                    return;
                }
                loadPluginProperties();
            }
        });
    }

    @Override
    protected ClickHandler getCreateButtonClickHandler() {
        return new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                messageArea.reset();
                List<String> errors = basicTab.validate();
                UITask task = populateTask();
                if (!partner.isActive() && task.isEnabled()) {
                    errors.add(messages.enableTaskWhilePartnerIsDisabled());
                }
                if (errors != null && !errors.isEmpty()) {
                    MessageAreaUtils.displayErrorMessages("", errors, "", messageArea);
                    return;
                }
                validateAndSubmit(task);
            }
        };
    }

    @Override
    protected void setModelDefaultValue(UITask model) {
        model.setType(JobType.EXPORT.toString());
    }
}
