package com.ericsson.cms.epgmgmt.client.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.model.UITaskSetting;
import com.ericsson.cms.epgmgmt.client.model.enumeration.TriggerType;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGTaskService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGTaskServiceAsync;
import com.ericsson.cms.epgmgmt.client.utils.CollectionUtils;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLTable.Cell;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.RegionPosition;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.form.Label;
import com.gwtext.client.widgets.layout.BorderLayoutData;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

public class FollowingTaskSettingForm extends Composite {
    private static final String ICON_WIDTH = "18px";
    private final FlexTable ingestTaskConfigureTable = new FlexTable();
    private final EPGComponentConstants constants = GWT.create(EPGComponentConstants.class);
    private final EPGComponentMessages messages = GWT.create(EPGComponentMessages.class);
    private final IEPGTaskServiceAsync providerTaskService = GWT.create(IEPGTaskService.class);

    private static final String EDIT_ICON = "cms_epgmgmt_ui/images/edit.png";
    private static final String UP_ICON = "cms_epgmgmt_ui/images/navigate-up.png";
    private static final String DOWN_ICON = "cms_epgmgmt_ui/images/navigate-down.png";
    private static final String REMOVE_ICON = "cms_epgmgmt_ui/images/remove-1.png";
    private static final String HELP_ICON = "cms_epgmgmt_ui/images/help.png";
    private UITask task;
    private List<String> selectedTaskListFromDb;
    private final IngestAddHandler ingestAddHandler = new IngestAddHandler();
    private final DeleteRowHandler deleRowHandler = new DeleteRowHandler();
    private final TaskListPopup taskPopup;
    private List<UITask> availabelIngestTasks;

    private static final String FOLLOWING_INGEST_TASKS = "FollowingIngestion";

    public FollowingTaskSettingForm() {
        initWidget(ingestTaskConfigureTable);
        this.taskPopup = new TaskListPopup();
    }

    public void buildData(UITask taskModel) {
        this.task = taskModel;
        this.selectedTaskListFromDb = getSelectedTaskListFromDb();
        initForm();
    }

    @SuppressWarnings("unchecked")
    private List<String> getSelectedTaskListFromDb() {
        UITaskSetting taskSetting = task.getTaskSettings().get(FOLLOWING_INGEST_TASKS);

        if (taskSetting != null && taskSetting.getSetting() != null) {
            return (List<String>) taskSetting.getSetting().get(FOLLOWING_INGEST_TASKS);
        }
        return null;
    }

    private void initForm() {
        ingestTaskConfigureTable.removeAllRows();
        buildFirstRow();
        buildIngestTaskList();
    }

    private void buildFirstRow() {
        HorizontalPanel panel = new HorizontalPanel();
        Image image = buildImageWidget(EDIT_ICON, ingestAddHandler, ICON_WIDTH, constants.editFollingIngestion());
        image.addStyleName("marginRight");
        panel.add(image);
        panel.add(buildImageWidget(HELP_ICON, null, ICON_WIDTH, constants.followingIngestionTip()));
        ingestTaskConfigureTable.setText(0, 0, constants.followingIngestTaskLabel());
        ingestTaskConfigureTable.setText(0, 1, "");
        ingestTaskConfigureTable.setWidget(0, 2, panel);
        ingestTaskConfigureTable.getCellFormatter().setStyleName(0, 0, "cellAlignRight");
        ingestTaskConfigureTable.getCellFormatter().setWidth(0, 0, "200px");
    }

    private void buildIngestTaskList() {
        providerTaskService.getTasksByPartnerId(task.getPartnerId(), new NeptuneAsyncCallback<List<UITask>>() {
            @Override
            public void onNeptuneFailure(Throwable caught) {
                Window.alert("get all task for partner failed!! \n " + caught);
            }

            @Override
            public void onNeptuneSuccess(List<UITask> result) {
                fillIngestTaskList(result);
            }
        });
    }

    private void fillIngestTaskList(List<UITask> result) {
        this.availabelIngestTasks = new LinkedList<UITask>();
        if (!CollectionUtils.isEmpty(selectedTaskListFromDb)) {
            for (String selectedTaskId : selectedTaskListFromDb) {
                UITask t = getUITask(result, selectedTaskId);
                if (t != null && t.getUiTaskTrigger().getTriggerType() == TriggerType.ONDEMAND ) {
                    addSelectedTaskRow(t);
                    result.remove(t);
                }
            }
        }
        for (UITask t : result) {
            if (isThisTaskCanBeSelected(t, result) && t.getUiTaskTrigger().getTriggerType() == TriggerType.ONDEMAND && t.isEnabled()) {
                this.availabelIngestTasks.add(t);
            }
        }
    }

    private UITask getUITask(List<UITask> result, String selectedTaskId) {
        long id = Long.parseLong(selectedTaskId);
        for (UITask t : result) {
            if (t.getId() == id) {
                return t;
            }
        }
        return null;
    }

    @SuppressWarnings("unchecked")
    private boolean isThisTaskCanBeSelected(UITask t, List<UITask> taskList) {
        // can not show task itself
        if (t.getId() == task.getId()) {
            return false;
        }
        
        // can not show the task which already be selected by other task as following ingestion task
        for (UITask otherTask : taskList) {
            UITaskSetting taskSetting = otherTask.getTaskSettings().get(FOLLOWING_INGEST_TASKS);

            if (taskSetting != null && taskSetting.getSetting() != null) {
                List<String> followingTaskIdList = (List<String>) taskSetting.getSetting().get(FOLLOWING_INGEST_TASKS);

                if (!CollectionUtils.isEmpty(followingTaskIdList) && followingTaskIdList.contains(String.valueOf(t.getId()))) {
                    return false;
                }
            }
        }

        // can not show the task which already have following task
        if (t.getTaskSettings() != null) {
            UITaskSetting taskSetting = t.getTaskSettings().get(FOLLOWING_INGEST_TASKS);

            if (taskSetting != null && taskSetting.getSetting() != null) {
                List<String> followingTaskIdList = (List<String>) taskSetting.getSetting().get(FOLLOWING_INGEST_TASKS);

                if (!CollectionUtils.isEmpty(followingTaskIdList)) {
                    return false;
                }
            }
        }

        return true;
    }

    private void addSelectedTaskRow(final UITask task) {
        int lastRowIndex = ingestTaskConfigureTable.getRowCount();
        ingestTaskConfigureTable.setWidget(lastRowIndex, 0,
                buildImageWidget(UP_ICON, new MoveHandler(), "12px", constants.increasePriority()));
        ingestTaskConfigureTable.setWidget(lastRowIndex, 1,
                buildImageWidget(DOWN_ICON, new MoveHandler(), "12px", constants.decreasePriority()));
        ingestTaskConfigureTable.setWidget(lastRowIndex, 2, createTaskPanel(task));
        ingestTaskConfigureTable.setWidget(lastRowIndex, 3, //NOSONAR
                buildImageWidget(REMOVE_ICON, deleRowHandler, ICON_WIDTH, constants.removeIngestionTask()));// NOSONAR
        ingestTaskConfigureTable.getCellFormatter().setStyleName(lastRowIndex, 0, "cellAlignRight");
        resetArrows();
    }

    private void resetArrows() {
        int rowCount = ingestTaskConfigureTable.getRowCount();
        for (int i = 1; i < rowCount; i++) {
            ingestTaskConfigureTable.getWidget(i, 0).setVisible(i != 1);
            ingestTaskConfigureTable.getWidget(i, 1).setVisible(i != rowCount - 1);
        }
    }

    private TaskPanel createTaskPanel(UITask task) {
        TaskPanel panel = new TaskPanel(task);
        panel.setWidth("191px");
        return panel;
    }

    private Image buildImageWidget(String url, ClickHandler handler, String width, String tip) {
        Image imageWidget = new Image();
        imageWidget.setUrl(url);
        imageWidget.setWidth(width);
        imageWidget.setHeight("18px");
        imageWidget.setTitle(tip);
        if (handler != null) {
            imageWidget.addClickHandler(handler);
        }
        imageWidget.addStyleName("epg-button");
        return imageWidget;
    }

    public List<String> validateField() {
        return new ArrayList<String>();
    }

    public void populateModel() {
        populateFollowingIngestionTask();
    }

    private void populateFollowingIngestionTask() {
        Map<String, Object> setting = new HashMap<String, Object>();
        setting.put(FOLLOWING_INGEST_TASKS, populateTaskSetting());

        UITaskSetting taskSetting = new UITaskSetting();
        taskSetting.setKey(FOLLOWING_INGEST_TASKS);
        taskSetting.setSetting(setting);

        if (task.getTaskSettings().get(FOLLOWING_INGEST_TASKS) != null) {
            taskSetting.setId(task.getTaskSettings().get(FOLLOWING_INGEST_TASKS).getId());
        }

        Map<String, UITaskSetting> uiTaskSettings = new HashMap<String, UITaskSetting>();
        uiTaskSettings.put(FOLLOWING_INGEST_TASKS, taskSetting);

        task.setTaskSettings(uiTaskSettings);
    }

    public List<String> populateTaskSetting() {
        List<String> selectedIngestTaskList = new ArrayList<String>();
        List<UITask> selected = getSelectedTasks();
        for (UITask t : selected) {
            selectedIngestTaskList.add(String.valueOf(t.getId()));
        }
        return selectedIngestTaskList;
    }

    private List<UITask> getSelectedTasks() {
        List<UITask> selected = new LinkedList<UITask>();
        for (int i = 1; i < ingestTaskConfigureTable.getRowCount(); i++) {
            @SuppressWarnings("unchecked")
            TaskPanel taskPanel = (TaskPanel) ingestTaskConfigureTable.getWidget(i, 2);
            if (taskPanel != null && taskPanel.getTask() != null) {
                selected.add(taskPanel.getTask());
            }
        }
        return selected;
    }

    private final class DeleteRowHandler implements ClickHandler {
        @Override
        public void onClick(ClickEvent event) {
            int rowIndex = ingestTaskConfigureTable.getCellForEvent(event).getRowIndex();
            TaskPanel taskPanel = (TaskPanel) ingestTaskConfigureTable.getWidget(rowIndex, 2);
            availabelIngestTasks.add(taskPanel.getTask());
            ingestTaskConfigureTable.removeRow(rowIndex);
            resetArrows();
        }
    }

    private final class IngestAddHandler implements ClickHandler {
        @Override
        public void onClick(ClickEvent event) {
            taskPopup.show((Widget) event.getSource(), availabelIngestTasks, getSelectedTasks());
        }
    }

    private final class MoveHandler implements ClickHandler {
        @Override
        public void onClick(ClickEvent event) {
            Cell cellForEvent = ingestTaskConfigureTable.getCellForEvent(event);
            int rowIndex = cellForEvent.getRowIndex();
            int colIndex = cellForEvent.getCellIndex();
            if (rowIndex == 0 && colIndex == 0 || rowIndex == ingestTaskConfigureTable.getRowCount() - 1
                    && colIndex == 1) {
                return;
            }

            Widget box = ingestTaskConfigureTable.getWidget(rowIndex, 2);
            int exchangeRow = colIndex == 0 ? rowIndex - 1 : rowIndex + 1;
            ingestTaskConfigureTable.setWidget(rowIndex, 2, ingestTaskConfigureTable.getWidget(exchangeRow, 2));
            ingestTaskConfigureTable.setWidget(exchangeRow, 2, box);
        }
    }

    private final class TaskPanel extends HorizontalPanel {
        private final UITask task;
        
        public TaskPanel(UITask task){
            String url = "cms_epgmgmt_ui/images/layer-indicator-blank.png";
            if(!task.isEnabled()){
                url = "cms_epgmgmt_ui/images/prohibit.png";
            }
            Image image = new Image(url);
            image.setWidth("16px");
            image.setHeight("16px");
            add(image);
            Label label = new Label(task.getName());
            if(!task.isEnabled()){
                label.addStyleName("epg-disabled");
                setTitle(messages.disabledTaskTitile());
            }
            add(label);
            addStyleName("taskPanel");
            setCellWidth(label, "100%");
            this.task = task;
        }

        public UITask getTask() {
            return task;
        }
    }

    private static final class AttachableCheckBox<T> extends CheckBox {
        private T attachement;

        public T getAttachement() {
            return attachement;
        }

        public void setAttachement(T attachement) {
            this.attachement = attachement;
        }
    }

    private final class TaskListPopup extends PopupPanel {
        private VerticalPanel vp;
        private ScrollPanel panel;
        private final List<AttachableCheckBox<UITask>> boxes;

        public TaskListPopup() {
            super(true);
            Panel mainPanel = createMainPanel();
            this.add(mainPanel);
            boxes = new LinkedList<FollowingTaskSettingForm.AttachableCheckBox<UITask>>();
        }

        public void show(Widget relativeTo, List<UITask> availabelTask, List<UITask> selectedTasks) {
            addTasks(availabelTask, selectedTasks);
            panel.setSize("200px", Math.min(100, 21 * (availabelTask.size() + selectedTasks.size()) + 20) + "px");// NOSONAR
            showRelativeTo(relativeTo);
        }

        private Panel createMainPanel() {
            Panel mainPanel = new Panel();
            panel = new ScrollPanel();
            vp = new VerticalPanel();
            vp.setSpacing(3);// NOSONAR
            panel.add(vp);
            BorderLayoutData centerData = new BorderLayoutData(RegionPosition.CENTER);
            mainPanel.add(panel, centerData);
            BorderLayoutData south = new BorderLayoutData(RegionPosition.SOUTH);
            mainPanel.add(createButtonPanel(), south);
            return mainPanel;
        }

        private HorizontalPanel createButtonPanel() {
            HorizontalPanel hp = new HorizontalPanel();
            hp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
            Button okButton = new Button(constants.okLabel());
            okButton.addStyleDependentName("act-towards-save-button");
            okButton.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    ingestTaskConfigureTable.removeAllRows();
                    buildFirstRow();
                    availabelIngestTasks.clear();
                    for (AttachableCheckBox<UITask> box : boxes) {
                        if (box.getValue()) {
                            addSelectedTaskRow(box.getAttachement());
                        } else {
                            availabelIngestTasks.add(box.getAttachement());
                        }
                    }
                    hide();
                }
            });
            hp.add(okButton);
            Button cancelButton = new Button(constants.buttonLabelCancel());
            cancelButton.addStyleDependentName("dataloss-button");
            cancelButton.addClickHandler(new ClickHandler() {
                @Override
                public void onClick(ClickEvent event) {
                    hide();
                }
            });
            hp.add(cancelButton);
            HorizontalPanel outer = new HorizontalPanel();
            outer.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
            outer.setWidth("100%");
            outer.add(hp);
            return outer;
        }

        private void addTasks(List<UITask> availabelTask, List<UITask> selectedTasks) {
            panel.remove(vp);
            vp = new VerticalPanel();
            vp.setSpacing(3);// NOSONAR
            panel.add(vp);
            boxes.clear();
            if (availabelTask.isEmpty() && selectedTasks.isEmpty()) {
                vp.add(new Label(constants.noAvailableTaskLabel()));
            }
            for (UITask t : selectedTasks) {
                AttachableCheckBox<UITask> checkBox = createTaskCheckBox(t);
                checkBox.setValue(true);
            }
            for (UITask t : availabelTask) {
                AttachableCheckBox<UITask> checkBox = createTaskCheckBox(t);
                checkBox.setValue(false);
            }
        }

        private AttachableCheckBox<UITask> createTaskCheckBox(UITask t) {
            AttachableCheckBox<UITask> checkBox = new AttachableCheckBox<UITask>();
            checkBox.setAttachement(t);
            checkBox.setText(t.getName());
            checkBox.setValue(false);
            vp.add(checkBox);
            boxes.add(checkBox);
            return checkBox;
        }
    }
}
