package com.ericsson.cms.epgmgmt.client.task;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.model.UITaskTrigger;
import com.ericsson.cms.epgmgmt.client.widget.OkCancelButtonPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class FrequencyTimePicker extends PopupPanel {
    private final EPGComponentConstants constants = GWT.create(EPGComponentConstants.class);
    private final EPGComponentMessages messages = GWT.create(EPGComponentMessages.class);

    private static final String STYLE_INPUT_DOWNLIST = "epg-input-bg";
    private static final String STYLE_DEFAULT = " epg-timer-picker-default";
    private static final String STYLE_ACTIVE = " epg-timer-picker-active";
    private static final String STYLE_HOVER = " epg-timer-picker-hover";
    private static final String STYLE_TEXT_TITLE = "epg-timer-picker-title";
    private static final int[][] HOUR_OPTIONS = { { 0, 1, 2, 3, 4, 5 }, { 6, 7, 8, 9, 10, 11 },
        { 12, 13, 14, 15, 16, 17 }, { 18, 19, 20, 21, 22, 23 } };
    private static final int[][] MINUTE_OPTIONS = { { 0, 1, 2, 3 }, { 4, 5, 10, 15 }, { 20, 25, 30, 35 },
        { 40, 45, 50, 55 } };
    private UITaskTrigger current;
    private UITaskTrigger origin;
    private FlexTable hourTable = new FlexTable();
    private FlexTable minuteTable = new FlexTable();
    private MouseOverHandler labelMouseOverHandler;
    private MouseOutHandler labelMouseOutHandler;
    private ClickHandler hourLabelClickHandler;
    private ClickHandler minuteLabelClickHandler;
    private ClickHandler okClickHandler;
    private ClickHandler cancelClickHandler;
    private ClickHandler textBoxClickHandler;
    private TextBox textBox;
    private LabelWidget selectedHourLabel;
    private LabelWidget selectedMinuteLabel;
    private OkCancelButtonPanel okCancel;

    public FrequencyTimePicker(UITaskTrigger model) {
        this.origin = model;
        this.current = new UITaskTrigger(origin);
        initEventHandler();
        initTextBox(model.getHours(), model.getMinutes());

        selectedHourLabel = initTable(hourTable, hourLabelClickHandler, HOUR_OPTIONS, model.getHours());
        selectedMinuteLabel = initTable(minuteTable, minuteLabelClickHandler, MINUTE_OPTIONS, model.getMinutes());

        okCancel = new OkCancelButtonPanel(okClickHandler, cancelClickHandler);

        VerticalContainer hourContaniner = createPickerSegment(constants.hours(), hourTable);
        VerticalContainer minuteContaniner = createPickerSegment(constants.minutes(), minuteTable);

        HorizontalContainer hc = new HorizontalContainer();
        hc.setSpacing(6); // NOSONAR
        hc.add(hourContaniner);
        hc.add(minuteContaniner);

        VerticalContainer outerVerticalContaniner = new VerticalContainer();
        outerVerticalContaniner.add(hc);
        outerVerticalContaniner.add(okCancel);

        setWidget(outerVerticalContaniner);
        setAutoHideEnabled(true);
    }

    private void initTextBox(final long selectedHour, final long selectedMinute) {
        textBox = new TextBox();
        textBox.addClickHandler(textBoxClickHandler);
        textBox.setWidth("160px");

        if ((selectedHour != -1L) && (selectedMinute != -1L)) {
            reloadText();
        }

        textBox.setStyleName(STYLE_INPUT_DOWNLIST);
        textBox.setReadOnly(true);
    }

    public void loadModel(UITaskTrigger model) {
        this.origin = model;
        this.current = new UITaskTrigger(origin);
        reloadText();
    }

    private void reloadText() {
        textBox.setText(messages.triggerFrequency(current.getHours(), current.getMinutes()));
    }

    private VerticalContainer createPickerSegment(String title, FlexTable table) {
        LabelWidget l = new LabelWidget(title);
        l.setStyleName(STYLE_TEXT_TITLE);
        l.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);

        VerticalContainer vc = new VerticalContainer();
        vc.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        vc.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        vc.add(l);
        vc.add(table);

        return vc;
    }

    private LabelWidget initTable(FlexTable table, ClickHandler labelClickHandler, int[][] options,
            long selectedValue) {
        LabelWidget selectedLabelWidget = null;
        for (int row = 0; row < options.length; row++) {
            for (int col = 0; col < options[row].length; col++) {
                LabelWidget label = new LabelWidget(String.valueOf(options[row][col]));
                label.setStyleName(STYLE_DEFAULT);

                if (selectedValue == options[row][col]) {
                    label.addStyleName(STYLE_ACTIVE);
                    selectedLabelWidget = label;
                }

                label.addMouseOverHandler(labelMouseOverHandler);
                label.addMouseOutHandler(labelMouseOutHandler);
                label.addClickHandler(labelClickHandler);
                label.setHeight("18px");
                label.setWidth("24px");
                label.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
                table.setWidget(row, col, label);
            }
        }

        return selectedLabelWidget;
    }

    private void initEventHandler() {
        labelMouseOverHandler = new MouseOverHandler() {

            @Override
            public void onMouseOver(MouseOverEvent event) {
                Widget source = (Widget) event.getSource();
                source.setStyleName(STYLE_HOVER + (source.getStyleName().contains(STYLE_ACTIVE) ? STYLE_ACTIVE : ""));
            }
        };

        labelMouseOutHandler = new MouseOutHandler() {

            @Override
            public void onMouseOut(MouseOutEvent event) {
                Widget source = (Widget) event.getSource();
                source.setStyleName(STYLE_DEFAULT + (source.getStyleName().contains(STYLE_ACTIVE) ? STYLE_ACTIVE : ""));
            }
        };

        hourLabelClickHandler = new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                if (selectedHourLabel != null) {
                    selectedHourLabel.setStyleName(STYLE_DEFAULT);
                }
                LabelWidget label = (LabelWidget) event.getSource();
                label.setStyleName(STYLE_ACTIVE);
                selectedHourLabel = label;
                current.setHours(Long.parseLong(label.getText()));
            }
        };

        minuteLabelClickHandler = new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                if (selectedMinuteLabel != null) {
                    selectedMinuteLabel.setStyleName(STYLE_DEFAULT);
                }
                LabelWidget label = (LabelWidget) event.getSource();
                label.setStyleName(STYLE_ACTIVE);
                selectedMinuteLabel = label;
                current.setMinutes(Long.parseLong(label.getText()));
            }
        };

        okClickHandler = new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                origin.setHours(current.getHours());
                origin.setMinutes(current.getMinutes());
                reloadText();
                hide();
            }
        };

        cancelClickHandler = new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                current = new UITaskTrigger(origin);
                reload();
                hide();
            }
        };

        textBoxClickHandler = new ClickHandler() {

            @Override
            public void onClick(ClickEvent event) {
                showRelativeTo(textBox);
            }
        };
    }

    private void reload() {
        selectedHourLabel = initTable(hourTable, hourLabelClickHandler, HOUR_OPTIONS, origin.getHours());
        selectedMinuteLabel = initTable(minuteTable, minuteLabelClickHandler, MINUTE_OPTIONS, origin.getMinutes());
    }

    public TextBox getTextBox() {
        return textBox;
    }

    public long getHour() {
        return current.getHours();
    }

    public long getMinute() {
        return current.getMinutes();
    }
}
