package com.ericsson.cms.epgmgmt.client.task;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.model.enumeration.JobType;
import com.ericsson.cms.epgmgmt.client.partner.IPartnerTab;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;

public class IngestTaskBasicTab extends Composite implements IPartnerTab {

    private static final String STYLE_DISCLOSURE_CONTAINER = "epg-basicTab-disclosureContainer";
    private final UITask model;
    private TaskBasicSettingForm basicForm;
    private TaskTriggerSettingForm triggerForm;
    private FollowingTaskSettingForm followingTaskSettingForm;
    private final EPGComponentConstants constants = GWT.create(EPGComponentConstants.class);

    public IngestTaskBasicTab(UITask model) {
        this.model = model;
        initForm();
    }

    private void initForm() {
        VerticalContainer vc = new VerticalContainer();
        vc.setWidth("95%");

        initBasicDisclosure(vc);
        initTriggerDisclosure(vc);
        initFollowingTaskInfoDisclosure(vc);
        ScrollPanel sp = new ScrollPanel();
        sp.addStyleName("epg-basicTab-scrollContainer");
        sp.setHeight("100%");
        sp.setWidth("100%");
        sp.add(vc);

        this.initWidget(sp);
    }

    private void initBasicDisclosure(VerticalContainer vc) {
        basicForm = new TaskBasicSettingForm(JobType.INGEST, model);

        RoundedDisclosureContainer basicInfoDisclosure = new RoundedDisclosureContainer(new LabelWidget(constants.basicTab()), true);
        basicInfoDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        basicInfoDisclosure.setContent(basicForm);
        vc.add(basicInfoDisclosure);
    }

    private void initTriggerDisclosure(VerticalContainer vc) {
        triggerForm = new TaskTriggerSettingForm(JobType.INGEST, model);

        RoundedDisclosureContainer triggerInfoDisclosure = new RoundedDisclosureContainer(new LabelWidget(constants.triggerSetting()), true);
        triggerInfoDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        triggerInfoDisclosure.setContent(triggerForm);
        vc.add(triggerInfoDisclosure);
    }

    private void initFollowingTaskInfoDisclosure(VerticalContainer vc) {
        followingTaskSettingForm = new FollowingTaskSettingForm();
        followingTaskSettingForm.buildData(model);

        RoundedDisclosureContainer followingIngestionInfoDisclosure = new RoundedDisclosureContainer(new LabelWidget(constants.followingTaskSetting()), true);
        followingIngestionInfoDisclosure.addStyleName(STYLE_DISCLOSURE_CONTAINER);
        followingIngestionInfoDisclosure.setContent(followingTaskSettingForm);
        vc.add(followingIngestionInfoDisclosure);
    }

    @Override
    public String getName() {
        return "ingestTaskBasicTab";
    }

    @Override
    public String getDisplayName() {
        return "Basic Setting";
    }

    @Override
    public void setSelected(boolean selected) {
        //
    }

    public TypedListBoxWidget<Long> getFormatTypeList() {
        return basicForm.getFormatTypeList();
    }

    @Override
    public List<String> validate() {
        List<String> validationMessages = new ArrayList<String>();
        validationMessages.addAll(basicForm.validateField());
        validationMessages.addAll(triggerForm.validateField());
        return validationMessages;
    }

    /**
     * Fill the values into the current model and return it.
     * 
     * @return
     */
    public UITask populateModel() {
        basicForm.populateModel();
        triggerForm.populateModel();
        followingTaskSettingForm.populateModel();
        return model;
    }

    @Override
    public void reload() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateScrollPanelSize() {
        
    }
}