package com.ericsson.cms.epgmgmt.client.task;

import java.util.List;
import java.util.Set;

import com.ericsson.cms.epgmgmt.client.model.UIPartner;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.model.enumeration.JobType;
import com.ericsson.cms.epgmgmt.client.partner.ExecutionLogTab;
import com.ericsson.cms.epgmgmt.client.utils.MessageAreaUtils;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.TabContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class IngestTaskDialog extends AbstractTaskDialog {

    private TabContainer tabContainer;
    private IngestTaskBasicTab basicTab;
    private TaskPluginPropertyTab pluginPropertiesTab;

    public IngestTaskDialog(UIPartner partner, AbstractTaskListViewPanel parent) {
        super(partner, parent);
    }

    public IngestTaskDialog(UITask task, UIPartner partner, AbstractTaskListViewPanel parent) {
        super(task, partner, parent);
    }

    /**
     * Load plugin properties tab according to the format ID for the moment.
     */
    public void loadPluginProperties() {
        clearMessageArea();
        pluginPropertiesTab.loadProperties();
    }

    @Override
    public UITask populateTask() {
        current = basicTab.populateModel();
        current.setPluginPropertyValues(pluginPropertiesTab.populatePluginProperties());
        return current;
    }

    public TabContainer getTabContainer() {
        return tabContainer;
    }

    @Override
    protected void initContent(VerticalContainer vc) {
        tabContainer = new TabContainer();
        tabContainer.setWidth("100%");
        tabContainer.addStyleName("tabContainer");
        basicTab = new IngestTaskBasicTab(current);
        basicTab.setHeight(TAB_HEIGHT);
        pluginPropertiesTab = new TaskPluginPropertyTab(current, history);
        pluginPropertiesTab.setHeight(TAB_HEIGHT);
        tabContainer.add(basicTab, basicTab.getDisplayName());
        tabContainer.add(pluginPropertiesTab, pluginPropertiesTab.getDisplayName());
        if(this.history.getId()>0){
            ExecutionLogTab logTab = createExeLogTab(JobType.INGEST);
            tabContainer.add(logTab, logTab.getDisplayName());
        }
        tabContainer.selectTab(0);
        vc.add(tabContainer);

        bindHandler();
    }

    private void bindHandler() {
        basicTab.getFormatTypeList().addValueChangeHandler(new ValueChangeHandler<Long>() {
            @Override
            public void onValueChange(ValueChangeEvent<Long> event) {
                if (event.getValue() == pluginPropertiesTab.getCurrentFormatId()) {
                    return;
                }
                loadPluginProperties();
            }
        });
    }

    @Override
    protected ClickHandler getCreateButtonClickHandler() {
        return new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                messageArea.reset();
                List<String> errors = basicTab.validate();
                UITask task = populateTask();
                if (!partner.isActive() && task.isEnabled()) {
                    errors.add(messages.enableTaskWhilePartnerIsDisabled());
                }
                if (errors != null && !errors.isEmpty()) {
                    MessageAreaUtils.displayErrorMessages("", errors, "", messageArea);
                    return;
                }
                validateAndSubmit(task);
            }
        };
    }

    @Override
    protected void setModelDefaultValue(UITask model) {
        model.setType(JobType.INGEST.toString());
    }


    @Override
    protected void submit(final UITask task) {
        if (task.getId() == 0) {
            // Create
            busyIndicator.center();
            taskService.createTask(task, new NeptuneAsyncCallback<Long>() {
                @Override
                public void onNeptuneFailure(Throwable caught) {
                    busyIndicator.hide();
                    MessageAreaUtils.handleException(caught, messageArea);
                }

                @Override
                public void onNeptuneSuccess(Long result) {
                    busyIndicator.hide();
                    dialog.hide();
                    parent.refresh();
                }
            });
        } else {
            // Update
            busyIndicator.center();

            final boolean isEnableInUI = task.isEnabled();
            taskService.isTaskEnableInDb(task, new NeptuneAsyncCallback<Boolean>() {
                @Override
                public void onNeptuneSuccess(Boolean result) {
                    boolean isEnableInDB = result;
                    boolean enable2Disable = isEnableInDB && !isEnableInUI;

                    if(enable2Disable) {
                        taskService.getEnabledSubscribedTasks(task.getId(), new NeptuneAsyncCallback<Set<UITask>>() {
                            @Override
                            public void onNeptuneFailure(Throwable caught) {
                            }

                            @Override
                            public void onNeptuneSuccess(Set<UITask> tasks) {
                                busyIndicator.hide();

                                boolean needConfirm = tasks.size() !=0;
                                boolean updateConfirmed = true;
                                if(needConfirm) {
                                    busyIndicator.center();

                                    String info = messages.subscriberTasksMessage("task", tasks2String(tasks));
                                    info += " Continue?";
                                    updateConfirmed = Window.confirm(info);
                                }

                                if(updateConfirmed) {
                                    updateTask(task);
                                }
                                else {
                                    dialog.hide();
                                    busyIndicator.hide();
                                }
                            }
                        });
                    }
                    else {
                        updateTask(task);
                    }
                }

                @Override
                public void onNeptuneFailure(Throwable caught) {
                    busyIndicator.hide();
                    createButton.setEnabled(true);
                    MessageAreaUtils.handleException(caught, messageArea);
                }
            });
        }
    }

    private void updateTask(UITask task) {
        taskService.updateTask(task, new NeptuneAsyncCallback<Void>() {
            @Override
            public void onNeptuneFailure(Throwable caught) {
                busyIndicator.hide();
                MessageAreaUtils.handleException(caught, messageArea);
            }

            @Override
            public void onNeptuneSuccess(Void result) {
                busyIndicator.hide();
                messageArea.setInfoMessage("Task updated.");
                dialog.hide();
                parent.refresh();
            }
        });
    }

    private String tasks2String(Set<UITask> tasks) {
        StringBuilder sb = new StringBuilder("[");

        for(UITask task: tasks) {
            sb.append(task.getPartnerName()+":"+task.getName() + ", ");
        }
        String str = sb.toString();
        str = str.substring(0, str.length()-2);
        str += "]";

        return str;
    }

}
