package com.ericsson.cms.epgmgmt.client.task;

import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.model.UIOrderedTask;
import com.ericsson.cms.epgmgmt.client.model.UITask;

public final class IngestTaskSorter {
    private static final String KEY_FOLLOWING_INGESTION = "FollowingIngestion";
    private IngestTaskSorter(){
        
    }
    public static  List<UIOrderedTask> sortByFollowUpOrder(List<UITask> l) {
        List<UIOrderedTask> ol = new ArrayList<UIOrderedTask>();
        while (!l.isEmpty()) {
            UITask t = l.get(0);
            l.remove(0);
            ol.add(recursiveSort(new UIOrderedTask(t), l, ol));
        }
        setOrder(ol);
        return flattern(ol);
    }

    private static void setOrder(List<UIOrderedTask> ol) {
        for (UIOrderedTask ot : ol) {
            ot.setLevel(1);
            setOrder(ot);
        }
    }

    private static void setOrder(UIOrderedTask ot) {
        List<UIOrderedTask> l = new ArrayList<UIOrderedTask>();
        l.add(ot);
        int order = 1;
        while (!l.isEmpty()) {
            UIOrderedTask t = l.get(0);
            l.remove(0);
            t.setOrder(order++);
            for (UIOrderedTask c : t.getChildTasks()) {
                l.add(c);
            }
        }
    }

    private static List<UIOrderedTask> flattern(List<UIOrderedTask> ol) {
        List<UIOrderedTask> l = new ArrayList<UIOrderedTask>();
        for (UIOrderedTask ot : ol) {
            recursiveFlattern(ot, l);
        }
        return l;
    }

    private static void recursiveFlattern(UIOrderedTask ot, List<UIOrderedTask> l) {
        for (int i = ot.getChildTasks().size() - 1; i >= 0; i--) {
            recursiveFlattern(ot.getChildTasks().get(i), l);
        }
        l.add(0, ot);
    }

    @SuppressWarnings("unchecked")
    private static UIOrderedTask recursiveSort(UIOrderedTask node, List<UITask> l, List<UIOrderedTask> ol) {
        if (!node.getTaskSettings().containsKey(KEY_FOLLOWING_INGESTION)) {
            return node;
        }

        List<String> ids = (List<String>) node.getTaskSettings().get(KEY_FOLLOWING_INGESTION).getSetting()
                .get(KEY_FOLLOWING_INGESTION);

        if (ids == null) {
            return node;
        }

        for (String id : ids) {
            UIOrderedTask target = null;
            for (UITask t : l) {
                if (String.valueOf(t.getId()).equals(id)) {
                    target = new UIOrderedTask(t);
                    l.remove(t);
                    node.getChildTasks().add(recursiveSort(target, l, ol));
                    break;
                }
            }
            if (target != null) {
                continue;
            }
            for (UIOrderedTask ot : ol) {
                if (String.valueOf(ot.getId()).equals(id)) {
                    node.getChildTasks().add(ot);
                    ol.remove(ot);
                    break;
                }
            }
        }

        return node;
    }
}
