package com.ericsson.cms.epgmgmt.client.task;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UIOrderedTask;
import com.ericsson.cms.epgmgmt.client.model.enumeration.JobStatus;
import com.ericsson.cms.epgmgmt.client.model.enumeration.TriggerType;
import com.ericsson.cms.epgmgmt.client.widget.ImageButtonBarView;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.label.LabelStringView;

final class TaskActionColumn extends ColumnBase<String, UIOrderedTask> {

    private final EPGComponentConstants constants = GWT.create(EPGComponentConstants.class);
    private final AbstractTaskDataProvider dataProvider;

    TaskActionColumn(AbstractTaskDataProvider dataProvider, String name, String displayName) {
        super(name, displayName);
        this.dataProvider = dataProvider;
    }

    @Override
    public View<String> getView(final UIOrderedTask task) {
        if (!dataProvider.getPartner().isActive()) {
            return new LabelStringView("");
        }

        String[] labels = { constants.buttonLabelRemove(), constants.cloneButtonLabel(), constants.buttonLabelCancel(),
                constants.buttonLabelStart() };
        String[] imageUrls = { "cms_epgmgmt_ui/images/delete.png", "cms_epgmgmt_ui/images/clone.png",
                "cms_epgmgmt_ui/images/stop.png", "cms_epgmgmt_ui/images/activation.png" };
        ImageButtonBarView v = new ImageButtonBarView(labels, imageUrls, task.isEnabled(),
                HasHorizontalAlignment.ALIGN_DEFAULT);

        // Remove button
        Image removeButton = v.getButton(0);//NOSONAR
        removeButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                dataProvider.deleteTask(task);
            }
        });
        removeButton.setVisible(true);

        // Cancel button
        Image cancelButton = v.getButton(2);// NOSONAR
        cancelButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                dataProvider.cancelTask(task);
            }
        });
        cancelButton.setVisible((task.getJobStatus().getJobStatus() == JobStatus.RUNNING)
                || (task.getJobStatus().getJobStatus() == JobStatus.QUEUING));

        // Start button
        Image startButton = v.getButton(3);// NOSONAR
        startButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                dataProvider.startTask(task);
            }
        });
        startButton.setVisible(task.isEnabled()
                && task.getUiTaskTrigger().getTriggerType().equals(TriggerType.ONDEMAND)
                && (task.getJobStatus().getJobStatus() != JobStatus.RUNNING)
                && (task.getJobStatus().getJobStatus() != JobStatus.QUEUING));

        // Clone button
        Image cloneButton = v.getButton(1);//NOSONAR
        cloneButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                dataProvider.cloneTask(task);
            }
        });
        cloneButton.addStyleName("marginRight");
        cloneButton.setVisible(true);

        return v;
    }
}