package com.ericsson.cms.epgmgmt.client.task;

import java.util.List;

import com.ericsson.cms.epgmgmt.client.PluginPropertiesForm;
import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.ericsson.cms.epgmgmt.client.model.UIPluginProperty;
import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.partner.IPartnerTab;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGPluginManagerService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGPluginManagerServiceAsync;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class TaskPluginPropertyTab extends Composite implements IPartnerTab {

    private final EPGComponentConstants constants = (EPGComponentConstants) GWT.create(EPGComponentConstants.class);
    private final IEPGPluginManagerServiceAsync pluginService = GWT.create(IEPGPluginManagerService.class);
    private final VerticalContainer mainPanel;
    private final PluginPropertiesForm pluginProperties;
    private final UITask model;
    private final UITask history;
    private long currentFormatId = 0L;

    public TaskPluginPropertyTab(UITask model, UITask history) {
        NeptuneApplication.getApplication().getSecurity();
        this.model = model;
        this.history = history;
        mainPanel = new VerticalContainer();
        mainPanel.setSpacing(10);
        mainPanel.setWidth("100%");
        pluginProperties = new PluginPropertiesForm();
        initForm();
    }

    private void initForm() {
        ScrollPanel sp = new ScrollPanel();
        sp.addStyleName("epg-basicTab-scrollContainer");
        sp.setHeight("100%");
        sp.setWidth("100%");
        sp.add(mainPanel);

        initWidget(sp);
        showDefaultDisplayMessage();
        loadProperties();
    }

    public void showDefaultDisplayMessage() {
        mainPanel.clear();
    }

    public List<UIPluginProperty> setPluginPropertiesForm() {
        return pluginProperties.setPluginPropertiesForm();
    }

    private void buildPropertiesForm(long formatId) {
        mainPanel.clear();

        if (formatId <= 0) {
            showDefaultDisplayMessage();
            return;
        }

        pluginProperties.setPluginProperties(formatId);

        mainPanel.add(pluginProperties);
        setCurrentFormatId(formatId);
    }

    private void buildUpdateProviderPropertiesForm(List<UIPluginProperty> pluginPropertyValues) {
        mainPanel.clear();

        if ((pluginPropertyValues == null) || pluginPropertyValues.isEmpty()) {
            showDefaultDisplayMessage();
            return;
        }

        mainPanel.add(pluginProperties);
        pluginProperties.setPluginPropertiesForUpdate(pluginPropertyValues);
    }

    public void loadProperties() {
        if (model.getFormatId() == currentFormatId) {
            return;
        }

        setCurrentFormatId(model.getFormatId());

        if (model.getFormatId() <= 0) {
            showDefaultDisplayMessage();
            return;
        }

        pluginService.isPluginActive(model.getFormatId(), new NeptuneAsyncCallback<Boolean>() {

            @Override
            public void onNeptuneFailure(Throwable caught) {
                //
            }

            @Override
            public void onNeptuneSuccess(Boolean isEnabled) {
                if (!isEnabled) {
                    showDefaultDisplayMessage();
                } else if (model.getFormatId() == history.getFormatId()) {
                    if ((history.getPluginPropertyValues() == null) || history.getPluginPropertyValues().isEmpty()) {
                        buildPropertiesForm(model.getFormatId());
                    } else {
                        buildUpdateProviderPropertiesForm(history.getPluginPropertyValues());
                    }
                } else {
                    buildPropertiesForm(model.getFormatId());
                }
            }
        });
    }

    public Long getCurrentFormatId() {
        return currentFormatId;
    }

    public void setCurrentFormatId(Long formatId) {
        currentFormatId = formatId;
    }

    public List<UIPluginProperty> populatePluginProperties() {
        return pluginProperties.setPluginPropertiesForm();
    }

    @Override
    public String getName() {
        return "PluginProperties";
    }
    @Override
    public String getDisplayName() {
        return constants.pluginPropertiesDisplayMsgTab();
    }

    @Override
    public void setSelected(boolean selected) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reload() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMessageArea(MessageArea messageArea) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> validate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateScrollPanelSize() {
    }
}
