package com.ericsson.cms.epgmgmt.client.task;

import com.ericsson.cms.epgmgmt.client.model.UIOrderedTask;
import com.ericsson.cms.epgmgmt.client.widget.ImageLabelView;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.ColumnBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;

public final class TaskStatusColumn extends ColumnBase<String, UIOrderedTask> {
    private final boolean isShowLabel;
    TaskStatusColumn(String name, String displayName, boolean isShowLabel) {
        super(name, displayName);
        this.isShowLabel = isShowLabel;
    }
    @Override
    public View<String> getView(UIOrderedTask task) {
        TaskStatusHelper helper = new TaskStatusHelper(task, isShowLabel);
        ImageLabelView v = new ImageLabelView(helper.getLabel() , helper.getTitle() , helper.getImageUrl());
        if (!task.isEnabled()) {
            v.setStyleName("epg-disabled");
        }
        return v;
    }
}