package com.ericsson.cms.epgmgmt.client.task;

import com.ericsson.cms.epgmgmt.client.model.UITask;
import com.ericsson.cms.epgmgmt.client.model.enumeration.JobStatus;

public class TaskStatusHelper {
    private String title;
    private String label;
    private String imageUrl;

    public TaskStatusHelper(UITask task, boolean isShowLabel){
        title = "";
        label = "";
        imageUrl = "";
        if(task.getJobStatus().getJobStatus()==null){
            return;
        }
        switch(task.getJobStatus().getJobStatus()){
        case RUNNING:
            title = task.getJobStatus().getProgress() +"%";
            if(isShowLabel){
                label= title;
            }
            imageUrl = "cms_epgmgmt_ui/images/running_inprogress.png";
            break;
        case QUEUING:
            title = JobStatus.QUEUING.toString();
            imageUrl = "cms_epgmgmt_ui/images/queued.png";
            break;
        case DEACTIVE:
            imageUrl = "cms_epgmgmt_ui/images/idle.png";
            title = JobStatus.DEACTIVE.toString();
            break;
        case WAITING:
            imageUrl = "cms_epgmgmt_ui/images/idle_green.png";
            title = JobStatus.WAITING.toString();
            break;
        case COMPLETED:
        case SUSPENDED:
            imageUrl = "cms_epgmgmt_ui/images/running_completed.png";
            title = JobStatus.COMPLETED.toString();
            break;
        case FAILDED:
            imageUrl = "cms_epgmgmt_ui/images/running_failed.png";
            title = JobStatus.FAILDED.toString();
            break;
        case CANCELD:
            imageUrl = "cms_epgmgmt_ui/images/running_cancelled.png";
            title = JobStatus.CANCELD.toString();
            break;
        }
    }

    public String getTitle() {
        return title;
    }

    public String getLabel() {
        return label;
    }

    public String getImageUrl() {
        return imageUrl;
    }
    
}
