package com.ericsson.cms.epgmgmt.client.utils;

import java.util.Date;

import com.google.gwt.i18n.client.DateTimeFormat;

public class DateConvert {	
	public static final int HOURS_IN_ONE_DAY = 24;
	public static final int HOURS_IN_HALF_DAY  =12;
	public static final int ONE_HOUR = 60*60*1000;

    private DateConvert() {
        super();
    }
    
	public static long constructDateInMilliSeconds(Date startDate, String time){

		long dateInMilliSeconds = 0l;
		long offset = 0l;
		
		String[] detailTime = time.split(" ");
		int hour = Integer.parseInt(detailTime[0].split(":")[0]);
    	
		if ((detailTime[1].equals("AM") && hour != 12) || (detailTime[1].equals("PM") && hour == 12)) {
			offset = hour * ONE_HOUR;
		} else if (detailTime[1].equals("AM") && hour == 12) {
			offset = 0l;
		} else {
			offset = (hour + HOURS_IN_HALF_DAY) * ONE_HOUR;
		}
    	
    	dateInMilliSeconds = startDate.getTime()+offset;
		return dateInMilliSeconds;
	}
	
	public static Date parseDate(String patten, String date){
		DateTimeFormat dateFormatter = DateTimeFormat.getFormat(patten);
		return dateFormatter.parse(date);
		
	}
	
	public static String formatDate(String patten, Date date){
		DateTimeFormat dateFormatter = DateTimeFormat.getFormat(patten);
		return dateFormatter.format(date);
		
	}
	
	
	

}
