package com.ericsson.cms.epgmgmt.client.utils;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;

public class MessageAreaUtils {

    public static String buildMessages(String heading, List<String> messageItems, String message) {
        StringBuilder html = new StringBuilder(200);
        if (heading != null) {
            html.append(heading).append("<br>");
        }
        if (messageItems != null) {
            html.append("<ul>");
            for (String e : messageItems) {
                html.append("<li>" + e + "</li>");
            }
            html.append("</ul>");
        }
        if (message != null) {
            html.append(message);
        }

        return html.toString();
    }

    public static void displayErrorMessages(String heading, List<String> messageItems, String message,
            MessageArea messageArea) {
        messageArea.setErrorHTML(buildMessages(heading, messageItems, message));
    }

    public static void displayErrorMessage(String heading, String errmsg, String message, MessageArea messageArea) {
        List<String> l = new ArrayList<String>(1);
        l.add(errmsg);

        messageArea.setErrorHTML(buildMessages(heading, l, message));
    }

    public static void handleException(Throwable caught, MessageArea messageArea) {
        if (caught instanceof ValidationException) {
            ValidationException ve = (ValidationException) caught;
            if (ve.getValidationMessages().size() > 0) {
                displayErrorMessages("", ve.getValidationMessages(), "", messageArea);
            }
        } else {
            displayErrorMessage("", caught.getLocalizedMessage(), "", messageArea);
        }
    }
}
