package com.ericsson.cms.epgmgmt.client.utils;

import com.google.gwt.dom.client.Style.Overflow;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;

/**
 * A small popup window for prompting message.
 * 
 * @author Evan Huang
 */
public class PromptWindow {

    private static final int WIDTH = 250;
    private static final int HEIGHT = 100;
    private static final int INTERVAL = 20;

    private static PromptWindow instance;

    private PromptWindow() {
        //
    }

    /**
     * Get the new instance.
     * 
     * @return
     */
    public static PromptWindow getInstance() {
        if (instance == null) {
            instance = new PromptWindow();
        }
        return instance;
    }

    /**
     * Display the message for 5 seconds.
     * 
     * @param message
     */
    public void prompt(String message) {
        prompt(message, 5000);
    }

    /**
     * Prompt the message and show it in the given time period
     * 
     * @param message
     * @param delay
     *            time in milliseconds
     */
    public void prompt(String message, final int delay) {
        final PopupPanel pp = new PopupPanel();
        pp.setPixelSize(WIDTH, HEIGHT);
        pp.getElement().getStyle().setBackgroundColor("#ffffdd");

        pp.setWidget(new Label(message));

        pp.setPopupPosition((Window.getClientWidth() - WIDTH) / 2, Window.getClientHeight() - HEIGHT - 20);
        pp.show();

        final Timer t = new Timer() {
            @Override
            public void run() {
                slideDown(pp);
            }
        };
        t.schedule(delay);
    }


    private Timer slideDown(final PopupPanel pp) {
        pp.getElement().getStyle().setOverflow(Overflow.HIDDEN);
        Timer t = new Timer() {

            @Override
            public void run() {
                if (pp.getElement().getClientHeight() <= INTERVAL) {
                    cancel();
                    pp.hide();
                    return;
                }
                pp.getElement().getStyle().setHeight(pp.getElement().getClientHeight() - INTERVAL, Unit.PX);
                pp.setPopupPosition(pp.getElement().getOffsetLeft(), (pp.getPopupTop() + INTERVAL) - 6);
            }
        };
        t.scheduleRepeating(100);
        return t;
    }
}
