package com.ericsson.cms.epgmgmt.client.utils;

public class StringUtils {

    private static final int bufSizeNum = 16;

    private StringUtils() {
        super();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }


    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static boolean isNotEmpty(String str) {
        return !isEmpty(str);
    }

    public static String join(Object[] array, String separator) {
        if (array == null) {
            return null;
        }
        return join(array, separator, 0, array.length);
    }

    public static String join(Object[] array, String separator, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        String localSeparator = separator;
        if (localSeparator == null) {
            localSeparator = "";
        }

        int bufSize = endIndex - startIndex;
        if (bufSize <= 0) {
            return "";
        }

        bufSize *= (array[startIndex] == null ? bufSizeNum : array[startIndex].toString().length())
                + localSeparator.length();

        StringBuffer buf = new StringBuffer(bufSize);

        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                buf.append(separator);
            }
            if (array[i] != null) {
                buf.append(array[i]);
            }
        }
        return buf.toString();
    }
}
