package com.ericsson.cms.epgmgmt.client.widget;

import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.CheckBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.ViewBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class AlignableCheckBoxView extends ViewBase<Boolean> {

    private CheckBoxWidget checkbox;

    private HorizontalAlignmentConstant alignment;

    public AlignableCheckBoxView(Boolean value, boolean isEnabled, HorizontalAlignmentConstant alignment) {
        super(value);
        this.alignment = alignment;
        checkbox.setEnabled(isEnabled);
    }

    @Override
    public Widget getWidget() {
        HorizontalContainer hc = new HorizontalContainer();
        hc.setWidth("100%");
        hc.setHorizontalAlignment(alignment);
        hc.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        hc.add(checkbox);
        return hc;
    }

    public CheckBoxWidget getCheckbox() {
        return checkbox;
    }

    @Override
    protected Boolean getViewValue() {
        return checkbox.getValue();
    }

    @Override
    protected void setViewValue(Boolean value) {
        checkbox.setValue(value);
    }

    @Override
    protected void preInitialValueSet() {
        checkbox = new CheckBoxWidget();
    }

    @Override
    public void release() {
        // TODO Auto-generated method stub

    }
}
