package com.ericsson.cms.epgmgmt.client.widget;


import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class ButtonBarView implements View<String> {

    private ButtonWidget[] buttons;
    private HorizontalContainer hc;

    public ButtonBarView(String[] labels, boolean enabled) {
        hc = new HorizontalContainer();
        if ((labels != null) && (labels.length > 0)) {
            buttons = new ButtonWidget[labels.length];
            for (int i = 0; i < buttons.length; i++) {
                buttons[i] = new ButtonWidget(labels[i]);
                hc.add(buttons[i]);
                if (!enabled) {
                    buttons[i].setEnabled(false);
                }
            }
        }
    }

    @Override
    public Widget getWidget() {
        return hc;
    }

    @Override
    public String getStyleName() {
        return null;
    }

    @Override
    public void release() {
        //
    }

    public ButtonWidget getButton(int index) {
        if ((buttons != null) && (index < buttons.length)) {
            return buttons[index];
        }
        return null;
    }
}
