/*
 * Created on May 21, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.ericsson.cms.epgmgmt.client.widget;

import static com.google.gwt.user.client.ui.HasHorizontalAlignment.ALIGN_CENTER;
import static com.google.gwt.user.client.ui.HasVerticalAlignment.ALIGN_MIDDLE;

import org.cobogw.gwt.user.client.ui.RoundedPanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.RoundedDisclosureContainerImages;

/**
 * <p>
 * A decorated version of the disclosure panel which will enable the header to have rounded corners.
 * Extends DisclosureContainer which in turn extends the GWT {@link DisclosurePanel} widget.
 * </p>
 * <h3>CSS Style Rules</h3>
 * <ul>
 * <li>wtk-RoundedDisclosureContainer { the panel's primary style }</li>
 * <li>wtk-RoundedDisclosureContainer-open { dependent style set when panel is open }</li>
 * <li>wtk-RoundedDisclosureContainer-closed { dependent style set when panel is closed }</li>
 * </ul>
 * <p>
 * <img class='gallery' src='DisclosurePanel.png'/>
 * </p>
 * <p>
 * The header and content sections can be easily selected using css with a child selector:<br/>
 * .gwt-DisclosurePanel-open .header { ... }
 * </p>
 * <p>
 * The label and label-corner sections can be easily selected using css with a child selector:<br/>
 * .gwt-DisclosurePanel-open .label { ... } <br/>
 * .gwt-DisclosurePanel-open .label-corners { ... }
 * </p>
 * 
 * @see com.google.gwt.user.client.ui.DisclosurePanel
 * @author mpetrusis
 */
public class EPGNoIconRoundedDisclosureContainer extends DisclosureContainer {

    /* Style Names */
    private static final String STYLENAME_DEFAULT = "nwt-RoundedDisclosureContainer";
    private static final String STYLENAME_LABEL_CORNERS = "label-corners";
    private static final String STYLENAME_LABEL = "label";

    /**
     * Constructor
     * 
     * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(String)
     */
    public EPGNoIconRoundedDisclosureContainer(String headerText) {
        this(headerText, false);
    }

    /**
     * Constructor
     * 
     * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(String, boolean)
     */
    public EPGNoIconRoundedDisclosureContainer(String headerText, boolean isOpen) {
        this(createDefaultImages(), headerText, isOpen);
    }

    /**
     * Constructor
     * 
     * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(Widget)
     */
    public EPGNoIconRoundedDisclosureContainer(Widget header) {
        this(header, false);
    }

    /**
     * Constructor
     * 
     * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(Widget, boolean)
     */
    public EPGNoIconRoundedDisclosureContainer(Widget header, boolean isOpen) {
        this(createDefaultImages(), header, isOpen);
    }

    /**
     * Constructor
     * 
     * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(RoundedDisclosurePanelImages,
     *      String, boolean)
     */
    public EPGNoIconRoundedDisclosureContainer(RoundedDisclosureContainerImages images, String headerText,
            boolean isOpen) {
        this(images, new LabelWidget(headerText), isOpen);
    }

    /**
     * Constructor
     */
    public EPGNoIconRoundedDisclosureContainer(RoundedDisclosureContainerImages images, Widget header,
            boolean isOpen) {
        super();
        initialize(header, images);
        setOpen(isOpen);
    }

    private void initialize(Widget headerWidget, RoundedDisclosureContainerImages images) {
        setStylePrimaryName(STYLENAME_DEFAULT);
        RoundedPanelHeader header = new RoundedPanelHeader(headerWidget, images);
        setHeader(header);
    }
    
    /*
     * The default images to use
     */
    private static RoundedDisclosureContainerImages createDefaultImages() {
        return GWT.create(RoundedDisclosureContainerImages.class);
    }

    /**
     * The header widget used for this panel
     */
    private final class RoundedPanelHeader extends Composite implements OpenHandler<DisclosureContainer>,
            CloseHandler<DisclosureContainer> {
        private final Widget headerWidget;
        private final RoundedDisclosureContainerImages images;
        private final Image iconImage;

        private RoundedPanelHeader(Widget headerWidget, RoundedDisclosureContainerImages images) {
            this.images = images;
            this.headerWidget = headerWidget;
            this.iconImage = new Image(images.disclosurePanelClosed());

            RoundedPanel container = new RoundedPanel(RoundedPanel.ALL, 3); //NOSONAR
            container.setCornerStyleName(STYLENAME_LABEL_CORNERS);
            initWidget(container);

            HorizontalContainer contents = new HorizontalContainer();
            container.setWidget(contents);
            contents.addStyleName(STYLENAME_LABEL);
            contents.setSpacing(3); //NOSONAR

            /* Add the contents */
            // contents.add(this.iconImage); // modified by Component team
            contents.add(new LabelWidget());
            contents.add(this.headerWidget);
            contents.setCellVerticalAlignment(this.iconImage, ALIGN_MIDDLE);
            contents.setCellHorizontalAlignment(this.iconImage, ALIGN_CENTER);
            contents.setCellWidth(this.iconImage, (iconImage.getWidth() + 2) + "px");

            addOpenHandler(this);
            addCloseHandler(this);
            setStyle();
        }

        @Override
        public void onClose(CloseEvent<DisclosureContainer> event) {
            setStyle();
            setOpen(true);
        }

        @Override
        public void onOpen(OpenEvent<DisclosureContainer> event) {
            setStyle();
        }

        /*
         * Update the image
         */
        private void setStyle() {
            if (isOpen()) {
                iconImage.setResource(images.disclosurePanelOpen());
            } else {
                iconImage.setResource(images.disclosurePanelClosed());
            }
        }
    }
}

