package com.ericsson.cms.epgmgmt.client.widget;

import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.EXCLUDE_VALUE_KEY;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.HEADEND_KEY;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.INCLUDE_VALUE_KEY;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.KEY_SPLIT_SYMBOL;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.PROVIDER_KEY;
import static com.ericsson.cms.epgmgmt.client.model.UITaskSetting.STATION_KEY;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.model.UIFilterEntity;
import com.ericsson.cms.epgmgmt.client.model.UiHeadend;
import com.ericsson.cms.epgmgmt.client.model.UiStation;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGManagerHeadendService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGManagerHeadendServiceAsync;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGManagerStationService;
import com.ericsson.cms.epgmgmt.client.rpc.IEPGManagerStationServiceAsync;
import com.ericsson.cms.epgmgmt.client.utils.CollectionUtils;
import com.ericsson.cms.epgmgmt.client.utils.StringUtils;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;

/**
 * Headend and Station selector. Craete the popup panel to select Headend and Station
 * 
 * @author Kevin.zhao
 */
public class HeadendStationSelectorPanel extends Composite {

    private static final String WIDTH_10PX = "10px";
    private static final String STYLE_EXPORTSETTING_SMMAL_TEXT_SIZE = "epg-exportsetting-smmalTextSize";
    private static final int COLUMNS_IN_PAGINATION_PANEL = 3;
    private static final int POPUP_PANEL_WIDTH = 700;
    private static final int POPUP_PANEL_HEIGHT = 335;

    private final IEPGManagerStationServiceAsync stationService = GWT.create(IEPGManagerStationService.class);
    private final IEPGManagerHeadendServiceAsync headendService = GWT.create(IEPGManagerHeadendService.class);

    private static final String STYLE_INPUT_DOWNLIST = "epg-input-bg";

    private static final EPGComponentMessages CONSTANTS_MSG = (EPGComponentMessages) GWT
            .create(EPGComponentMessages.class);
    private static final String HEADEND_FILTER_SWITCH_TIP = CONSTANTS_MSG.headendFilterSwitchHelpTip();
    private static final String STATION_FILTER_SWITCH_TIP = CONSTANTS_MSG.stationFilterSwitchHelpTip();
    private static final String HEADEND_PRIMARY_SEARCH_INPUT_TIP = CONSTANTS_MSG.headendPrimarySearchTip();
    private static final String HEADEND_SECONDARY_SEARCH_INPUT_TIP = CONSTANTS_MSG.headendSecondarySearchTip();
    private static final String STATION_PRIMARY_SEARCH_INPUT_TIP = CONSTANTS_MSG.stationPrimarySearchTip();
    private static final String STATION_SECONDARY_SEARCH_INPUT_TIP = CONSTANTS_MSG.stationSecondarySearchTip();
    protected static final String EXCLUDE_MUST_SELECTED_RECORD_TIP = CONSTANTS_MSG.excludeMustSelectedRecordTip();

    private String headendFilterHelpIconTip;
    private String stationFilterHelpIconTip;
    private String filterTitle = "";
    private HorizontalPanel headendChoosePanel;
    private CheckBox headendFilterIncludeSwitchBox;
    private TextBox headendInfoShowTextBox;
    private PaginationCheckboxPanel headendPopupPanel;
    private ImageWidget headendCleanButtonIcon;
    private final HorizontalPanel headendCleanPanel = new HorizontalPanel();

    private HorizontalPanel stationChoosePanel;
    private CheckBox stationFilterIncludeSwitchBox;
    private TextBox stationInfoShowTextBox;
    private PaginationCheckboxPanel stationPopupPanel;
    private ImageWidget stationCleanButtonIcon;
    private final HorizontalPanel stationCleanPanel = new HorizontalPanel();

    private Long providerId;
    private Map<String, List<String>> selectedHeadendMap = new HashMap<String, List<String>>();
    private Map<String, List<String>> selectedStationMap = new HashMap<String, List<String>>();
    private List<String> selectedHeadends = new ArrayList<String>();
    private List<String> selectedStations = new ArrayList<String>();

    public HeadendStationSelectorPanel() {
        NeptuneApplication.getApplication().getSecurity();
    }

    public void buildData(Long providerId, Map<String, List<String>> selectedHeadendMap,
            Map<String, List<String>> selectedStationMap) {
        this.providerId = providerId;
        if (selectedHeadendMap != null) {
            this.selectedHeadendMap = selectedHeadendMap;
            this.selectedHeadends = this.selectedHeadendMap.get(HEADEND_KEY +  KEY_SPLIT_SYMBOL + getFilterTypeKeyFromDB(
                    selectedHeadendMap, HEADEND_KEY));
        }
        if (selectedStationMap != null) {
            this.selectedStationMap = selectedStationMap;
            this.selectedStations = this.selectedStationMap.get(STATION_KEY +  KEY_SPLIT_SYMBOL + getFilterTypeKeyFromDB(
                    selectedStationMap, STATION_KEY));
        }

        buildForm();
    }

    public HorizontalPanel createHeadendHorizontalPanel() {
        return this.headendChoosePanel;
    }

    public HorizontalPanel createStationHorizontalPanel() {
        return this.stationChoosePanel;
    }

    private void buildForm() {
        headendChoosePanel = buildHeadendFilterRow();
        stationChoosePanel = buildStationFilterRow();
    }

    private HorizontalPanel buildHeadendFilterRow() {
        List<String> columnName = new ArrayList<String>(COLUMNS_IN_PAGINATION_PANEL);
        columnName.add("ID");
        columnName.add("Headend Name");
        columnName.add("Zip Code");

        // Create Exclude checkbox and Txtbox
        HorizontalPanel headendChoosePanel = buildHeadendRowPanelWidget();

        headendCleanButtonIcon = buildCleanIcon(HEADEND_FILTER_SWITCH_TIP);
        headendCleanButtonIcon.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                buildHeadendData(new ArrayList<String>());
                updateStationPanelTriggerByUpStreamChange(new ArrayList<UIFilterEntity>(), selectedStations);
                headendCleanPanel.remove(headendCleanButtonIcon);
                headendFilterIncludeSwitchBox.setValue(false);
                stationFilterIncludeSwitchBox.setValue(false);
            }
        });

        headendCleanPanel.clear();
        headendCleanPanel.setWidth("22px");
        headendChoosePanel.add(headendCleanPanel);
        if (!CollectionUtils.isEmpty(selectedHeadends)) {
            headendCleanPanel.add(headendCleanButtonIcon);
        }

        // build popup panel
        headendPopupPanel = new PaginationCheckboxPanel(columnName, headendInfoShowTextBox,
                HEADEND_PRIMARY_SEARCH_INPUT_TIP, HEADEND_SECONDARY_SEARCH_INPUT_TIP);
        headendPopupPanel.addCloseHandler(new CloseHandler<PopupPanel>() {
            @Override
            public void onClose(CloseEvent<PopupPanel> event) {
                List<UIFilterEntity> selectedHeadendFromPanel = headendPopupPanel.getSelectedValue();
                updateStationPanelTriggerByUpStreamChange(selectedHeadendFromPanel,
                        stationPopupPanel.getLastSelectedDataIDListCache());
                if (headendPopupPanel.getSelectedValue().size() > 0) {
                    headendCleanPanel.add(headendCleanButtonIcon);
                } else {
                    headendCleanPanel.remove(headendCleanButtonIcon);
                    headendFilterIncludeSwitchBox.setValue(false);
                }
            }
        });
        headendInfoShowTextBox.addClickHandler(getInfoShowTextBoxClickHandler(headendPopupPanel));

        ImageWidget helpIcon = buildHelpIcon(getHeadendFilterHelpIconTip());
        headendChoosePanel.add(createLabel("", WIDTH_10PX, ""));
        headendChoosePanel.add(helpIcon);

        buildHeadendData(selectedHeadends);
        updateHeadendAndStationByProvider(String.valueOf(getProviderId()));
        return headendChoosePanel;
    }

    private HorizontalPanel buildStationFilterRow() {
        List<String> columnName = new ArrayList<String>(COLUMNS_IN_PAGINATION_PANEL);
        columnName.add("ID");
        columnName.add("Station Name");
        columnName.add("City");

        HorizontalPanel stationChoosePanel = buildStationPanleWidget();

        stationCleanButtonIcon = buildCleanIcon(STATION_FILTER_SWITCH_TIP);
        stationCleanButtonIcon.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                List<UIFilterEntity> selectedHeadendFromPanel = headendPopupPanel.getSelectedValue();
                updateStationPanelTriggerByUpStreamChange(selectedHeadendFromPanel, new ArrayList<String>());
                selectedStations.clear();
                stationFilterIncludeSwitchBox.setValue(false);
            }
        });

        stationCleanPanel.clear();
        stationCleanPanel.setWidth("22px");
        stationChoosePanel.add(stationCleanPanel);

        if (!CollectionUtils.isEmpty(selectedStations)) {
            stationCleanPanel.add(stationCleanButtonIcon);
        }

        stationPopupPanel = new PaginationCheckboxPanel(columnName, stationInfoShowTextBox,
                STATION_PRIMARY_SEARCH_INPUT_TIP, STATION_SECONDARY_SEARCH_INPUT_TIP);
        stationPopupPanel.addCloseHandler(new CloseHandler<PopupPanel>() {
            @Override
            public void onClose(CloseEvent<PopupPanel> event) {
                List<UIFilterEntity> selectedStationFromPanel = stationPopupPanel.getSelectedValue();
                if (selectedStationFromPanel.size() > 0) {
                    stationCleanPanel.add(stationCleanButtonIcon);
                } else {
                    stationCleanPanel.remove(stationCleanButtonIcon);
                    stationFilterIncludeSwitchBox.setValue(false);
                }
            }
        });

        stationInfoShowTextBox.addClickHandler(getInfoShowTextBoxClickHandler(stationPopupPanel));

        ImageWidget helpIcon = buildHelpIcon(getStationFilterHelpIconTip());
        stationChoosePanel.add(createLabel("", WIDTH_10PX, ""));// NOSONAR
        stationChoosePanel.add(helpIcon);

        // page loading, then init station data
        buildStationData(getHeadendIdsWithCommaFormDB(), getFilterTypeKeyFromDB(selectedHeadendMap, HEADEND_KEY),
                selectedStations);
        return stationChoosePanel;
    }

    private HorizontalPanel buildStationPanleWidget() {
        stationFilterIncludeSwitchBox = new CheckBox(EXCLUDE_VALUE_KEY);
        stationFilterIncludeSwitchBox.setValue(EXCLUDE_VALUE_KEY.equals(getFilterTypeKeyFromDB(selectedStationMap,
                STATION_KEY)));
        stationFilterIncludeSwitchBox.setStyleName(STYLE_EXPORTSETTING_SMMAL_TEXT_SIZE);
        stationFilterIncludeSwitchBox.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
            @Override
            public void onValueChange(ValueChangeEvent<Boolean> event) {
                if (stationFilterIncludeSwitchBox.getValue() && stationPopupPanel.getSelectedValue().size() == 0) {
                    showPopupPanel(stationPopupPanel);
                } else if (!stationFilterIncludeSwitchBox.getValue() && stationPopupPanel.getSelectedValue().size() > 0) {
                    List<UIFilterEntity> selectedHeadendFromPanel = headendPopupPanel.getSelectedValue();
                    updateStationPanelTriggerByUpStreamChange(selectedHeadendFromPanel, new ArrayList<String>());
                    selectedStations.clear();
                }
            }
        });

        Label empLabel1 = new Label("");
        empLabel1.setWidth("5px");

        stationInfoShowTextBox = new TextBox();
        decorateInfoShowTextBox(stationInfoShowTextBox);

        Label empLabel2 = new Label("");
        empLabel2.setWidth(WIDTH_10PX);

        HorizontalPanel hp = new HorizontalPanel();
        hp.add(stationFilterIncludeSwitchBox);
        hp.add(empLabel1);
        hp.add(stationInfoShowTextBox);
        hp.add(empLabel2);

        return hp;
    }

    private String getHeadendIdsWithCommaFormDB() {
        String headendListString = "";
        if (!CollectionUtils.isEmpty(selectedHeadends)) {
            headendListString = StringUtils.join(selectedHeadends.toArray(), ",");
        }
        return headendListString;
    }

    private ImageWidget buildCleanIcon(String tip) {
        ImageWidget cleanButtonIcon = new ImageWidget();
        cleanButtonIcon.setUrl("cms_epgmgmt_ui/images/rubber-icon.png");
        cleanButtonIcon.setTitle(tip);
        cleanButtonIcon.setWidth("22px");
        cleanButtonIcon.setHeight("18px");
        return cleanButtonIcon;
    }

    private ImageWidget buildHelpIcon(String tip) {
        ImageWidget cleanButtonIcon = new ImageWidget();
        cleanButtonIcon.setUrl("cms_epgmgmt_ui/images/help.png");
        cleanButtonIcon.setTitle(tip);
        return cleanButtonIcon;
    }

    private void updateHeadendAndStationByProvider(String providerId) {
        headendService.getHeadendsByProviderId(providerId, new NeptuneAsyncCallback<List<UiHeadend>>() {
            @Override
            public void onNeptuneFailure(Throwable caught) {
                Window.alert("get headends by provider id failed!! \n " + caught);
            }

            @Override
            public void onNeptuneSuccess(List<UiHeadend> result) {
                List<String> headendSelectedList = selectedHeadends;
                buildHeadendPanelData(result, headendSelectedList);

                List<UIFilterEntity> selectedHeadendFromPanel = headendPopupPanel.getSelectedValue();
                updateStationPanelTriggerByUpStreamChange(selectedHeadendFromPanel, selectedStations);
            }
        });
    }

    private void updateStationPanelTriggerByUpStreamChange(List<UIFilterEntity> selectedHeadendFromPanel,
            List<String> selectedList) {
        String filterKeyType = getCheckBoxStringValue(headendFilterIncludeSwitchBox);
        buildStationData(convertToStringWithComma(selectedHeadendFromPanel), filterKeyType, selectedList);
    }

    private void buildHeadendPanelData(List<UiHeadend> result, List<String> selectedList) {
        List<UIFilterEntity> dataFromDB = convertToUIObject(result);
        List<UIFilterEntity> selectedFilterEntityList = convertSelectedListToFilterEntityList(dataFromDB, selectedList);
        if (CollectionUtils.isEmpty(selectedFilterEntityList)) {
            headendCleanPanel.remove(headendCleanButtonIcon);
        } else {
            headendCleanPanel.add(headendCleanButtonIcon);
        }

        headendPopupPanel.buildData(dataFromDB, selectedFilterEntityList);
    }


    private String convertToStringWithComma(List<UIFilterEntity> fes) {
        if (CollectionUtils.isEmpty(fes)) {
            return "";
        }
        List<String> ids = new ArrayList<String>();
        for (UIFilterEntity fe : fes) {
            ids.add(fe.getFilterId());
        }
        return StringUtils.join(ids.toArray(), ",");
    }

    private HorizontalPanel buildHeadendRowPanelWidget() {
        headendFilterIncludeSwitchBox = new CheckBox(EXCLUDE_VALUE_KEY);
        headendFilterIncludeSwitchBox.setValue(EXCLUDE_VALUE_KEY.equals(getFilterTypeKeyFromDB(selectedHeadendMap,
                HEADEND_KEY)));
        headendFilterIncludeSwitchBox.setStyleName(STYLE_EXPORTSETTING_SMMAL_TEXT_SIZE);
        headendFilterIncludeSwitchBox.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
            @Override
            public void onValueChange(ValueChangeEvent<Boolean> event) {
                List<UIFilterEntity> selectedHeadendFromPanel = headendPopupPanel.getSelectedValue();
                updateStationPanelTriggerByUpStreamChange(selectedHeadendFromPanel, selectedStations);
                if (headendFilterIncludeSwitchBox.getValue() && headendPopupPanel.getSelectedValue().size() == 0) {
                    showPopupPanel(headendPopupPanel);
                    headendPopupPanel.setSelectedMessageInfoLabel(EXCLUDE_MUST_SELECTED_RECORD_TIP);
                } else if (!headendFilterIncludeSwitchBox.getValue() && headendPopupPanel.getSelectedValue().size() > 0) {
                    buildHeadendData(new ArrayList<String>());
                }
            }
        });

        headendInfoShowTextBox = new TextBox();
        decorateInfoShowTextBox(headendInfoShowTextBox);

        HorizontalPanel hp = new HorizontalPanel();
        hp.add(headendFilterIncludeSwitchBox);
        hp.add(createLabel("", "5px", "20px"));// NOSONAR
        hp.add(headendInfoShowTextBox);
        hp.add(createLabel("", WIDTH_10PX, "20px"));// NOSONAR

        return hp;
    }

    private void decorateInfoShowTextBox(TextBox textBox) {
        textBox.setStyleName(STYLE_INPUT_DOWNLIST);
        textBox.setReadOnly(true);
        textBox.setWidth("130px");// NOSONAR
    }

    private ClickHandler getInfoShowTextBoxClickHandler(final PaginationCheckboxPanel popup) {
        return new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                showPopupPanel(popup);
            }
        };
    }

    private void showPopupPanel(PaginationCheckboxPanel popup) {
        int left = (Window.getClientWidth() - POPUP_PANEL_WIDTH) / 2; // NOSONAR
        int top = (Window.getClientHeight() - POPUP_PANEL_HEIGHT + 100) / 2; // NOSONAR
        popup.setPopupPosition(left, top);
        popup.show();
    }


    public long getProviderFilterValues() {
        return getProviderId();
    }

    private String getCheckBoxStringValue(CheckBox checkBox) {
        if (checkBox.getValue()) {
            return EXCLUDE_VALUE_KEY;
        }
        return INCLUDE_VALUE_KEY;
    }

    /**
     * get filters value, map key is the filter key
     * 
     * @return
     */
    public Map<String, List<String>> getProviderFilterValueMap() {
        Map<String, List<String>> mapListValues = new HashMap<String, List<String>>();
        long providerFilterId = getProviderFilterValues();
        if (providerFilterId > 0) {
            List<String> providers = new ArrayList<String>();
            providers.add(String.valueOf(providerFilterId));
            String key = PROVIDER_KEY + KEY_SPLIT_SYMBOL + INCLUDE_VALUE_KEY;
            mapListValues.put(key, providers);
        }
        return mapListValues;
    }

    /**
     * return export setting values
     * 
     * @return
     */
    public Map<String, Object> getFilterValues() {
        Map<String, Object> mapFilterValues = new HashMap<String, Object>();
        mapFilterValues.putAll(getProviderFilterValueMap());
        mapFilterValues.putAll(getSelectedFilterValuesMap(headendPopupPanel, HEADEND_KEY,
                getCheckBoxStringValue(headendFilterIncludeSwitchBox)));
        mapFilterValues.putAll(getSelectedFilterValuesMap(stationPopupPanel, STATION_KEY,
                getCheckBoxStringValue(stationFilterIncludeSwitchBox)));
        return mapFilterValues;
    }

    public List<String> getHeadendSelectedFilterValuesList() {
        return getSelectedFilterValues(headendPopupPanel);
    }

    public List<String> getStationSelectedFilterValuesList() {
        return getSelectedFilterValues(stationPopupPanel);
    }

    public boolean getHeadendFilterExcludeValue() {
        return headendFilterIncludeSwitchBox.getValue();
    }

    public boolean getStationFilterExcludeValue() {
        return stationFilterIncludeSwitchBox.getValue();
    }

    private Map<String, List<String>> getSelectedFilterValuesMap(PaginationCheckboxPanel panel, String filterKey,
            String filterKeyType) {
        Map<String, List<String>> mapListValues = new HashMap<String, List<String>>();
        List<String> selectedValueList = getSelectedFilterValues(panel);
        if (!CollectionUtils.isEmpty(selectedValueList)) {
            String key = filterKey + KEY_SPLIT_SYMBOL + filterKeyType;
            mapListValues.put(key, selectedValueList);
        }
        return mapListValues;
    }

    private List<String> getSelectedFilterValues(PaginationCheckboxPanel panel) {
        List<UIFilterEntity> fes = panel.getSelectedValue();
        if (fes == null) {
            return null;
        }
        List<String> value = new ArrayList<String>();
        for (UIFilterEntity fe : fes) {
            value.add(fe.getFilterId());
        }
        return value;
    }

    private void buildHeadendData(final List<String> headendSelectedList) {
        String providerId = String.valueOf(getProviderId());
        headendService.getHeadendsByProviderId(providerId, new NeptuneAsyncCallback<List<UiHeadend>>() {
            @Override
            public void onNeptuneFailure(Throwable caught) {
                Window.alert("get headend failed!! \n " + caught);
            }

            @Override
            public void onNeptuneSuccess(List<UiHeadend> result) {
                buildHeadendPanelData(result, headendSelectedList);
            }
        });
    }

    private void buildStationData(String headendIdStrWithComma, String headendFilterTypeKey,
            final List<String> selectedFilterEntityList) {
        String providerId = String.valueOf(getProviderId());
        if (StringUtils.isNotEmpty(headendIdStrWithComma)) {
            String headendListString = buildSQLQuerySubClause(headendIdStrWithComma, headendFilterTypeKey);
            stationService.getStationsByHeadendIds(providerId, headendListString, new NeptuneAsyncCallback<List<UiStation>>() {
                @Override
                public void onNeptuneFailure(Throwable caught) {
                    Window.alert("get station by headend ids failed!! \n " + caught);
                }

                @Override
                public void onNeptuneSuccess(List<UiStation> result) {
                    buildStationPanelData(result, selectedFilterEntityList);
                }
            });
        } else {
            stationService.getStationsByProviderId(providerId, new NeptuneAsyncCallback<List<UiStation>>() {
                @Override
                public void onNeptuneFailure(Throwable caught) {
                    Window.alert("get station by provider id failed!! \n " + caught);
                }

                @Override
                public void onNeptuneSuccess(List<UiStation> result) {
                    buildStationPanelData(result, selectedFilterEntityList);
                }
            });
        }
    }

    private String buildSQLQuerySubClause(String idListStringWithComma, String filterKeyType) {
        return (filterKeyType.equalsIgnoreCase(EXCLUDE_VALUE_KEY) ? " not" : "") + " in (" + idListStringWithComma
                + ")";
    }

    private void buildStationPanelData(List<UiStation> result, List<String> selectedList) {
        List<UIFilterEntity> dataFromDb = convertToUiObjects(result);
        List<UIFilterEntity> selectedFilterEntityList = convertSelectedListToFilterEntityList(dataFromDb, selectedList);
        if (CollectionUtils.isEmpty(selectedFilterEntityList)) {
            stationCleanPanel.remove(stationCleanButtonIcon);
        } else {
            stationCleanPanel.add(stationCleanButtonIcon);
        }
        stationPopupPanel.buildData(dataFromDb, selectedFilterEntityList);
    }

    private String getFilterTypeKeyFromDB(Map<String, List<String>> valuesMap, String filterValueKey) {
        String filterTypeKey = INCLUDE_VALUE_KEY;
        if (valuesMap == null || valuesMap.size() == 0) {
            return filterTypeKey;
        }

        if (valuesMap.containsKey(filterValueKey + KEY_SPLIT_SYMBOL + INCLUDE_VALUE_KEY)) {
            filterTypeKey = INCLUDE_VALUE_KEY;
        } else if (valuesMap.containsKey(filterValueKey + KEY_SPLIT_SYMBOL + EXCLUDE_VALUE_KEY)) {
            filterTypeKey = EXCLUDE_VALUE_KEY;
        }
        return filterTypeKey;
    }

    private List<UIFilterEntity> convertSelectedListToFilterEntityList(List<UIFilterEntity> filterDatas,
            List<String> selectedDatas) {
        if (selectedDatas == null || filterDatas == null) {
            return null;
        }
        List<UIFilterEntity> fes = new ArrayList<UIFilterEntity>();
        for (String id : selectedDatas) {
            /** ignore the data which not exists in origin **/
            UIFilterEntity fe = getFilterEntityById(id, filterDatas);
            if (fe == null) {
                continue;
            }
            fes.add(fe);
        }
        return fes;
    }

    private UIFilterEntity getFilterEntityById(String id, List<UIFilterEntity> filterDatas) {
        UIFilterEntity machFe = null;
        for (UIFilterEntity fe : filterDatas) {
            if (id.equals(fe.getFilterId())) {
                machFe = fe;
                break;
            }
        }
        return machFe;
    }

    public String getFilterTitle() {
        return filterTitle;
    }

    public void setFilterTitle(String filterTitle) {
        this.filterTitle = filterTitle;
    }

    private List<UIFilterEntity> convertToUIObject(List<UiHeadend> dbHeadends) {
        List<UIFilterEntity> fes = new ArrayList<UIFilterEntity>();
        for (UiHeadend he : dbHeadends) {
            UIFilterEntity fe = new UIFilterEntity();
            fe.setFilterId(he.getHeadendId());
            fe.setFilterName(he.getHeadendName());
            fe.setTheSecondaryFilter(he.getZipCode() == null ? "" : he.getZipCode());
            fes.add(fe);
        }

        return fes;
    }

    private List<UIFilterEntity> convertToUiObjects(List<UiStation> dbStations) {
        List<UIFilterEntity> fes = new ArrayList<UIFilterEntity>();
        for (UiStation s : dbStations) {
            UIFilterEntity fe = new UIFilterEntity();
            fe.setFilterId(s.getStationId());
            fe.setFilterName(s.getStationName());
            fe.setTheSecondaryFilter(s.getCity() == null ? "" : s.getCity());
            fes.add(fe);
        }
        return fes;
    }

    private Label createLabel(String text, String width, String height) {
        Label label = new Label(text);
        if (StringUtils.isNotEmpty(width)) {
            label.setWidth(width);
        }
        if (StringUtils.isNotEmpty(height)) {
            label.setHeight(height);
        }
        return label;
    }

    public List<String> validate() {
        return new ArrayList<String>();
    }

    public void populateModel() {
    }

    public Long getProviderId() {
        return this.providerId == null ? -1 : this.providerId;
    }

    public void setProviderId(Long providerId) {
        if (this.providerId != providerId) {
            // cascade by provider changed
            updateHeadendAndStationByProvider(String.valueOf(providerId));
        }
        this.providerId = providerId;
    }

    public String getHeadendFilterHelpIconTip() {
        return headendFilterHelpIconTip;
    }

    public void setHeadendFilterHelpIconTip(String headendFilterHelpIconTip) {
        this.headendFilterHelpIconTip = headendFilterHelpIconTip;
    }

    public String getStationFilterHelpIconTip() {
        return stationFilterHelpIconTip;
    }

    public void setStationFilterHelpIconTip(String stationFilterHelpIconTip) {
        this.stationFilterHelpIconTip = stationFilterHelpIconTip;
    }

}
