package com.ericsson.cms.epgmgmt.client.widget;

import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class ImageButtonBarView implements View<String> {
    private Image[] images;
    private final HorizontalContainer hc;

    /**
     * Align all the image buttons to the center.
     * 
     * @param title
     * @param imageUrls
     * @param visible
     */
    public ImageButtonBarView(String[] title, String[] imageUrls, boolean visible) {
        this(title, imageUrls, visible, HasHorizontalAlignment.ALIGN_CENTER);
    }

    public ImageButtonBarView(String[] title, String[] imageUrls, boolean visible, HorizontalAlignmentConstant alignment) {
        hc = new HorizontalContainer();
        hc.setHorizontalAlignment(alignment);
        hc.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        hc.setSpacing(2);// NOSONAR
        if ((title != null) && (title.length > 0)) {
            images = new ToggleImage[title.length];
            for (int i = 0; i < images.length; i++) {
                images[i] = new ToggleImage(imageUrls[i], title[i]);
                images[i].setVisible(visible);
                images[i].setStyleName("epg-button");
                hc.add(images[i]);
            }
        }
    }

    /**
     * @param title
     * @param imageUrls
     * @param visible
     *            an array denoting if the button is visible. Invisible button will be replaced by a blank 24X24
     *            placeholder
     * @param alignment
     */
    public ImageButtonBarView(String[] title, String[] imageUrls, boolean[] visible,
            HorizontalAlignmentConstant alignment) {
        hc = new HorizontalContainer();
        hc.setWidth("100%");
        hc.setHorizontalAlignment(alignment);
        hc.setSpacing(2);// NOSONAR
        if ((title != null) && (title.length > 0)) {
            images = new ToggleImage[title.length];
            for (int i = 0; i < images.length; i++) {
                if (visible[i]) {
                    images[i] = new ToggleImage(imageUrls[i], title[i]);
                } else {
                    images[i] = new Image("cms_epgmgmt_ui/images/blank.png");
                    images[i].setPixelSize(24, 24);
                }
                images[i].setStyleName("epg-button");
                hc.add(images[i]);
            }
        }
    }

    @Override
    public Widget getWidget() {
        return hc;
    }

    @Override
    public String getStyleName() {
        return null;
    }

    @Override
    public void release() {
        //
    }

    public Image getButton(int index) {
        if ((images != null) && (index < images.length)) {
            return images[index];
        }
        return null;
    }
}
