package com.ericsson.cms.epgmgmt.client.widget;

import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.ViewBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class ImageLabelView extends ViewBase<String>{
    private HorizontalContainer container;
    private Image image;
    private Label label;
    private String labelStr;
    public ImageLabelView(String label ,String title, String imageUrl) {
        super(label);
        this.labelStr = label;
        this.label.setText(labelStr);
        this.image.setUrl(imageUrl);
        this.image.setTitle(title);
    }
    @Override
    public Widget getWidget() {
        return container;
    }

    @Override
    public void release() {

    }

    @Override
    protected String getViewValue() {
        return labelStr;
    }

    @Override
    protected void setViewValue(String value) {
        label.setText(value);
        this.labelStr = value;
    }

    @Override
    protected void preInitialValueSet() {
        container = new HorizontalContainer();
        container.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        image = new Image();
        container.add(image);
        container.setCellHorizontalAlignment(image , HasHorizontalAlignment.ALIGN_CENTER);
        label = new Label();
        container.add(this.label);
        container.setCellHorizontalAlignment(label , HasHorizontalAlignment.ALIGN_CENTER);
        container.setWidth("100%");
        container.setCellVerticalAlignment(label, HasVerticalAlignment.ALIGN_MIDDLE);
    }
}
