package com.ericsson.cms.epgmgmt.client.widget;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.ViewBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.TypedListBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;

public class ListBoxView<T> extends ViewBase<T>{

    private T value;
    private TypedListBoxWidget<T> list;
    private final IValueConverter<T> converter;

    public ListBoxView(T value, IValueConverter<T> converter) {
        super(value);
        this.value = value;
        this.converter = converter;
        list = new TypedListBoxWidget<T>(converter);
        list.setSelectedItem(value);
    }

    @Override
    public Widget getWidget() {
        return list;
    }

    @Override
    public void release() {
    }



    @Override
    protected void preInitialValueSet() {
        list = new TypedListBoxWidget<T>(converter);
        list.setSelectedItem(value);
    }

    @Override
    protected void setViewValue(T value) {
        list.setSelectedItem(value);
        this.value = value;        
    }

    @Override
    protected T getViewValue() {
        return list.getSelectedItem();
    }

}
