package com.ericsson.cms.epgmgmt.client.widget;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;

public class OkCancelButtonPanel extends HorizontalPanel {
    private final EPGComponentConstants constants = GWT.create(EPGComponentConstants.class);

    private final Button okButton;
    private final Button cancelButton;
    
    public OkCancelButtonPanel(ClickHandler okHandler, ClickHandler cancelHandler){
        HorizontalPanel hp = new HorizontalPanel();
        hp.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        okButton = new Button(constants.okLabel());
        okButton.addStyleDependentName("act-towards-save-button");
        okButton.addClickHandler(okHandler);
        hp.add(okButton);
        cancelButton = new Button(constants.buttonLabelCancel());
        cancelButton.addStyleDependentName("dataloss-button");
        cancelButton.addClickHandler(cancelHandler);
        hp.add(cancelButton);
        
        setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        setWidth("100%");
        add(hp);
    }
    
    public void setOkButtonEnable(boolean enable) {
        okButton.setEnabled(enable);
    }
    
    public void setCancelButtonEnable(boolean enable) {
        cancelButton.setEnabled(enable);
    }
}
