package com.ericsson.cms.epgmgmt.client.widget;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentMessages;
import com.ericsson.cms.epgmgmt.client.model.UIFilterEntity;
import com.ericsson.cms.epgmgmt.client.publisher.CheckBoxHeader;
import com.ericsson.cms.epgmgmt.client.publisher.LocalSimplePager;
import com.ericsson.cms.epgmgmt.client.publisher.PaginationDataProvider;
import com.ericsson.cms.epgmgmt.client.publisher.TitleTextCell;
import com.ericsson.cms.epgmgmt.client.utils.CollectionUtils;
import com.ericsson.cms.epgmgmt.client.utils.StringUtils;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style.Unit;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent.ListHandler;
import com.google.gwt.user.cellview.client.RowStyles;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.cellview.client.SimplePager.TextLocation;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasHorizontalAlignment.HorizontalAlignmentConstant;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.DefaultSelectionEventManager;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.RangeChangeEvent;
import com.google.gwt.view.client.SelectionModel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class PaginationCheckboxPanel extends PopupPanel {

    private final BusyIndicator busyIndicator = new BusyIndicator();
    private final EPGComponentMessages constantsMsg = (EPGComponentMessages) GWT.create(EPGComponentMessages.class);

    private List<UIFilterEntity> originalFullDataList;
    private final List<String> columnName;

    /** data from db **/
    @UiField(provided = true)
    private CellTable<UIFilterEntity> filterCellTable;

    /** selected data **/
    @UiField(provided = true)
    private CellTable<UIFilterEntity> selectedCellTable;

    /** the cached selected data before close panel **/
    private final List<UIFilterEntity> lastSelectedDataListCache = new ArrayList<UIFilterEntity>();
    /** the origin filter data before close panel **/
    private final List<UIFilterEntity> lastFilterDataListCache = new ArrayList<UIFilterEntity>();

    private final String primarySearchInputTip;
    private final String secondarySearchInputTip;

    private int DB_FILTER_DATA_SIZE = 0;
    private static final int COLUMN_CHECKBOX_WIDTH = 10;
    private static final int COLUMN_ID_WIDTH = 20;
    private static final int COLUMN_NAME_WIDTH = 45;
    private static final int COLUMN_THE_SEC_FILTER_WIDTH = 26;
    private static final int PAGE_SIZE = 10;
    private static final int FLEX_TABLE_HEIGHT = 255;
    private static final int POPUP_PANEL_WIDTH = 700;
    private static final int POPUP_PANEL_SUB_WIDTH = 325;
    private static final int SEARCH_PANEL_HEADER = 25;
    private static final int MAX_SELECTED_PAGE_SIZE = 100000;
    private static final int MAX_SELECTED_SIZE = 100;

    private final String searchNoResultInfo = constantsMsg.publisherFilterSettingSearchNoResult();
    private final String maxSelectedSizeInfo = constantsMsg.publisherFilterSettingSelectMaxSizeInfo();
    private final String selectedFilterHeaderInfo = constantsMsg.publisherFilterSelectedFiltersHeader();

    private static final String STYLE_SELECTED_TITLE = "epg-msooverridesList-header";
    private static final String STYLE_CELLTABLE = "epg-exportsetting-cellTable";
    private static final String STYLE_CELLTABLE_CELL = "epg-exportsetting-cellTableCell";
    private static final String STYLE_SEARCH_INPUT_TIP = "epg-exportsetting-input-tip";
    private static final String STYLE_LABEL_MESSAGE = "epg-infoMessage";

    private final FlexTable flexTable = new FlexTable();
    private VerticalPanel rightPaginationFilterPanel;
    private ScrollPanel leftSelectedPanel;
    private CheckBoxHeader checkBoxSelectedHeader;
    private CheckBoxHeader checkBoxFilterHeader;
    private ButtonWidget createButton;
    private ButtonWidget cancelButton;

    private final TextBox infoShowTextBox;
    private Label selectedMessageInfoLabel;

    private final PaginationDataProvider filterDataProvider = new PaginationDataProvider();
    private final PaginationDataProvider selectedDataProvider = new PaginationDataProvider();

    public PaginationCheckboxPanel(List<String> columnName, TextBox textBox, String firstTip, String secondTip) {
        super(true);
        this.columnName = columnName;
        this.infoShowTextBox = textBox;
        this.primarySearchInputTip = firstTip;
        this.secondarySearchInputTip = secondTip;
        createPopupPanel();
    }

    public void buildData(List<UIFilterEntity> originalFullDataList, List<UIFilterEntity> selectedDataList) {
        /** remove the selected data from filter data **/
        DB_FILTER_DATA_SIZE = originalFullDataList.size();
        removeTheSelectedListFromOrigFullList(originalFullDataList, selectedDataList);

        if (selectedDataList != null) {
            lastSelectedDataListCache.clear();
            lastSelectedDataListCache.addAll(selectedDataList);
        }
        if (originalFullDataList != null) {
            lastFilterDataListCache.clear();
            lastFilterDataListCache.addAll(originalFullDataList);
        }

        this.originalFullDataList = originalFullDataList;

        filterDataProvider.addData(originalFullDataList, false);
        selectedDataProvider.addData(selectedDataList, false);
        infoShowTextBox.setText(buildSelectedInfoStr(2));// NOSONAR
        selectedMessageInfoLabel.setText(buildSelectedInfoStr(1));// NOSONAR
    }

    private void createPopupPanel() {
        this.setGlassEnabled(true);
        this.setWidth(POPUP_PANEL_WIDTH + "px");
        this.setHeight(POPUP_PANEL_SUB_WIDTH + "px");

        VerticalPanel hPanel = new VerticalPanel();
        hPanel.setHeight("35px");
        hPanel.add(buildMainPanel());
        hPanel.add(buildPanelButton());
        hPanel.add(busyIndicator);
        this.setWidget(hPanel);
    }

    private FlexTable buildMainPanel() {
        leftSelectedPanel = buildLeftSelectedPanel();
        rightPaginationFilterPanel = buildRightPaginationFilterPanel();
        selectedMessageInfoLabel = new Label();
        selectedMessageInfoLabel.setStyleName(STYLE_LABEL_MESSAGE);
        selectedMessageInfoLabel.setWidth(POPUP_PANEL_SUB_WIDTH + "px");
        selectedMessageInfoLabel.setHeight("25px"); // NOSONAR

        FlexTable leftTable = new FlexTable();
        leftTable.setStylePrimaryName("epg-exportsetting-table-border");
        FlexTable rightTable = new FlexTable();
        rightTable.addStyleName("epg-exportsetting-table-border");

        HorizontalPanel selectedFilterHeader = buildSelectedFilterHeader();

        VerticalPanel leftPanel = new VerticalPanel();
        leftPanel.add(selectedFilterHeader);
        leftPanel.add(selectedMessageInfoLabel);
        leftPanel.add(leftSelectedPanel);


        VerticalPanel rightPanel = new VerticalPanel();
        rightPanel.add(buildSearchPanel());
        rightPanel.add(buildPager(filterCellTable));
        rightPanel.add(rightPaginationFilterPanel);

        leftTable.setWidget(1, 0, leftPanel);
        rightTable.setWidget(1, 0, rightPanel);

        /** fist row **/
        flexTable.setWidget(1, 0, leftTable);
        flexTable.setWidget(1, 1, buileMoveDataLabelPanel());
        flexTable.setWidget(1, 2, rightTable);

        return flexTable;
    }

    private HorizontalPanel buildSelectedFilterHeader() {
        Label selectedFilterHeader = new Label(selectedFilterHeaderInfo);
        selectedFilterHeader.setHeight("25px");// NOSONAR

        HorizontalPanel hpanel = new HorizontalPanel();
        hpanel.setWidth("100%");// NOSONAR
        hpanel.add(selectedFilterHeader);
        hpanel.setStyleName(STYLE_SELECTED_TITLE);
        hpanel.setHeight("25px");// NOSONAR
        hpanel.setCellVerticalAlignment(selectedFilterHeader, HasVerticalAlignment.ALIGN_BOTTOM);
        hpanel.setCellHorizontalAlignment(selectedFilterHeader, HasHorizontalAlignment.ALIGN_CENTER);
        return hpanel;
    }

    private void removeDataToLeftPanel(List<UIFilterEntity> fes) {
        // max select size limit
        int selectedSize = selectedDataProvider.getDataProvider().getList().size();
        if (selectedSize + fes.size() > MAX_SELECTED_SIZE) {
            selectedMessageInfoLabel.setText(maxSelectedSizeInfo + " " + MAX_SELECTED_SIZE);
            return;
        }
        selectedDataProvider.addData(fes, true);
        selectedDataProvider.refreshDisplays();

        filterDataProvider.removeData(fes);
        filterDataProvider.refreshDisplays();

        infoShowTextBox.setText(buildSelectedInfoStr(2));

        /** remove data from dataList **/
        removeTheSelectedListFromOrigFullList(originalFullDataList, fes);
        checkBoxFilterHeader.setValue(false, true);
        checkBoxSelectedHeader.setValue(false, true);
        selectedMessageInfoLabel.setText(buildSelectedInfoStr(1));
    }

    private void removeDataToRightPanel(List<UIFilterEntity> fes) {
        flexTable.setWidget(4, 1, busyIndicator); // NOSONAR
        removeFilterPanelSearchNoResult();
        selectedDataProvider.removeData(fes);
        selectedDataProvider.refreshDisplays();

        filterDataProvider.addData(fes, true);
        filterDataProvider.refreshDisplays();

        originalFullDataList.addAll(fes);
        infoShowTextBox.setText(buildSelectedInfoStr(2));
        checkBoxFilterHeader.setValue(false, true);
        checkBoxSelectedHeader.setValue(false, true);
        selectedMessageInfoLabel.setText(buildSelectedInfoStr(1));
    }

    private VerticalPanel buileMoveDataLabelPanel() {
        VerticalPanel moveLablePanel = new VerticalPanel();
        moveLablePanel.setWidth("10px");
        String buttonWidth = "30px";
        String buttonHeight = "19px";

        // create move one page to left button
        Button moveCurrPageToLeftButton = new Button("<<");
        moveCurrPageToLeftButton.setWidth(buttonWidth);
        moveCurrPageToLeftButton.setHeight(buttonHeight);
        moveCurrPageToLeftButton.setTitle("move current page records to left");
        moveCurrPageToLeftButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                List<UIFilterEntity> fes = filterCellTable.getVisibleItems();
                removeDataToLeftPanel(fes);
            }

        });

        // create move selected to left button
        Button moveSelectedToLeftButton = new Button("<");
        moveSelectedToLeftButton.setWidth(buttonWidth);
        moveSelectedToLeftButton.setHeight(buttonHeight);
        moveSelectedToLeftButton.setTitle("move selected records to left");
        moveSelectedToLeftButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                List<UIFilterEntity> fes = getCellTableAllRowCheckedValues(filterCellTable, filterDataProvider);
                removeDataToLeftPanel(fes);
            }
        });

        // create move one page to right button
        Button moveSelectedToRightButton = new Button(">");
        moveSelectedToRightButton.setWidth(buttonWidth);
        moveSelectedToRightButton.setHeight(buttonHeight);
        moveSelectedToRightButton.setTitle("move selected records to right");
        moveSelectedToRightButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                List<UIFilterEntity> fes = getCellTableAllRowCheckedValues(selectedCellTable, selectedDataProvider);
                removeDataToRightPanel(fes);
            }
        });

        // create move one page to right button
        Button moveCurrPageToRightButton = new Button(">>");
        moveCurrPageToRightButton.setWidth(buttonWidth);
        moveCurrPageToRightButton.setHeight(buttonHeight);
        moveCurrPageToRightButton.setTitle("move all selected records to right");
        moveCurrPageToRightButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                List<UIFilterEntity> fes = selectedCellTable.getVisibleItems();
                removeDataToRightPanel(fes);
            }
        });

        FlexTable table = new FlexTable();
        table.setWidget(1, 0, moveCurrPageToLeftButton);
        table.setWidget(3, 0, moveSelectedToLeftButton); // NOSONAR
        table.setWidget(5, 0, createLabel("", "1px", "20px")); // NOSONAR
        table.setWidget(7, 0, moveSelectedToRightButton); // NOSONAR
        table.setWidget(9, 0, moveCurrPageToRightButton); // NOSONAR

        moveLablePanel.add(table);
        return moveLablePanel;
    }

    /**
     * flag = 1 return simple message
     * 
     * @param flag
     * @return
     */
    private String buildSelectedInfoStr(int flag) {
        int selectedSize = selectedDataProvider.getDataProvider().getList().size();
        if (flag == 1) {
            return "Selected " + selectedSize + " records";
        }
        if (selectedSize == 0) {
            return "All";
        }
        return "Selected: " + selectedSize + " of " + DB_FILTER_DATA_SIZE;
    }

    private HorizontalPanel buildPager(CellTable<UIFilterEntity> cellTable) {
        SimplePager.Resources pagerResources = GWT.create(SimplePager.Resources.class);
        LocalSimplePager pager = new LocalSimplePager(TextLocation.CENTER, pagerResources, false, -1, true);
        pager.setDisplay(cellTable);
        pager.setRangeLimited(true);
        pager.setPageSize(PAGE_SIZE);

        Label rowInfoLabel = new Label();
        pager.setRowInfoLabel(rowInfoLabel);

        HorizontalPanel pagerHpanel = new HorizontalPanel();
        pagerHpanel.add(pager);
        pagerHpanel.add(createLabel("", "5px", "1px"));
        pagerHpanel.add(rowInfoLabel);
        pagerHpanel.setCellVerticalAlignment(pager, HasVerticalAlignment.ALIGN_MIDDLE);
        pagerHpanel.setCellVerticalAlignment(createLabel("", "5px", "1px"), HasVerticalAlignment.ALIGN_MIDDLE);
        pagerHpanel.setCellVerticalAlignment(rowInfoLabel, HasVerticalAlignment.ALIGN_MIDDLE);
        pagerHpanel.setHeight("25px");

        return pagerHpanel;
    }

    /**
     * create a selected panel
     */
    private ScrollPanel buildLeftSelectedPanel() {
        selectedCellTable = new CellTable<UIFilterEntity>(UIFilterEntity.KEY_PROVIDER);
        selectedCellTable.setWidth("100%", true);
        selectedCellTable.setPageSize(MAX_SELECTED_PAGE_SIZE);

        final SelectionModel<UIFilterEntity> selectionModel = new MultiSelectionModel<UIFilterEntity>(
                UIFilterEntity.KEY_PROVIDER);

        selectedCellTable.setSelectionModel(selectionModel,
                DefaultSelectionEventManager.<UIFilterEntity> createCheckboxManager());
        checkBoxSelectedHeader = new CheckBoxHeader(false);
        initTableColumns(selectedCellTable, selectionModel, selectedDataProvider, checkBoxSelectedHeader);

        selectedDataProvider.addDataDisplay(selectedCellTable);

        ScrollPanel scrollPanel = new ScrollPanel();
        scrollPanel.add(selectedCellTable);
        scrollPanel.setHeight(FLEX_TABLE_HEIGHT + "px");
        scrollPanel.setWidth(POPUP_PANEL_SUB_WIDTH + "px");

        return scrollPanel;
    }

    /**
     * create a pagination panel
     */
    private VerticalPanel buildRightPaginationFilterPanel() {
        filterCellTable = new CellTable<UIFilterEntity>(UIFilterEntity.KEY_PROVIDER);
        filterCellTable.setWidth("100%", true);

        final SelectionModel<UIFilterEntity> selectionModel = new MultiSelectionModel<UIFilterEntity>(
                UIFilterEntity.KEY_PROVIDER);
        filterCellTable.setSelectionModel(selectionModel,
                DefaultSelectionEventManager.<UIFilterEntity> createCheckboxManager());
        checkBoxFilterHeader = new CheckBoxHeader(false);
        initTableColumns(filterCellTable, selectionModel, filterDataProvider, checkBoxFilterHeader);

        filterDataProvider.addDataDisplay(filterCellTable);
        filterCellTable.addRangeChangeHandler(new RangeChangeEvent.Handler() {
            @SuppressWarnings("unchecked")
            @Override
            public void onRangeChange(RangeChangeEvent event) {
                int checkedNum = 0;
                List<UIFilterEntity> visibList = filterCellTable.getVisibleItems();
                for (UIFilterEntity fe : visibList) {
                    Column<UIFilterEntity, Boolean> column = (Column<UIFilterEntity, Boolean>) filterCellTable
                            .getColumn(0);
                    if (column.getValue(fe)) {
                        checkedNum++;
                    }
                }
                checkBoxFilterHeader.setValue(false);
                if (checkedNum == PAGE_SIZE) {
                    checkBoxFilterHeader.setValue(true);
                }
            }
        });

        VerticalPanel vPanel = new VerticalPanel();
        vPanel.add(filterCellTable);

        vPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_TOP);
        vPanel.setHeight(FLEX_TABLE_HEIGHT + "px");
        vPanel.setWidth(POPUP_PANEL_SUB_WIDTH + "px");
        return vPanel;
    }

    /**
     * Add the columns to the table.
     */
    private void initTableColumns(final CellTable<UIFilterEntity> cellTable,
            final SelectionModel<UIFilterEntity> selectionModel, final PaginationDataProvider dataProvider,
            CheckBoxHeader checkBoxHeader) {

        setCellTableStyle(cellTable);

        /******************* checkBox *********************/
        addValueChangeHandler(cellTable, selectionModel, checkBoxHeader);
        final Column<UIFilterEntity, Boolean> checkBoxColumn = generateCheckBoxColumn(selectionModel);
        cellTable.addColumn(checkBoxColumn, checkBoxHeader);
        cellTable.setColumnWidth(checkBoxColumn, COLUMN_CHECKBOX_WIDTH, Unit.PX);

        /******************* FilterId *********************/
        Column<UIFilterEntity, String> filterIdColumn = generateFilterIdColumn();

        filterIdColumn.setHorizontalAlignment(HasAlignment.ALIGN_LEFT);
        filterIdColumn.setSortable(true);

        ListHandler<UIFilterEntity> idSortHandler = buildIdSortHandler(dataProvider, filterIdColumn);
        cellTable.addColumnSortHandler(idSortHandler);
        cellTable.addColumn(filterIdColumn, columnName.get(0));
        cellTable.setColumnWidth(filterIdColumn, COLUMN_ID_WIDTH, Unit.PX);

        /******************* FilterName *********************/
        Column<UIFilterEntity, String> filterNameColumn = generateFilterNameColumn();
        filterNameColumn.setHorizontalAlignment(HasAlignment.ALIGN_LEFT);
        filterNameColumn.setSortable(true);

        ListHandler<UIFilterEntity> nameSortHandler = buildNameSortHandler(dataProvider, filterNameColumn);
        cellTable.addColumnSortHandler(nameSortHandler);
        cellTable.addColumn(filterNameColumn, columnName.get(1));
        cellTable.setColumnWidth(filterNameColumn, COLUMN_NAME_WIDTH, Unit.PX);

        /******************* theSecondaryFilter *********************/
        Column<UIFilterEntity, String> theSecondaryFilterColumn = generateSecondaryFilterColumn();
        theSecondaryFilterColumn.setHorizontalAlignment(HasAlignment.ALIGN_LEFT);
        theSecondaryFilterColumn.setSortable(true);

        ListHandler<UIFilterEntity> theSecondaryFilterSortHandler = buildSecondaryFilterSortHandler(dataProvider, theSecondaryFilterColumn);
        cellTable.addColumnSortHandler(theSecondaryFilterSortHandler);
        cellTable.addColumn(theSecondaryFilterColumn, columnName.get(2));
        cellTable.setColumnWidth(theSecondaryFilterColumn, COLUMN_THE_SEC_FILTER_WIDTH, Unit.PX);

        /** add the default sort column **/
        cellTable.getColumnSortList().push(filterIdColumn);
    }

    private HorizontalContainer buildPanelButton() {
        HorizontalContainer hPanel = new HorizontalContainer();
        hPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        hPanel.setWidth("100%");

        HorizontalContainer hc = new HorizontalContainer();
        createButton = new ButtonWidget(" OK ");
        createButton.setWidth("65px");
        createButton.addStyleDependentName("act-towards-save-button");
        createButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                lastSelectedDataListCache.clear();
                lastSelectedDataListCache.addAll(PaginationCheckboxPanel.this.selectedDataProvider.getDataProvider()
                        .getList());
                lastFilterDataListCache.clear();
                lastFilterDataListCache.addAll(PaginationCheckboxPanel.this.filterDataProvider.getDataProvider()
                        .getList());
                PaginationCheckboxPanel.this.hide();
            }
        });
        hc.add(createButton);

        cancelButton = new ButtonWidget("Cancel");
        cancelButton.setWidth("65px");
        cancelButton.addStyleDependentName("dataloss-button");
        cancelButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                selectedDataProvider.addData(lastSelectedDataListCache, false);
                filterDataProvider.addData(lastFilterDataListCache, false);
                selectedDataProvider.getDataProvider().refresh();
                filterDataProvider.getDataProvider().refresh();

                infoShowTextBox.setText(buildSelectedInfoStr(2));// NOSONAR
                selectedMessageInfoLabel.setText(buildSelectedInfoStr(1));// NOSONAR
                PaginationCheckboxPanel.this.hide();
            }
        });
        hc.add(cancelButton);
        hPanel.add(hc);
        return hPanel;
    }

    private ListHandler<UIFilterEntity> buildSecondaryFilterSortHandler(final PaginationDataProvider dataProvider,
            Column<UIFilterEntity, String> cityNameColumn) {
        ListHandler<UIFilterEntity> theSecondaryFilterSortHandler = new ListHandler<UIFilterEntity>(dataProvider
                .getDataProvider().getList());
        theSecondaryFilterSortHandler.setComparator(cityNameColumn, new Comparator<UIFilterEntity>() {
            @Override
            public int compare(UIFilterEntity o1, UIFilterEntity o2) {
                return o1.getTheSecondaryFilter().compareTo(o2.getTheSecondaryFilter());
            }
        });
        return theSecondaryFilterSortHandler;
    }

    private Column<UIFilterEntity, String> generateSecondaryFilterColumn() {
        return new Column<UIFilterEntity, String>(new TitleTextCell()) {
            @Override
            public String getValue(UIFilterEntity object) {
                return object.getTheSecondaryFilter();
            }
        };
    }

    private ListHandler<UIFilterEntity> buildNameSortHandler(final PaginationDataProvider dataProvider,
            Column<UIFilterEntity, String> filterNameColumn) {
        ListHandler<UIFilterEntity> nameSortHandler = new ListHandler<UIFilterEntity>(dataProvider.getDataProvider()
                .getList());
        nameSortHandler.setComparator(filterNameColumn, new Comparator<UIFilterEntity>() {
            @Override
            public int compare(UIFilterEntity o1, UIFilterEntity o2) {
                return o1.getFilterName().compareTo(o2.getFilterName());
            }
        });
        return nameSortHandler;
    }

    private Column<UIFilterEntity, String> generateFilterNameColumn() {
        return new Column<UIFilterEntity, String>(new TitleTextCell()) {
            @Override
            public String getValue(UIFilterEntity object) {
                return object.getFilterName();
            }
        };
    }

    private ListHandler<UIFilterEntity> buildIdSortHandler(final PaginationDataProvider dataProvider,
            Column<UIFilterEntity, String> filterIdColumn) {
        ListHandler<UIFilterEntity> idSortHandler = new ListHandler<UIFilterEntity>(dataProvider.getDataProvider()
                .getList());

        idSortHandler.setComparator(filterIdColumn, new Comparator<UIFilterEntity>() {
            @Override
            public int compare(UIFilterEntity o1, UIFilterEntity o2) {
                return Integer.parseInt(o1.getFilterId()) - Integer.parseInt(o2.getFilterId());
            }
        });
        return idSortHandler;
    }

    private Column<UIFilterEntity, String> generateFilterIdColumn() {
        return new Column<UIFilterEntity, String>(new TextCell()) {
            @Override
            public String getValue(UIFilterEntity object) {
                return object.getFilterId();
            }
        };
    }

    private void addValueChangeHandler(final CellTable<UIFilterEntity> cellTable,
            final SelectionModel<UIFilterEntity> selectionModel, CheckBoxHeader checkBoxHeader) {
        checkBoxHeader.addValueChangeHandler(new ValueChangeHandler<Boolean>() {
            @Override
            public void onValueChange(ValueChangeEvent<Boolean> event) {
                List<UIFilterEntity> rowItems = cellTable.getVisibleItems();
                for (UIFilterEntity fe : rowItems) {
                    selectionModel.setSelected(fe, event.getValue());
                }
            }
        });
    }

    private Column<UIFilterEntity, Boolean> generateCheckBoxColumn(final SelectionModel<UIFilterEntity> selectionModel) {
        return new Column<UIFilterEntity, Boolean>(new CheckboxCell(
                true, false)) {
            @Override
            public Boolean getValue(UIFilterEntity object) {
                return selectionModel.isSelected(object);
            }
        };
    }

    private void setCellTableStyle(final CellTable<UIFilterEntity> cellTable) {
        cellTable.setRowStyles(getRowStyles());
        cellTable.setStyleName(STYLE_CELLTABLE);
    }

    private RowStyles<UIFilterEntity> getRowStyles() {
        RowStyles<UIFilterEntity> rowStyle = new RowStyles<UIFilterEntity>() {
            @Override
            public String getStyleNames(UIFilterEntity row, int rowIndex) {
                return STYLE_CELLTABLE_CELL;
            }
        };
        return rowStyle;
    }

    private HorizontalPanel buildSearchPanel() {
        final TextBox primarySearchBox = buildSearchBox(this.primarySearchInputTip, "120px");
        primarySearchBox.setTitle(this.primarySearchInputTip);
        final TextBox secondarySearchBox = buildSearchBox(this.secondarySearchInputTip, "120px");
        secondarySearchBox.setTitle(this.secondarySearchInputTip);

        primarySearchBox.addKeyPressHandler(buildKeyPressHandler(primarySearchBox, secondarySearchBox));
        secondarySearchBox.addKeyPressHandler(buildKeyPressHandler(primarySearchBox, secondarySearchBox));

        ImageWidget searchButton = buildSearchIcon("");
        searchButton.setHeight("20px");
        searchButton.addClickHandler(new ClickHandler() {
            @Override
            public void onClick(ClickEvent event) {
                searchHandle(primarySearchBox.getValue(), secondarySearchBox.getValue());
            }
        });

        HorizontalPanel searchPanel = new HorizontalPanel();
        searchPanel.setHeight(SEARCH_PANEL_HEADER + "px");

        searchPanel.add(primarySearchBox);
        searchPanel.add(createLabel("", "10px", "1px"));
        searchPanel.add(secondarySearchBox);
        searchPanel.add(createLabel("", "10px", "1px"));
        searchPanel.add(searchButton);

        searchPanel.setHeight(SEARCH_PANEL_HEADER + "px");
        return searchPanel;
    }

    private KeyPressHandler buildKeyPressHandler(final TextBox primarySearchBox, final TextBox secondarySearchBox) {
        return new KeyPressHandler() {
            @Override
            public void onKeyPress(KeyPressEvent event) {
                if (event.getNativeEvent().getKeyCode() == KeyCodes.KEY_ENTER) {
                    searchHandle(primarySearchBox.getValue(), secondarySearchBox.getValue());
                }
            }
        };
    }

    private TextBox buildSearchBox(final String searchInputTip, String width) {
        final TextBox searchTextBox = new TextBox();
        searchTextBox.setWidth(width);

        searchTextBox.setValue(searchInputTip);
        searchTextBox.setFocus(true);
        searchTextBox.setStyleName(STYLE_SEARCH_INPUT_TIP);

        searchTextBox.addKeyDownHandler(new KeyDownHandler() {
            @Override
            public void onKeyDown(KeyDownEvent event) {
                searchTextBox.setStyleName("");
                if (searchInputTip.equals(searchTextBox.getValue())) {
                    searchTextBox.setValue("");
                }
            }
        });
        searchTextBox.addMouseDownHandler(new MouseDownHandler() {
            @Override
            public void onMouseDown(MouseDownEvent event) {
                if (searchInputTip.equals(searchTextBox.getValue())) {
                    searchTextBox.setValue("");
                }
            }
        });
        searchTextBox.addBlurHandler(new BlurHandler() {
            @Override
            public void onBlur(BlurEvent event) {
                if ("".equals(searchTextBox.getValue())) {
                    searchTextBox.setValue(searchInputTip);
                    searchTextBox.setStyleName(STYLE_SEARCH_INPUT_TIP);
                }
            }
        });
        return searchTextBox;
    }

    private void searchHandle(String primarySearchFilter, String secondarySearchFilter) {
        removeFilterPanelSearchNoResult();
        if (this.primarySearchInputTip.equals(primarySearchFilter)) {
            primarySearchFilter = "";// NOSONAR
        }

        if (this.secondarySearchInputTip.equals(secondarySearchFilter)) {
            secondarySearchFilter = "";// NOSONAR
        }

        if (StringUtils.isEmpty(StringUtils.trim(primarySearchFilter))
                && StringUtils.isEmpty(StringUtils.trim(secondarySearchFilter))) {
            filterDataProvider.addData(originalFullDataList, false);
            if (originalFullDataList.size() == 0) {
                addFilterPanelSearchNoResult();
            }
        } else {
            filterDataProvider.addData(originalFullDataList, false);
            List<UIFilterEntity> searhDatas = filterDataProvider.searchByIdOrName(primarySearchFilter,
                    secondarySearchFilter);
            if (searhDatas != null && searhDatas.size() > 0) {
                filterDataProvider.addData(searhDatas, false);
            } else {
                filterDataProvider.getDataProvider().getList().clear();
                addFilterPanelSearchNoResult();
            }
        }
        filterDataProvider.refreshDisplays();
    }

    private ImageWidget buildSearchIcon(String tip) {
        ImageWidget searchButtonIcon = new ImageWidget();
        searchButtonIcon.setUrl("cms_epgmgmt_ui/images/search-icon.png");
        searchButtonIcon.setTitle(tip);
        return searchButtonIcon;
    }

    public void addFilterPanelSearchNoResult() {
        Label noMsg = new Label(searchNoResultInfo);
        VerticalPanel vp = new VerticalPanel();
        vp.setTitle(searchNoResultInfo);
        vp.setHeight(FLEX_TABLE_HEIGHT - 25 + "px");// NOSONAR
        vp.add(noMsg);
        vp.add(createLabel("", FLEX_TABLE_HEIGHT - 50 + "px", "1px"));// NOSONAR
        vp.setCellHorizontalAlignment(noMsg, HorizontalAlignmentConstant.startOf(HasDirection.Direction.DEFAULT));
        vp.setCellVerticalAlignment(noMsg, HasVerticalAlignment.ALIGN_TOP);
        rightPaginationFilterPanel.add(vp);
    }

    private void removeFilterPanelSearchNoResult() {
        for (int i = 0; i < rightPaginationFilterPanel.getWidgetCount(); i++) {
            Widget w = rightPaginationFilterPanel.getWidget(i);
            if (searchNoResultInfo.equals(w.getTitle())) {
                rightPaginationFilterPanel.remove(i);
            }
        }
    }

    /**
     * get the checked values in all rows
     * 
     * @param cellTable
     * @return
     */
    @SuppressWarnings("unchecked")
    private List<UIFilterEntity> getCellTableAllRowCheckedValues(CellTable<UIFilterEntity> cellTable,
            PaginationDataProvider dataProvider) {

        List<UIFilterEntity> fes = new ArrayList<UIFilterEntity>();
        List<UIFilterEntity> rowItems = dataProvider.getDataProvider().getList();
        for (UIFilterEntity fe : rowItems) {
            Column<UIFilterEntity, Boolean> column = (Column<UIFilterEntity, Boolean>) cellTable.getColumn(0);
            if (column.getValue(fe)) {
                fes.add(fe);
            }
        }

        return fes;
    }

    /**
     * get selected UIFilterEntity List
     * 
     * @return
     */
    public List<UIFilterEntity> getSelectedValue() {
        return this.selectedDataProvider.getDataProvider().getList();
    }

    public List<String> getSelectedValueIdList() {
        List<UIFilterEntity> selectDatas = this.selectedDataProvider.getDataProvider().getList();
        List<String> ids = new ArrayList<String>();
        if (CollectionUtils.isEmpty(selectDatas)) {
            return ids;
        }
        for (UIFilterEntity fe : selectDatas) {
            ids.add(fe.getFilterId());
        }
        return ids;
    }

    private List<UIFilterEntity> removeTheSelectedListFromOrigFullList(List<UIFilterEntity> originList, List<UIFilterEntity> removeList) {
        if (originList == null || removeList == null) {
            return null;
        }
        /** make sure the id not contains double comma **/
        String removeIdString = dataIdToStrJoinComma(removeList);
        Iterator<UIFilterEntity> it = originList.iterator();
        while (it.hasNext()) {
            if (removeIdString.contains("," + it.next().getFilterId() + ",")) {
                it.remove();
            }
        }
        return originList;
    }

    private String dataIdToStrJoinComma(List<UIFilterEntity> dataList) {
        StringBuffer sb = new StringBuffer();
        for (UIFilterEntity fe : dataList) {
            sb.append(",").append(fe.getFilterId()).append(",");
        }
        return sb.toString();
    }

    public List<String> getLastSelectedDataIDListCache() {
        if (CollectionUtils.isEmpty(lastSelectedDataListCache)) {
            return null;
        }
        List<String> ids = new ArrayList<String>(lastSelectedDataListCache.size());
        for (UIFilterEntity fe : lastSelectedDataListCache) {
            ids.add(fe.getFilterId());
        }
        return ids;
    }

    private Label createLabel(String text, String width, String height) {
        Label label = new Label(text);
        if (StringUtils.isNotEmpty(width)) {
            label.setWidth(width);
        }
        if (StringUtils.isNotEmpty(height)) {
            label.setHeight(height);
        }
        return label;
    }

    public List<UIFilterEntity> getLastSelectedDataListCache() {
        return lastSelectedDataListCache;
    }


    public List<UIFilterEntity> getLastFilterDataListCache() {
        return lastFilterDataListCache;
    }

    public void setSelectedMessageInfoLabel(String info) {
        selectedMessageInfoLabel.setText(info);
    }

}
