package com.ericsson.cms.epgmgmt.client.widget;

import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.ProgressBar;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.ViewBase;

public class ProgressBarView extends ViewBase<Float> {

    private ProgressBar progressBar;

    public ProgressBarView(final Float value) {
        super(value);
    }

    @Override
    public Widget getWidget() {
        return progressBar;
    }

    @Override
    public void release() {
        //
    }

    @Override
    protected Float getViewValue() {
        return progressBar.getValue();
    }

    @Override
    protected void setViewValue(Float value) {
        progressBar.setValue(value);
        progressBar.setText(value*100+"%");
    }

    @Override
    protected void preInitialValueSet() {
        progressBar = new ProgressBar();
        progressBar.setValue(0);
        progressBar.setWidth("200px");
    }
}
