package com.ericsson.cms.epgmgmt.client.widget;

import com.ericsson.cms.epgmgmt.client.i18n.EPGComponentConstants;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.i18n.client.NumberFormat;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;


public class TimePickerPopupPanel extends PopupPanel {
    private final EPGComponentConstants constants = GWT.create(EPGComponentConstants.class);
    
    private static final String STYLE_INPUT_DOWNLIST = "epg-input-bg";
    private static final String STYLE_DEFAULT = " epg-timer-picker-default";
    private static final String STYLE_ACTIVE = " epg-timer-picker-active";
    private static final String STYLE_HOVER = " epg-timer-picker-hover";
    private static final String STYLE_TEXT_TITLE = "epg-timer-picker-title";
    public static final String TIME_SPERATOR = ":";
    private static final int HOUR_STEP = 1;
    private static final int MINUTE_STEP = 5;
    private static final int TABLE_ROW_COUNT = 4;
    private static final int TABLE_HOUR_COLUMN_COUNT = 6;
    private static final int TABLE_MINUTE_COLUMN_COUNT = 3;
    private static final NumberFormat TIME_FORMAT = NumberFormat.getFormat("00");
    private FlexTable hourTable = new FlexTable();
    private FlexTable minuteTable = new FlexTable();

    private MouseOverHandler labelMouseOverHandler;
    private MouseOutHandler labelMouseOutHandler;
    private ClickHandler hourLabelClickHandler;
    private ClickHandler minuteLabelClickHandler;
    private ClickHandler okClickHandler;
    private ClickHandler cancelClickHandler;
    private ClickHandler textBoxClickHandler;
    private TextBox textBox;
    private LabelWidget selectedHourLabel;
    private LabelWidget selectedMinuteLabel;
    private OkCancelButtonPanel okCancel;

    public TimePickerPopupPanel(final long selectedHour, final long selectedMinute) {        
        initEventHandler();
        initTextBox(selectedHour, selectedMinute);

        selectedHourLabel = initTable(hourTable, hourLabelClickHandler, TABLE_ROW_COUNT, TABLE_HOUR_COLUMN_COUNT, HOUR_STEP, (int)selectedHour);
        selectedHourLabel = initTable(hourTable, hourLabelClickHandler, TABLE_ROW_COUNT, TABLE_HOUR_COLUMN_COUNT, HOUR_STEP, (int)selectedHour);
        selectedMinuteLabel = initTable(minuteTable, minuteLabelClickHandler, TABLE_ROW_COUNT, TABLE_MINUTE_COLUMN_COUNT, MINUTE_STEP, (int)selectedMinute);

        okCancel = new OkCancelButtonPanel(okClickHandler, cancelClickHandler);
        
        VerticalContainer hourVerticalContaniner = createHourVerticalContainer();
        VerticalContainer minuteVerticalContaniner = createMinuteVerticalContainer();
        
        HorizontalContainer horizonContainer  = new HorizontalContainer();
        horizonContainer.setSpacing(6); //NOSONAR
        horizonContainer.add(hourVerticalContaniner);
        horizonContainer.add(minuteVerticalContaniner);
        

        VerticalContainer outerVerticalContaniner = new VerticalContainer();
        outerVerticalContaniner.add(horizonContainer);
        outerVerticalContaniner.add(okCancel);
        
        refreshOKCancelButtonPanel();

        setWidget(outerVerticalContaniner);
        setAutoHideEnabled(true);
    }

    private void initTextBox(final long selectedHour, final long selectedMinute) {
        textBox = new TextBox();
        textBox.addClickHandler(textBoxClickHandler);
        textBox.setWidth("60px");
        if (selectedHour != -1L && selectedMinute != -1L) {
            String time = TIME_FORMAT.format(selectedHour) + ":" + TIME_FORMAT.format(selectedMinute);
            textBox.setText(time);
        }

        textBox.setStyleName(STYLE_INPUT_DOWNLIST);
        textBox.setReadOnly(true);
    }
    


    private void refreshSelectedValue() {
        
        int selectedMinute = -1;
        int selectedHour = -1;
        
        String value = textBox.getText();
        if (value != null && value.contains(TIME_SPERATOR)) {
            String[] times = value.split(TIME_SPERATOR);
            try {
                selectedHour = (int) Long.parseLong(times[0]);
            } catch (NumberFormatException ex) {
                
            }
            if (times.length >= 2) {
                try {
                    selectedMinute = (int) Long.parseLong(times[1]);
                } catch (NumberFormatException ex) {
                    
                }
            }
        }
        
        refreshHour(selectedHour);

        refreshMinute(selectedMinute);
        
        refreshOKCancelButtonPanel();
    }

    private void refreshHour(int selectedHour) {
        if (selectedHourLabel != null) {
            selectedHourLabel.setStyleName(STYLE_DEFAULT);
        }
        
        if (selectedHour != -1L && (selectedHour % HOUR_STEP == 0)) {
            int steppedHour = selectedHour / HOUR_STEP; 
            int row = steppedHour / TABLE_HOUR_COLUMN_COUNT;
            int column = steppedHour % TABLE_HOUR_COLUMN_COUNT;
            if (row <= TABLE_ROW_COUNT && column <= TABLE_HOUR_COLUMN_COUNT) {
                selectedHourLabel = (LabelWidget) hourTable.getWidget(row, column);
                selectedHourLabel.setStyleName(STYLE_ACTIVE);
            }
        } else {
            selectedHourLabel = null;
        }
    }

    private void refreshMinute(int selectedMinute) {
        if (selectedMinuteLabel != null) {
            selectedMinuteLabel.setStyleName(STYLE_DEFAULT);
        }
        
        if (selectedMinute != -1L && (selectedMinute % MINUTE_STEP == 0)) {
            int steppedMinute = selectedMinute / MINUTE_STEP; 
            int row = steppedMinute / TABLE_MINUTE_COLUMN_COUNT;
            int column = steppedMinute % TABLE_MINUTE_COLUMN_COUNT;
            if (row <= TABLE_ROW_COUNT && column <= TABLE_MINUTE_COLUMN_COUNT) {
                selectedMinuteLabel = (LabelWidget) minuteTable.getWidget(row, column);
                selectedMinuteLabel.setStyleName(STYLE_ACTIVE);
            }
        } else {
            selectedMinuteLabel = null;
        }
    }

    private void refreshOKCancelButtonPanel() {
        okCancel.setOkButtonEnable(selectedHourLabel != null && selectedMinuteLabel != null);
    }

    private VerticalContainer createMinuteVerticalContainer() {
        VerticalContainer minuteVerticalContaniner = new VerticalContainer();
        minuteVerticalContaniner.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        minuteVerticalContaniner.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        LabelWidget minuteTitle = new LabelWidget(constants.minutes());
        minuteTitle.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        minuteTitle.setStyleName(STYLE_TEXT_TITLE);
        minuteVerticalContaniner.add(minuteTitle);
        minuteVerticalContaniner.add(minuteTable);
        return minuteVerticalContaniner;
    }

    private VerticalContainer createHourVerticalContainer() {
        LabelWidget hourTitle = new LabelWidget(constants.hours());
        hourTitle.setStyleName(STYLE_TEXT_TITLE);
        hourTitle.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);

        VerticalContainer hourVerticalContaniner = new VerticalContainer();
        hourVerticalContaniner.add(hourTitle);
        hourVerticalContaniner.add(hourTable);
        return hourVerticalContaniner;
    }
    
    private LabelWidget initTable(FlexTable table, ClickHandler labelClickHandler, int rowCount, int columnCount, int stepValue, int selectedValue) {

        LabelWidget selectedLabelWidget = null;
        int value = 0;
        for (int row = 0; row < rowCount; row++) {
            for (int column = 0; column < columnCount; column++) {
                LabelWidget label = new LabelWidget(TIME_FORMAT.format(value));
                if (selectedValue == value) {
                    selectedLabelWidget = label;
                }
                
                label.setStyleName(STYLE_DEFAULT);
                label.addMouseOverHandler(labelMouseOverHandler);
                label.addMouseOutHandler(labelMouseOutHandler);
                label.addClickHandler(labelClickHandler);
                label.setHeight("18px");
                label.setWidth("24px");
                label.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
                table.setWidget(row, column, label);
                
                value += stepValue;
            }
        }
        
        return selectedLabelWidget;
    }

    private void initEventHandler() {
        labelMouseOverHandler = new MouseOverHandler() {
            
            @Override
            public void onMouseOver(MouseOverEvent event) {
                Widget source = (Widget) event.getSource();
                String origStyleName = source.getStyleName();
                source.setStyleName(STYLE_HOVER);
                if (origStyleName.contains(STYLE_ACTIVE)) {
                    source.setStyleName(STYLE_HOVER + STYLE_ACTIVE);
                }
            }
        };
        
        labelMouseOutHandler = new MouseOutHandler() {
            
            @Override
            public void onMouseOut(MouseOutEvent event) {
                Widget source = (Widget) event.getSource();
                String origStyleName = source.getStyleName();
                source.setStyleName(STYLE_DEFAULT);
                if (origStyleName.contains(STYLE_ACTIVE)) {
                    source.setStyleName(STYLE_DEFAULT + STYLE_ACTIVE);
                }
            }
        };
        
        hourLabelClickHandler = new ClickHandler() {
            
            @Override
            public void onClick(ClickEvent event) {
                if (selectedHourLabel != null) {
                    selectedHourLabel.setStyleName(STYLE_DEFAULT);
                }
                LabelWidget label = (LabelWidget) event.getSource();
                label.setStyleName(STYLE_ACTIVE);
                selectedHourLabel = label;
                refreshOKCancelButtonPanel();
            }
        };
        
        minuteLabelClickHandler = new ClickHandler() {
            
            @Override
            public void onClick(ClickEvent event) {
                if (selectedMinuteLabel != null) {
                    selectedMinuteLabel.setStyleName(STYLE_DEFAULT);
                }
                LabelWidget label = (LabelWidget) event.getSource();
                label.setStyleName(STYLE_ACTIVE);
                selectedMinuteLabel = label;
                refreshOKCancelButtonPanel();
            }
        };
        
        okClickHandler = new ClickHandler() {
            
            @Override
            public void onClick(ClickEvent event) {
                textBox.setText(selectedHourLabel.getText() + TIME_SPERATOR + selectedMinuteLabel.getText());
                hide();
            }
        };
        
        cancelClickHandler = new ClickHandler() {
            
            @Override
            public void onClick(ClickEvent event) {
                hide();
            }
        };
        
        textBoxClickHandler = new ClickHandler() {
            
            @Override
            public void onClick(ClickEvent event) {
                refreshSelectedValue();
                showRelativeTo(textBox);
            }
        };
    }

    public TextBox getTextBox() {
        return textBox;
    }    
}
