package com.ericsson.cms.epgmgmt.client.widget;

import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.user.client.ui.Image;

public class ToggleImage<T> extends Image {
    private T attached;
    public T getAttached() {
        return attached;
    }
    public void setAttached(T attached) {
        this.attached = attached;
    }
    public ToggleImage(String url, String title){
        super(url);
        setTitle(title);
        MouseHandler handler = new MouseHandler();
        addMouseOutHandler(handler);
        addMouseOverHandler(handler);
        addMouseUpHandler(handler);
        addMouseDownHandler(handler);
    }
    class MouseHandler implements MouseDownHandler, MouseUpHandler, MouseOverHandler, MouseOutHandler{

        @Override
        public void onMouseOut(MouseOutEvent event) {
            changeCommonImage((Image)event.getSource());
        }

        @Override
        public void onMouseOver(MouseOverEvent event) {
            changeToHoverImage((Image)event.getSource());
        }

        @Override
        public void onMouseUp(MouseUpEvent event) {
            changeToHoverImage((Image)event.getSource());            
        }

        @Override
        public void onMouseDown(MouseDownEvent event) {
            changeCommonImage((Image)event.getSource());            
        }
        private void changeToHoverImage(Image image){
            String url = image.getUrl();
            if(!url.endsWith("_hover.png")){
                image.setUrl(url.substring(0, url.length()-4)+"_hover.png");
            }
        }
        private void changeCommonImage(Image image){
            String url = image.getUrl();
            if(url.endsWith("_hover.png")){
                image.setUrl(url.substring(0, url.length()-10)+".png");   
            }
        }
    }
}
