package com.ericsson.cms.me.client;


import java.util.ArrayList;
import java.util.List;

import com.ericsson.cms.me.client.i18n.MEConstants;
import com.ericsson.cms.me.client.view.subscriptionprofile.SubscriptionProfileListPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemProxy;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

/**
 * @author   Anuj Jain
 */
public class MetadataEnhancementComponent extends ComponentBase {

    private final MEConstants constants;
    /**
     * Constructor
     */
    public MetadataEnhancementComponent() {
        constants = GWT.create( MEConstants.class);
    }

    // ========================================================================
    // ===================== COMPONENT METHODS
    // ========================================================================

    @Override
    public List<PortletFactory> listPortlets( NeptuneSecurity security ) {
        List<PortletFactory> portletFactories = new ArrayList<PortletFactory>();

        return portletFactories;
    }

    @Override
    public <E extends Service> List<E> listServices( Class<E> clazz, NeptuneSecurity security ) {
        return null;
    }

    // ========================================================================
    // ===================== Metadata Enhancement - MENU ITEMS
    // ========================================================================

    @Override
    public List<MenuItemBase> listTabs(final NeptuneSecurity security) {
        List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
        tabs.add(buildEnhancementMenu());

        return  tabs;
    }

    private MenuItemBase buildEnhancementMenu(){
        List<MenuItemBase> menuItems = new ArrayList<MenuItemBase>();
        if (ClientAuthorizationManager.isAuthorized(Permissions.ME_VIEW))
        {
            final SubscriptionProfileListPanel subscriptionProfileListPanel = new SubscriptionProfileListPanel();
            WidgetMenuItem subscriptionProfileMenuItem = new WidgetMenuItem("Enhancement", constants.componentDisplayName(), new WidgetFactory(){
                @Override
                public Widget getInstance() {
                    return subscriptionProfileListPanel;
                }

                @Override
                public void release(Widget widget) {
                }

            }, subscriptionProfileListPanel.getAnchorChangeListener());
            subscriptionProfileListPanel.setReverseAnchorChangeListener(subscriptionProfileMenuItem.getReverseAnchorChangeListener());

            menuItems.add(subscriptionProfileMenuItem);
        }

        return new MenuItemProxy(constants.contentGroupName(), menuItems);
    }

    @Override
    public String getName() {
        return "MetadataEnhancementComponent";
    }

    @Override
    public String getDisplayName() {
        return null;
    }

}
