/*
 * Created on June 20, 2012
 * 
 * (C) Copyright ERICSSON Television Inc.
 */

package com.ericsson.cms.me.client;


/**
 * The permissions used by the metadata enhancement component, 
 * and verification of the current user permissions
 * 
 * @author Anuj Jain
 */
public final class Permissions {

	/* Cannot instantiate */
	private Permissions() {
	}

	/**
	 * View permission for a metadata enhancement
	 */
	public static final String ME_VIEW = "MetadataEnhancement_View";

	/**
	 * Create permission for a metadata enhancement
	 */
	public static final String  ME_CREATE = "MetadataEnhancement_Create";

	/**
	 * Modify permission for a metadata enhancement
	 */
	public static final String  ME_MODIFY = "MetadataEnhancement_Modify";

	/**
	 * Delete permission for a metadata enhancement
	 */
	public static final String  ME_DELETE = "MetadataEnhancement_Delete";
	
	/**
	 * Enhance permission for a metadata enhancement
	 */
	public static final String  ME_ENHANCE = "MetadataEnhancement_Enhance";

	/**
	 * Modify Profile Parameter permission for a metadata enhancement
	 */
	public static final String  ME_VIEW_PROFILE_PARAMETER = "MetadataEnhancement_ViewProfileParameter";

}
