/**
 * 
 */
package com.ericsson.cms.me.client.model;

import java.util.Set;

import com.google.gwt.user.client.rpc.IsSerializable;

/**
 * @author AnujJain
 *
 */
public class UiSubscriptionProfile implements IsSerializable{
	
	private Long key;
    private String name;
    private String pluginName;
	private Set<UiSearchFieldCriteria> searchCriteria;
	private Set<UiEnhancedField> enhancedFields;
	private Set<UiProfileParam> params;
	/**
	 * @return the enhancedFields
	 */
	public Set<UiEnhancedField> getEnhancedFields() {
		return enhancedFields;
	}

	/**
	 * @param enhancedFields the enhancedFields to set
	 */
	public void setEnhancedFields(Set<UiEnhancedField> enhancedFields) {
		this.enhancedFields = enhancedFields;
	}
	
    
	
    /**
	 * @return the searchCriteria
	 */
	public Set<UiSearchFieldCriteria> getSearchCriteria() {
		return searchCriteria;
	}

	/**
	 * @param searchCriteria the searchCriteria to set
	 */
	public void setSearchCriteria(Set<UiSearchFieldCriteria> searchCriteria) {
		this.searchCriteria = searchCriteria;
	}

	/**
     * Default constructor
     */
    public UiSubscriptionProfile() {
    }

    /**
     * Constructor
     * 
     * @param key
     *            the key
     */
    public UiSubscriptionProfile( Long key ) {
        this.key = key;
    }

    
    /**
     * Get the subscription profile name
     * 
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Set the subscription profile name
     * 
     * @param name
     *            the name
     */
    public void setName( String name ) {
        this.name = name;
    }

    /**
     * Get the key
     * 
     * @return the key
     */
    public Long getKey() {
        return key;
    }

    /**
     * Set the key
     * 
     * @param key
     *            the key to set
     */
    public void setKey( Long key ) {
        this.key = key;
    }

    /**
     * Get the subscription profile plugin name
     * 
     * @return the name
     */
    public String getPluginName() {
        return pluginName;
    }

    /**
     * Set the subscription profile plugin name
     * 
     * @param name
     *            the name
     */
    public void setPluginName( String pluginName ) {
        this.pluginName = pluginName;
    }
	
	/**
	 * @return the params
	 */
	public Set<UiProfileParam> getParams() {
		return params;
	}
	/**
	 * @param params the params to set
	 */
	public void setParams(Set<UiProfileParam> params) {
		this.params = params;
	}



}
