/**
 * 
 */
package com.ericsson.cms.me.client.rpc;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.ericsson.cms.me.client.model.SubscriptionProfileSearchResult;
import com.ericsson.cms.me.client.model.UiCacheResult;
import com.ericsson.cms.me.client.model.UiEnhancedField;
import com.ericsson.cms.me.client.model.UiSubscriptionProfile;
import com.ericsson.cms.me.client.model.UiTitle;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * @author AnujJain
 *
 */

@RemoteServiceRelativePath("service/me/meManagerService")
public interface IMEManagerService extends RemoteService {
	
	SubscriptionProfileSearchResult getSubscriptionProfileList() throws NeptuneException;
	
	UiSubscriptionProfile getSubscriptionProfile(long subscriptionProfileKey);

	List<String> getPluginsList() throws NeptuneException;

	List<UiEnhancedField> getEnhancedFields(String pluginName);
	
	List<UiSubscriptionProfile> getProfilesToDeconflict(String requestKey);

	List<UiCacheResult> getConflictsToResolve(Long profileId, String requestKey);

	UiTitle getOriginalTitle(String requestKey) throws NeptuneException;

	UiSubscriptionProfile saveSubscriptionProfile (UiSubscriptionProfile uiProfile) throws NeptuneException;
	
	void updateCacheResultStatus(String requestKey, Long profileId, Long meCacheResultId, String status);

	Boolean isProfileResolved(Long profileId, String requestKey);

	Boolean requiresConflictResolution(String requestKey);

	void updateCacheResultStatus(String requestKey, String status);

	Boolean deleteSubscriptionProfiles(List<UiSubscriptionProfile> list) throws NeptuneException;

	Set<String> getProfilePluginParams(String pluginName);

	Map<String, String> getUIPropertiesMap();

}
