/**
 * 
 */
package com.ericsson.cms.me.client.rpc;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.ericsson.cms.me.client.model.SubscriptionProfileSearchResult;
import com.ericsson.cms.me.client.model.UiCacheResult;
import com.ericsson.cms.me.client.model.UiEnhancedField;
import com.ericsson.cms.me.client.model.UiSubscriptionProfile;
import com.ericsson.cms.me.client.model.UiTitle;
import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * @author AnujJain
 *
 */
public interface IMEManagerServiceAsync {
	
	void getSubscriptionProfileList(AsyncCallback<SubscriptionProfileSearchResult> callback);
	
	void getSubscriptionProfile(long subscriptionProfileKey, AsyncCallback<UiSubscriptionProfile> callback);
	
	void getPluginsList(AsyncCallback<List<String>> callback);
	
	void getEnhancedFields(String pluginName, AsyncCallback<List<UiEnhancedField>> callback);

	void getProfilesToDeconflict(String requestKey, AsyncCallback<List<UiSubscriptionProfile>> callback);
	
	void getConflictsToResolve(Long profileId, String requestKey, AsyncCallback<List<UiCacheResult>> callback);

	void getOriginalTitle(String requestKey, AsyncCallback<UiTitle> callback);
	
	void saveSubscriptionProfile(UiSubscriptionProfile uiProfile, AsyncCallback<UiSubscriptionProfile> callback ); 

	void updateCacheResultStatus(String requestKey, Long profileId, Long meCacheResultId, String status, AsyncCallback<Void> callback);
	
	void isProfileResolved(Long profileId, String requestKey, AsyncCallback<Boolean> callback);
	
	void requiresConflictResolution(String requestKey, AsyncCallback<Boolean> callback);
	
	void updateCacheResultStatus(String requestKey, String status, AsyncCallback<Void> callback);
	
	/**
     * Deletes a given subscription profile
     * 
     * @param list
     *            the subscription profile list to be deleted
     * @param callback
     *            the callback to return the results
     */
    void deleteSubscriptionProfiles( List<UiSubscriptionProfile> list, AsyncCallback<Boolean> callback );
    
    void getProfilePluginParams(String pluginName,  AsyncCallback<Set<String>> callback);
    
    void getUIPropertiesMap(AsyncCallback<Map<String, String>> callback);
 	
}
